/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */

/*
 * jPanelFusesHexEditor.java
 *
 * Created on 17.01.2009, 12:04:06
 */

package avr8_burn_o_mat;

import java.util.Vector;

/**
 *
 * @author torsten
 */
public class JPanelFusesHexEditor
extends javax.swing.JPanel
implements FusesObserver {

    private AVR m_avr;
    private FusesEditor m_fusesEditor;

    private Vector <JPanelFusesHexEditorItem> m_fuseItems = new Vector <JPanelFusesHexEditorItem>();
    
    /** Creates new form jPanelFusesHexEditor */
    public JPanelFusesHexEditor(FusesEditor fusesEditor) {
        initComponents();

        m_fusesEditor = fusesEditor;
        m_fusesEditor.getFusesObservable().addObserver(this);

    }

    public void fusesChanged() {

        if (m_avr == null)
            return;

        Vector <String> fuseBytes = m_avr.getUsedFuseBytes();
        int idx;

        for (idx = 0; idx < fuseBytes.size(); idx++) {

            int data = m_avr.getFuseByteData(fuseBytes.elementAt(idx));

            m_fuseItems.elementAt(idx).setVal(data);

        }

    }

    public void setAVR(AVR avr) {

        m_avr = avr;

        for (JPanelFusesHexEditorItem it : m_fuseItems)
            remove(it);

        m_fuseItems.clear();

        int y = 20;

        Vector <String> fuseBytes = m_avr.getUsedFuseBytes();

        for (String fuseByte : fuseBytes) {
            JPanelFusesHexEditorItem item = new JPanelFusesHexEditorItem(fuseByte);
            m_fuseItems.add(item);
            add(item);
            item.setLocation(10, y);
            item.setSize(item.getPreferredSize());
            y += item.getHeight();
            item.setVisible(true);
        }

        jButtonApply.setLocation(10, y + 20);
        
        fusesChanged();
    }



    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    @SuppressWarnings("unchecked")
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {

        jButtonApply = new javax.swing.JButton();

        setLayout(null);

        jButtonApply.setText("apply");
        jButtonApply.setPreferredSize(new java.awt.Dimension(100, 29));
        jButtonApply.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jButtonApplyActionPerformed(evt);
            }
        });
        add(jButtonApply);
        jButtonApply.setBounds(10, 10, 100, 29);
    }// </editor-fold>//GEN-END:initComponents

    private void jButtonApplyActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jButtonApplyActionPerformed

        if (m_avr == null)
            return;

        for (JPanelFusesHexEditorItem item : m_fuseItems)
            m_avr.setFuseByteData(item.getFuseByteName(), item.getVal());

        m_fusesEditor.getFusesObservable().fusesChanged(this);
    }//GEN-LAST:event_jButtonApplyActionPerformed


    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JButton jButtonApply;
    // End of variables declaration//GEN-END:variables

}
