/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.pagedesigner.css2.property;

import org.eclipse.jst.pagedesigner.css2.ICSSStyle;
import org.eclipse.jst.pagedesigner.css2.property.LengthMeta;
import org.eclipse.jst.pagedesigner.utils.DOMUtil;
import org.w3c.dom.Element;

public class VerticalAlignMeta
extends LengthMeta {
    public static final String BASELINE = "baseline";
    public static final String MIDDLE = "middle";
    public static final String SUB = "sub";
    public static final String SUPER = "super";
    public static final String TEXT_TOP = "text-top";
    public static final String TEXT_BOTTOM = "text-bottom";
    public static final String TOP = "top";
    public static final String BOTTOM = "bottom";
    public static final String CENTER = "center";
    public static final String DEFAULT_VERTICAL_ALIGN = "baseline";
    private static final String[] KEYWORDS = new String[]{"baseline", "middle", "sub", "super", "text-top", "text-bottom", "top", "bottom"};
    private static final String[] htmlAttributes = new String[]{"valign"};

    public VerticalAlignMeta() {
        super(true, "baseline");
    }

    public VerticalAlignMeta(boolean inherit, Object initvalue) {
        super(inherit, initvalue);
    }

    protected String[] getKeywordValues() {
        return KEYWORDS;
    }

    public Object calculateHTMLAttributeOverride(Element element, String htmltag, String propertyName, ICSSStyle style) {
        int i = 0;
        while (i < htmlAttributes.length) {
            String align = DOMUtil.getAttributeIgnoreCase(element, htmlAttributes[i]);
            if (TOP.equalsIgnoreCase(align)) {
                return TOP;
            }
            if (MIDDLE.equalsIgnoreCase(align)) {
                return MIDDLE;
            }
            if (BOTTOM.equalsIgnoreCase(align)) {
                return BOTTOM;
            }
            if ("baseline".equalsIgnoreCase(align)) {
                return "baseline";
            }
            if (CENTER.equalsIgnoreCase(align)) {
                return MIDDLE;
            }
            ++i;
        }
        return null;
    }
}

