/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.ws.internal.jaxws.ui.views;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jdt.core.IAnnotatable;
import org.eclipse.jdt.core.IAnnotation;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IField;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.ILocalVariable;
import org.eclipse.jdt.core.IMemberValuePair;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.Signature;
import org.eclipse.jdt.core.dom.AST;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ASTParser;
import org.eclipse.jdt.core.dom.Annotation;
import org.eclipse.jdt.core.dom.ArrayInitializer;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jdt.core.dom.MemberValuePair;
import org.eclipse.jdt.core.dom.NormalAnnotation;
import org.eclipse.jdt.core.dom.SingleMemberAnnotation;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.CheckboxCellEditor;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ComboBoxCellEditor;
import org.eclipse.jface.viewers.EditingSupport;
import org.eclipse.jface.viewers.ICellEditorValidator;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jst.ws.annotations.core.AnnotationsCore;
import org.eclipse.jst.ws.annotations.core.AnnotationsCorePlugin;
import org.eclipse.jst.ws.annotations.core.AnnotationsManager;
import org.eclipse.jst.ws.annotations.core.initialization.IAnnotationAttributeInitializer;
import org.eclipse.jst.ws.annotations.core.utils.AnnotationUtils;
import org.eclipse.jst.ws.internal.annotations.core.utils.SignatureUtils;
import org.eclipse.jst.ws.internal.jaxws.ui.JAXWSUIMessages;
import org.eclipse.jst.ws.internal.jaxws.ui.JAXWSUIPlugin;
import org.eclipse.jst.ws.internal.jaxws.ui.views.AnnotationArrayCellEditor;
import org.eclipse.jst.ws.internal.jaxws.ui.views.AnnotationsView;
import org.eclipse.jst.ws.internal.jaxws.ui.views.ClassDialogCellEditor;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.IUndoManager;
import org.eclipse.ltk.core.refactoring.RefactoringCore;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.ltk.core.refactoring.TextFileChange;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.text.edits.MultiTextEdit;
import org.eclipse.text.edits.TextEdit;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AnnotationsValuesEditingSupport
extends EditingSupport {
    private AnnotationsView annotationsView;
    private TreeViewer treeViewer;
    private TextCellEditor textCellEditor;
    private CheckboxCellEditor checkboxCellEditor;
    private ComboBoxCellEditor comboBoxCellEditor;
    private ClassDialogCellEditor classDialogCellEditor;
    private AnnotationArrayCellEditor annotationArrayCellEditor;

    public AnnotationsValuesEditingSupport(AnnotationsView annotationsView, TreeViewer treeViewer) {
        super((ColumnViewer)treeViewer);
        this.treeViewer = treeViewer;
        this.annotationsView = annotationsView;
        this.textCellEditor = new TextCellEditor((Composite)treeViewer.getTree());
        this.checkboxCellEditor = new CheckboxCellEditor((Composite)treeViewer.getTree());
        this.comboBoxCellEditor = new ComboBoxCellEditor((Composite)treeViewer.getTree(), new String[0]);
        this.classDialogCellEditor = new ClassDialogCellEditor((Composite)treeViewer.getTree());
        this.annotationArrayCellEditor = new AnnotationArrayCellEditor((Composite)treeViewer.getTree(), new Object[0]);
    }

    protected boolean canEdit(Object element) {
        if (element instanceof IMethod) {
            IMethod method = (IMethod)element;
            return (Boolean)this.getValue(method.getDeclaringType());
        }
        return true;
    }

    protected CellEditor getCellEditor(Object element) {
        if (element instanceof IType) {
            return this.checkboxCellEditor;
        }
        if (element instanceof IMethod) {
            try {
                IMethod method = (IMethod)element;
                IType enumType = SignatureUtils.getEnumReturnType((IMethod)method);
                if (enumType != null) {
                    this.comboBoxCellEditor.setItems(SignatureUtils.getEnumConstantsNames((IType)enumType));
                    return this.comboBoxCellEditor;
                }
                final String returnType = method.getReturnType();
                if (SignatureUtils.isBoolean((String)returnType)) {
                    return this.checkboxCellEditor;
                }
                if (SignatureUtils.isClass((String)returnType)) {
                    return this.classDialogCellEditor;
                }
                if (SignatureUtils.isArray((String)returnType)) {
                    this.annotationArrayCellEditor.setMethod(method);
                    return this.annotationArrayCellEditor;
                }
                if (SignatureUtils.isPrimitive((String)returnType)) {
                    this.textCellEditor.setValidator(new ICellEditorValidator(){

                        public String isValid(Object value) {
                            try {
                                if (returnType.charAt(0) == 'B') {
                                    Byte.parseByte((String)value);
                                }
                                if (returnType.charAt(0) == 'S') {
                                    Short.parseShort((String)value);
                                }
                                if (returnType.charAt(0) == 'I') {
                                    Integer.parseInt((String)value);
                                }
                                if (returnType.charAt(0) == 'J') {
                                    Long.parseLong((String)value);
                                }
                                if (returnType.charAt(0) == 'F') {
                                    Float.parseFloat((String)value);
                                }
                                if (returnType.charAt(0) == 'D') {
                                    Double.parseDouble((String)value);
                                }
                            }
                            catch (NumberFormatException numberFormatException) {
                                return String.valueOf(JAXWSUIMessages.ANNOTATION_EDITING_SUPPORT_NOT_VALID_MESSAGE_PREFIX) + value;
                            }
                            return null;
                        }
                    });
                    return this.textCellEditor;
                }
                return this.textCellEditor;
            }
            catch (JavaModelException jme) {
                JAXWSUIPlugin.log(jme.getStatus());
            }
        }
        return this.checkboxCellEditor;
    }

    protected Object getValue(Object element) {
        if (element instanceof IType) {
            return this.getValueForClass((IType)element);
        }
        if (element instanceof IMethod) {
            return this.getValueForMethod((IMethod)element);
        }
        return null;
    }

    private Object getValueForClass(IType type) {
        if (this.treeViewer.getInput() instanceof IAnnotatable) {
            return this.getValueForClass(type, (IAnnotatable)this.treeViewer.getInput());
        }
        return Boolean.FALSE;
    }

    private Object getValueForClass(IType type, IAnnotatable annotatedElement) {
        ILocalVariable localVariable;
        if (annotatedElement instanceof ILocalVariable && (localVariable = this.getLocalVariable(annotatedElement)) != null) {
            annotatedElement = localVariable;
        }
        try {
            IAnnotation[] annotations;
            IAnnotation[] iAnnotationArray = annotations = annotatedElement.getAnnotations();
            int n = annotations.length;
            int n2 = 0;
            while (n2 < n) {
                IAnnotation annotation = iAnnotationArray[n2];
                String annotationName = annotation.getElementName();
                if (AnnotationUtils.isAnnotationPresent((IJavaElement)((IJavaElement)annotatedElement), (String)annotationName) && (annotationName.equals(type.getElementName()) || annotationName.equals(type.getFullyQualifiedName()))) {
                    return Boolean.TRUE;
                }
                ++n2;
            }
        }
        catch (JavaModelException jme) {
            JAXWSUIPlugin.log(jme.getStatus());
        }
        return Boolean.FALSE;
    }

    private Object getValueForMethod(IMethod method) {
        Object value = null;
        try {
            if (this.treeViewer.getInput() instanceof IAnnotatable) {
                value = this.getValueForMethod(method, (IAnnotatable)this.treeViewer.getInput());
            }
        }
        catch (JavaModelException jme) {
            JAXWSUIPlugin.log(jme.getStatus());
        }
        return value;
    }

    private Object getValueForMethod(IMethod method, IAnnotatable annotatedElement) throws JavaModelException {
        IAnnotation[] annotations;
        ILocalVariable localVariable;
        if (annotatedElement instanceof ILocalVariable && (localVariable = this.getLocalVariable(annotatedElement)) != null) {
            annotatedElement = localVariable;
        }
        String returnType = method.getReturnType();
        IAnnotation[] iAnnotationArray = annotations = annotatedElement.getAnnotations();
        int n = annotations.length;
        int n2 = 0;
        while (n2 < n) {
            IAnnotation annotation = iAnnotationArray[n2];
            IType declaringType = method.getDeclaringType();
            String annotationName = annotation.getElementName();
            if (annotationName.equals(declaringType.getElementName()) || annotationName.equals(declaringType.getFullyQualifiedName())) {
                IMemberValuePair[] memberValuePairs;
                IMemberValuePair[] iMemberValuePairArray = memberValuePairs = annotation.getMemberValuePairs();
                int n3 = memberValuePairs.length;
                int n4 = 0;
                while (n4 < n3) {
                    IMemberValuePair memberValuePair = iMemberValuePairArray[n4];
                    if (memberValuePair.getMemberName().equals(method.getElementName())) {
                        if (SignatureUtils.isString((String)returnType)) {
                            return memberValuePair.getValue();
                        }
                        IType enumType = SignatureUtils.getEnumReturnType((IMethod)method);
                        if (enumType != null) {
                            String enumValue = memberValuePair.getValue().toString();
                            String literal = enumValue.substring(enumValue.lastIndexOf(".") + 1);
                            String[] enumConstants = SignatureUtils.getEnumConstantsNames((IType)enumType);
                            int i = 0;
                            while (i < enumConstants.length) {
                                if (enumConstants[i].equals(literal)) {
                                    return i;
                                }
                                ++i;
                            }
                        }
                        if (SignatureUtils.isClass((String)returnType)) {
                            return memberValuePair.getValue();
                        }
                        if (SignatureUtils.isBoolean((String)returnType)) {
                            return memberValuePair.getValue();
                        }
                        if (SignatureUtils.isPrimitive((String)returnType)) {
                            return "";
                        }
                        if (SignatureUtils.isArray((String)returnType)) {
                            if (memberValuePair.getValueKind() == 11) {
                                Object[] arrayValues = (Object[])memberValuePair.getValue();
                                int i = 0;
                                while (i < arrayValues.length) {
                                    String value = arrayValues[i].toString();
                                    arrayValues[i] = String.valueOf(value) + ".class";
                                    ++i;
                                }
                                return arrayValues;
                            }
                            return memberValuePair.getValue();
                        }
                    }
                    ++n4;
                }
                return this.getDefaultValueForMethod(method);
            }
            ++n2;
        }
        return null;
    }

    private Object getDefaultValueForMethod(IMethod method) throws JavaModelException {
        String returnType = method.getReturnType();
        if (SignatureUtils.isString((String)returnType)) {
            return "";
        }
        if (SignatureUtils.isBoolean((String)returnType)) {
            return Boolean.FALSE;
        }
        if (SignatureUtils.isEnum((IMethod)method)) {
            return -1;
        }
        if (SignatureUtils.isPrimitive((String)returnType)) {
            return "";
        }
        if (SignatureUtils.isArray((String)returnType)) {
            return new Object[0];
        }
        return null;
    }

    private ILocalVariable getLocalVariable(IAnnotatable annotatedElement) {
        IMethod parent;
        ILocalVariable localVariable = (ILocalVariable)annotatedElement;
        if (localVariable.getParent() instanceof IMethod && (localVariable = AnnotationUtils.getLocalVariable((IMethod)(parent = (IMethod)localVariable.getParent()), (String)localVariable.getElementName())) != null) {
            return localVariable;
        }
        return null;
    }

    protected void setValue(Object element, Object value) {
        if (value == null) {
            return;
        }
        try {
            if (element instanceof IType && ((IType)element).isAnnotation()) {
                this.setValueForClass((IType)element, (Boolean)value);
            }
            if (element instanceof IMethod) {
                this.setValueForMethod((IMethod)element, value);
            }
        }
        catch (CoreException ce) {
            JAXWSUIPlugin.log(ce.getStatus());
        }
    }

    private void setValueForClass(IType type, Boolean annotate) throws CoreException {
        Object viewerInput = this.treeViewer.getInput();
        IAnnotationAttributeInitializer annotationAttributeInitializer = AnnotationsManager.getAnnotationDefinitionForClass((String)type.getFullyQualifiedName()).getAnnotationAttributeInitializer();
        if (viewerInput instanceof IJavaElement) {
            this.setValueForClass(type, annotate, (IJavaElement)viewerInput, annotationAttributeInitializer);
        }
    }

    private Annotation getAnnotation(AST ast, IType type, List<MemberValuePair> memberValuePairs) throws JavaModelException {
        Object annotation = null;
        int numberOfDeclaredMethods = type.getMethods().length;
        if (numberOfDeclaredMethods == 0) {
            annotation = AnnotationsCore.createMarkerAnnotation((AST)ast, (String)type.getElementName());
        } else if (numberOfDeclaredMethods == 1) {
            MemberValuePair memberValuePair;
            Expression value = null;
            if (memberValuePairs != null && memberValuePairs.size() == 1 && (memberValuePair = memberValuePairs.get(0)) != null) {
                value = memberValuePair.getValue();
            }
            annotation = value != null ? AnnotationsCore.createSingleMemberAnnotation((AST)ast, (String)type.getElementName(), value) : AnnotationsCore.createNormalAnnotation((AST)ast, (String)type.getElementName(), memberValuePairs);
        } else if (numberOfDeclaredMethods > 1) {
            annotation = AnnotationsCore.createNormalAnnotation((AST)ast, (String)type.getElementName(), memberValuePairs);
        }
        return annotation;
    }

    private void setValueForClass(IType type, Boolean annotate, IJavaElement javaElement, IAnnotationAttributeInitializer annotationAttributeInitializer) throws CoreException {
        ICompilationUnit source = AnnotationUtils.getCompilationUnitFromJavaElement((IJavaElement)javaElement);
        CompilationUnit compilationUnit = this.getAST(source);
        AST ast = compilationUnit.getAST();
        List<MemberValuePair> memberValuePairs = this.getMemberValuePairs(annotationAttributeInitializer, javaElement, ast, type);
        Annotation annotation = this.getAnnotation(ast, type, memberValuePairs);
        TextFileChange change = new TextFileChange("Add/Remove Annotation", (IFile)source.getResource());
        MultiTextEdit multiTextEdit = new MultiTextEdit();
        change.setEdit((TextEdit)multiTextEdit);
        if (annotate.booleanValue()) {
            if (javaElement.getElementType() == 11 || javaElement.getElementType() == 7 || javaElement.getElementType() == 8 || javaElement.getElementType() == 9 || javaElement.getElementType() == 14) {
                change.addEdit(AnnotationUtils.createAddImportTextEdit((IJavaElement)javaElement, (String)type.getFullyQualifiedName()));
                change.addEdit(AnnotationUtils.createAddAnnotationTextEdit((IJavaElement)javaElement, (Annotation)annotation));
            }
        } else if (javaElement.getElementType() == 11 || javaElement.getElementType() == 7 || javaElement.getElementType() == 8 || javaElement.getElementType() == 9 || javaElement.getElementType() == 14) {
            change.addEdit(AnnotationUtils.createRemoveImportTextEdit((IJavaElement)javaElement, (String)type.getFullyQualifiedName()));
            change.addEdit(AnnotationUtils.createRemoveAnnotationTextEdit((IJavaElement)javaElement, (Annotation)annotation));
        }
        this.executeChange((IProgressMonitor)new NullProgressMonitor(), (Change)change);
    }

    private List<MemberValuePair> getMemberValuePairs(IAnnotationAttributeInitializer annotationAttributeInitializer, IJavaElement javaElement, AST ast, IType type) {
        if (annotationAttributeInitializer != null) {
            List memberValuePairs = annotationAttributeInitializer.getMemberValuePairs(javaElement, ast, type);
            if (memberValuePairs.size() > 0) {
                return memberValuePairs;
            }
            return annotationAttributeInitializer.getMemberValuePairs(javaElement, ast, AnnotationsManager.getAnnotationDefinitionForType((IType)type).getAnnotationClass());
        }
        return Collections.emptyList();
    }

    private void setValueForMethod(IMethod method, Object value) throws CoreException {
        Object viewerInput;
        Object currentValue;
        if (value instanceof String && (currentValue = this.getValue(method)) != null && currentValue instanceof String && ((String)value).equals(currentValue)) {
            return;
        }
        if (((Boolean)this.getValue(method.getDeclaringType())).booleanValue() && (viewerInput = this.treeViewer.getInput()) instanceof IAnnotatable) {
            this.setValueForMethod(method, value, (IJavaElement)viewerInput);
        }
    }

    private void setValueForMethod(IMethod method, Object value, IJavaElement javaElement) throws CoreException {
        ICompilationUnit source = AnnotationUtils.getCompilationUnitFromJavaElement((IJavaElement)javaElement);
        CompilationUnit compilationUnit = this.getAST(source);
        AST ast = compilationUnit.getAST();
        TextFileChange change = new TextFileChange("Add/Update Annotation Value", (IFile)source.getResource());
        MultiTextEdit multiTextEdit = new MultiTextEdit();
        change.setEdit((TextEdit)multiTextEdit);
        List annotations = AnnotationUtils.getAnnotations((IJavaElement)javaElement);
        for (Annotation annotation : annotations) {
            MemberValuePair memberValuePair;
            String annotationName;
            IType declaringType;
            if (annotation instanceof NormalAnnotation) {
                MemberValuePair memberValuePair22;
                NormalAnnotation normalAnnotation = (NormalAnnotation)annotation;
                declaringType = method.getDeclaringType();
                annotationName = normalAnnotation.getTypeName().getFullyQualifiedName();
                if (!annotationName.equals(declaringType.getElementName()) && !annotationName.equals(declaringType.getFullyQualifiedName())) continue;
                List memberValuePairs = normalAnnotation.values();
                boolean hasMemberValuePair = false;
                for (MemberValuePair memberValuePair22 : memberValuePairs) {
                    ASTNode memberValue;
                    if (!memberValuePair22.getName().getIdentifier().equals(method.getElementName()) || (memberValue = this.getMemberValuePairValue(ast, method, value)) == null) continue;
                    change.addEdit(AnnotationUtils.createUpdateMemberValuePairTextEdit((MemberValuePair)memberValuePair22, (ASTNode)memberValue));
                    hasMemberValuePair = true;
                    break;
                }
                if (hasMemberValuePair || (memberValuePair22 = this.getMemberValuePair(ast, method, value)) == null) continue;
                change.addEdit(AnnotationUtils.createAddMemberValuePairTextEdit((NormalAnnotation)normalAnnotation, (MemberValuePair)memberValuePair22));
                break;
            }
            if (!(annotation instanceof SingleMemberAnnotation)) continue;
            SingleMemberAnnotation singleMemberAnnotation = (SingleMemberAnnotation)annotation;
            declaringType = method.getDeclaringType();
            annotationName = singleMemberAnnotation.getTypeName().getFullyQualifiedName();
            if (!annotationName.equals(declaringType.getElementName()) && !annotationName.equals(declaringType.getFullyQualifiedName()) || (memberValuePair = this.getMemberValuePair(ast, method, value)) == null) continue;
            change.addEdit(AnnotationUtils.createUpdateSingleMemberAnnotationTextEdit((SingleMemberAnnotation)singleMemberAnnotation, (ASTNode)memberValuePair.getValue()));
            break;
        }
        this.executeChange((IProgressMonitor)new NullProgressMonitor(), (Change)change);
    }

    private MemberValuePair getMemberValuePair(AST ast, IMethod method, Object value) throws JavaModelException {
        int selected;
        IType componentType;
        String returnType = method.getReturnType();
        if (SignatureUtils.isString((String)returnType)) {
            return AnnotationsCore.createStringMemberValuePair((AST)ast, (String)method.getElementName(), (String)((String)value));
        }
        if (SignatureUtils.isBoolean((String)returnType)) {
            return AnnotationsCore.createBooleanMemberValuePair((AST)ast, (String)method.getElementName(), (Boolean)((Boolean)value));
        }
        if (SignatureUtils.isPrimitive((String)returnType) && (returnType.charAt(0) == 'B' || returnType.charAt(0) == 'S' || returnType.charAt(0) == 'I' || returnType.charAt(0) == 'J' || returnType.charAt(0) == 'F' || returnType.charAt(0) == 'D')) {
            return AnnotationsCore.createNumberMemberValuePair((AST)ast, (String)method.getElementName(), (String)value.toString());
        }
        if (SignatureUtils.isArray((String)returnType) && (componentType = this.getComponentType(method)) != null) {
            if (componentType.isAnnotation()) {
                return this.createArrayMemberValuePair(ast, method, (Object[])value);
            }
            return AnnotationsCore.createArrayMemberValuePair((AST)ast, (String)method.getElementName(), (Object[])((Object[])value));
        }
        if (SignatureUtils.isClass((String)returnType)) {
            return AnnotationsCore.createTypeMemberValuePair((AST)ast, (String)method.getElementName(), (Object)value.toString());
        }
        IType enumType = SignatureUtils.getEnumReturnType((IMethod)method);
        if (enumType != null && (selected = ((Integer)value).intValue()) != -1) {
            if (enumType.isMember()) {
                return AnnotationsCore.createEnumMemberValuePair((AST)ast, (String)enumType.getDeclaringType().getFullyQualifiedName(), (String)method.getElementName(), (Object)SignatureUtils.getEnumConstants((IType)enumType)[selected]);
            }
            return AnnotationsCore.createEnumMemberValuePair((AST)ast, (String)enumType.getFullyQualifiedName(), (String)method.getElementName(), (Object)SignatureUtils.getEnumConstants((IType)enumType)[selected]);
        }
        return null;
    }

    private ASTNode getMemberValuePairValue(AST ast, IMethod method, Object value) throws JavaModelException {
        int selected;
        IType componentType;
        String returnType = method.getReturnType();
        if (SignatureUtils.isString((String)returnType)) {
            return AnnotationsCore.createStringLiteral((AST)ast, (String)value.toString());
        }
        if (SignatureUtils.isBoolean((String)returnType)) {
            return AnnotationsCore.createBooleanLiteral((AST)ast, (boolean)((Boolean)value));
        }
        if (SignatureUtils.isPrimitive((String)returnType) && (returnType.charAt(0) == 'B' || returnType.charAt(0) == 'S' || returnType.charAt(0) == 'I' || returnType.charAt(0) == 'J' || returnType.charAt(0) == 'F' || returnType.charAt(0) == 'D')) {
            return AnnotationsCore.createNumberLiteral((AST)ast, (String)value.toString());
        }
        if (SignatureUtils.isArray((String)returnType) && (componentType = this.getComponentType(method)) != null) {
            if (componentType.isAnnotation()) {
                return this.createArrayValueLiteral(ast, method, (Object[])value);
            }
            return AnnotationsCore.createArrayValueLiteral((AST)ast, (Object[])((Object[])value));
        }
        if (SignatureUtils.isClass((String)returnType)) {
            return AnnotationsCore.createTypeLiteral((AST)ast, (String)value.toString());
        }
        IType enumType = SignatureUtils.getEnumReturnType((IMethod)method);
        if (enumType != null && (selected = ((Integer)value).intValue()) != -1) {
            if (enumType.isMember()) {
                return AnnotationsCore.createEnumLiteral((AST)ast, (String)enumType.getDeclaringType().getFullyQualifiedName(), (IField)SignatureUtils.getEnumConstants((IType)enumType)[selected]);
            }
            return AnnotationsCore.createEnumLiteral((AST)ast, (String)enumType.getFullyQualifiedName(), (IField)SignatureUtils.getEnumConstants((IType)enumType)[selected]);
        }
        return null;
    }

    private void executeChange(IProgressMonitor monitor, Change change) {
        Change undoChange;
        IUndoManager manager;
        block8: {
            if (change == null) {
                return;
            }
            manager = RefactoringCore.getUndoManager();
            boolean successful = false;
            undoChange = null;
            try {
                try {
                    change.initializeValidationData(monitor);
                    RefactoringStatus valid = change.isValid(monitor);
                    if (valid.isOK()) {
                        manager.aboutToPerformChange(change);
                        undoChange = change.perform(monitor);
                        successful = true;
                    }
                }
                catch (CoreException ce) {
                    JAXWSUIPlugin.log(ce.getStatus());
                    manager.changePerformed(change, successful);
                    break block8;
                }
            }
            catch (Throwable throwable) {
                manager.changePerformed(change, successful);
                throw throwable;
            }
            manager.changePerformed(change, successful);
        }
        if (undoChange != null) {
            undoChange.initializeValidationData(monitor);
            manager.addUndo(undoChange.getName(), undoChange);
        }
        this.annotationsView.refreshLabels();
    }

    private MemberValuePair createArrayMemberValuePair(AST ast, IMethod method, Object[] values) throws JavaModelException {
        return AnnotationsCore.createMemberValuePair((AST)ast, (String)method.getElementName(), (Expression)this.createArrayValueLiteral(ast, method, values));
    }

    private IType getComponentType(IMethod method) throws JavaModelException {
        String returnType = method.getReturnType();
        if (SignatureUtils.isArray((String)returnType)) {
            String elementType = Signature.getElementType((String)returnType);
            IType declaringType = method.getDeclaringType();
            IJavaProject javaProject = declaringType.getJavaProject();
            if (javaProject != null) {
                return javaProject.findType(Signature.toString((String)elementType));
            }
        }
        return null;
    }

    private ArrayInitializer createArrayValueLiteral(AST ast, IMethod method, Object[] values) throws JavaModelException {
        ArrayInitializer arrayInitializer = ast.newArrayInitializer();
        Object[] objectArray = values;
        int n = values.length;
        int n2 = 0;
        while (n2 < n) {
            IType componentType;
            Object value = objectArray[n2];
            if (value instanceof List && (componentType = this.getComponentType(method)) != null) {
                ArrayList<MemberValuePair> memberValuePairs = new ArrayList<MemberValuePair>();
                List valuesList = (List)value;
                for (Map annotationMap : valuesList) {
                    Set entrySet = annotationMap.entrySet();
                    for (Map.Entry entry : entrySet) {
                        String memberName = (String)entry.getKey();
                        try {
                            IMethod annotationMethod = componentType.getMethod(memberName, new String[0]);
                            if (annotationMethod == null) continue;
                            Object memberValue = entry.getValue();
                            String returnType = annotationMethod.getReturnType();
                            if (SignatureUtils.isString((String)returnType)) {
                                memberValuePairs.add(AnnotationsCore.createStringMemberValuePair((AST)ast, (String)memberName, (String)memberValue.toString()));
                            }
                            if (SignatureUtils.isBoolean((String)returnType)) {
                                memberValuePairs.add(AnnotationsCore.createBooleanMemberValuePair((AST)ast, (String)memberName, (Boolean)((Boolean)memberValue)));
                            }
                            if (!SignatureUtils.isClass((String)returnType)) continue;
                            String className = memberValue.toString();
                            if (className.endsWith(".class")) {
                                className = className.substring(0, className.lastIndexOf("."));
                            }
                            memberValuePairs.add(AnnotationsCore.createMemberValuePair((AST)ast, (String)memberName, (Expression)AnnotationsCore.createTypeLiteral((AST)ast, (String)className)));
                        }
                        catch (SecurityException se) {
                            AnnotationsCorePlugin.log((Throwable)se);
                        }
                    }
                }
                arrayInitializer.expressions().add(AnnotationsCore.createNormalAnnotation((AST)ast, (String)componentType.getFullyQualifiedName(), memberValuePairs));
            }
            ++n2;
        }
        return arrayInitializer;
    }

    private CompilationUnit getAST(ICompilationUnit source) {
        ASTParser parser = ASTParser.newParser((int)3);
        parser.setSource(source);
        return (CompilationUnit)parser.createAST(null);
    }
}

