/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.oomph.p2.internal.core;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.EventObject;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.core.runtime.URIUtil;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.URIConverter;
import org.eclipse.equinox.internal.p2.engine.BeginOperationEvent;
import org.eclipse.equinox.internal.p2.engine.CommitOperationEvent;
import org.eclipse.equinox.internal.p2.engine.RollbackOperationEvent;
import org.eclipse.equinox.internal.p2.engine.TransactionEvent;
import org.eclipse.equinox.internal.p2.repository.Transport;
import org.eclipse.equinox.internal.p2.touchpoint.natives.Util;
import org.eclipse.equinox.internal.p2.update.Configuration;
import org.eclipse.equinox.internal.p2.update.Site;
import org.eclipse.equinox.internal.provisional.p2.core.eventbus.IProvisioningEventBus;
import org.eclipse.equinox.internal.provisional.p2.core.eventbus.ProvisioningListener;
import org.eclipse.equinox.internal.provisional.p2.core.eventbus.SynchronousProvisioningListener;
import org.eclipse.equinox.p2.core.IAgentLocation;
import org.eclipse.equinox.p2.core.IProvisioningAgent;
import org.eclipse.equinox.p2.core.IProvisioningAgentProvider;
import org.eclipse.equinox.p2.core.ProvisionException;
import org.eclipse.equinox.p2.core.spi.IAgentService;
import org.eclipse.equinox.p2.engine.IEngine;
import org.eclipse.equinox.p2.engine.IProfile;
import org.eclipse.equinox.p2.engine.IProfileRegistry;
import org.eclipse.equinox.p2.metadata.IArtifactKey;
import org.eclipse.equinox.p2.metadata.IInstallableUnit;
import org.eclipse.equinox.p2.planner.IPlanner;
import org.eclipse.equinox.p2.query.QueryUtil;
import org.eclipse.equinox.p2.repository.artifact.IArtifactRepositoryManager;
import org.eclipse.equinox.p2.repository.artifact.IFileArtifactRepository;
import org.eclipse.equinox.p2.repository.metadata.IMetadataRepositoryManager;
import org.eclipse.oomph.p2.P2Exception;
import org.eclipse.oomph.p2.core.Agent;
import org.eclipse.oomph.p2.core.AgentManager;
import org.eclipse.oomph.p2.core.BundlePool;
import org.eclipse.oomph.p2.core.P2Util;
import org.eclipse.oomph.p2.core.Profile;
import org.eclipse.oomph.p2.core.ProfileCreator;
import org.eclipse.oomph.p2.internal.core.AgentManagerElementImpl;
import org.eclipse.oomph.p2.internal.core.AgentManagerImpl;
import org.eclipse.oomph.p2.internal.core.BundlePoolImpl;
import org.eclipse.oomph.p2.internal.core.CachingRepositoryManager;
import org.eclipse.oomph.p2.internal.core.CachingTransport;
import org.eclipse.oomph.p2.internal.core.LazyProfileRegistry;
import org.eclipse.oomph.p2.internal.core.Messages;
import org.eclipse.oomph.p2.internal.core.P2CorePlugin;
import org.eclipse.oomph.p2.internal.core.PersistentMap;
import org.eclipse.oomph.p2.internal.core.ProfileCreatorImpl;
import org.eclipse.oomph.p2.internal.core.ProfileImpl;
import org.eclipse.oomph.util.IOUtil;
import org.eclipse.oomph.util.MonitorUtil;
import org.eclipse.oomph.util.PropertiesUtil;
import org.eclipse.oomph.util.StringUtil;
import org.eclipse.osgi.util.NLS;
import org.osgi.framework.BundleContext;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceReference;

public class AgentImpl
extends AgentManagerElementImpl
implements Agent {
    public static final String ENGINE_PATH = "org.eclipse.equinox.p2.engine";
    private static final Pattern ECLIPSE_INI_SECTION_PATTERN = Pattern.compile("^(-vmargs)([\n\r]+.*)\\z|^(-[^\\n\\r]*[\\n\\r]*)((?:^[^-][^\\n\\r]*)*[\\n\\r]*)", 40);
    private final AgentManagerImpl agentManager;
    private final File location;
    private final PersistentMap<BundlePool> bundlePoolMap;
    private final PersistentMap<Profile> profileMap;
    private IProvisioningAgent provisioningAgent;
    private IProfileRegistry profileRegistry;
    private IMetadataRepositoryManager metadataRepositoryManager;
    private IArtifactRepositoryManager artifactRepositoryManager;
    private IEngine engine;
    private IPlanner planner;
    private Transport originalTransport;
    private IMetadataRepositoryManager originalMetadataRepositoryManager;
    private IArtifactRepositoryManager originalArtifactRepositoryManager;

    public AgentImpl(AgentManagerImpl agentManager, File location) {
        this.agentManager = agentManager;
        this.location = location;
        this.bundlePoolMap = new PersistentMap<BundlePool>(new File(location, "pools.info")){

            @Override
            protected BundlePool createElement(String key, String extraInfo) {
                return new BundlePoolImpl(AgentImpl.this, new File(key));
            }

            @Override
            protected BundlePool loadElement(String key, String extraInfo) {
                return (BundlePool)super.loadElement(key, extraInfo);
            }

            @Override
            protected void initializeFirstTime() {
                IProfileRegistry profileRegistry = AgentImpl.this.getProfileRegistry();
                IProfile[] iProfileArray = profileRegistry.getProfiles();
                int n = iProfileArray.length;
                int n2 = 0;
                while (n2 < n) {
                    IProfile delegate = iProfileArray[n2];
                    String cache = delegate.getProperty("org.eclipse.equinox.p2.cache");
                    if (cache != null) {
                        this.addElement(cache, null);
                    }
                    ++n2;
                }
            }
        };
        this.profileMap = new PersistentMap<Profile>(new File(location, "profiles.info")){

            @Override
            protected Profile createElement(String profileID, String extraInfo) {
                if (extraInfo == null) {
                    return new ProfileImpl(AgentImpl.this, null, profileID, null, null, null);
                }
                List tokens = StringUtil.explode((String)extraInfo, (String)"|");
                int size = tokens.size();
                String type = size > 0 ? (String)tokens.get(0) : "";
                BundlePool bundlePool = size > 1 ? AgentImpl.this.getBundlePool((String)tokens.get(1)) : null;
                File installFolder = size > 2 ? AgentImpl.getFile((String)tokens.get(2)) : null;
                File referencer = size > 3 ? AgentImpl.getFile((String)tokens.get(3)) : null;
                return new ProfileImpl(AgentImpl.this, bundlePool, profileID, type, installFolder, referencer);
            }

            @Override
            protected Profile loadElement(String key, String extraInfo) {
                return (Profile)super.loadElement(key, extraInfo);
            }

            @Override
            protected void initializeFirstTime() {
                AgentImpl.this.fillProfileMap(this, (IProgressMonitor)new NullProgressMonitor());
            }
        };
        this.bundlePoolMap.load();
        this.profileMap.load();
    }

    @Override
    public String getElementType() {
        return "agent";
    }

    public void dispose() {
        if (this.provisioningAgent != null) {
            if (this.originalTransport != null) {
                this.provisioningAgent.registerService(Transport.SERVICE_NAME, (Object)this.originalTransport);
            }
            if (this.originalMetadataRepositoryManager != null) {
                if (this.metadataRepositoryManager instanceof IAgentService) {
                    ((IAgentService)this.metadataRepositoryManager).stop();
                }
                this.provisioningAgent.registerService(IMetadataRepositoryManager.SERVICE_NAME, (Object)this.originalMetadataRepositoryManager);
            }
            if (this.originalArtifactRepositoryManager != null) {
                if (this.artifactRepositoryManager instanceof IAgentService) {
                    ((IAgentService)this.artifactRepositoryManager).stop();
                }
                this.provisioningAgent.registerService(IArtifactRepositoryManager.SERVICE_NAME, (Object)this.originalArtifactRepositoryManager);
            }
        }
    }

    @Override
    public AgentManager getAgentManager() {
        return this.agentManager;
    }

    @Override
    public File getLocation() {
        return this.location;
    }

    @Override
    public boolean isValid() {
        return AgentImpl.isValid(this.location);
    }

    @Override
    public boolean isCurrent() {
        return this.agentManager.getCurrentAgent() == this;
    }

    @Override
    public boolean isUsed() {
        for (BundlePool bundlePool : this.getBundlePools()) {
            if (!bundlePool.isUsed()) continue;
            return true;
        }
        for (Profile profile : this.getProfiles()) {
            if (!profile.isUsed()) continue;
            return true;
        }
        return false;
    }

    @Override
    protected void doDelete() {
        this.agentManager.deleteAgent(this);
    }

    public PersistentMap<BundlePool> getBundlePoolMap() {
        return this.bundlePoolMap;
    }

    @Override
    public Set<File> getBundlePoolLocations() {
        return AgentManagerImpl.getLocations(this.bundlePoolMap.getElementKeys());
    }

    @Override
    public Collection<BundlePool> getBundlePools() {
        return this.bundlePoolMap.getElements();
    }

    public BundlePool getBundlePool(String path) {
        return this.bundlePoolMap.getElement(path);
    }

    @Override
    public BundlePool getBundlePool(File location) {
        return this.bundlePoolMap.getElement(location.getAbsolutePath());
    }

    @Override
    public BundlePool addBundlePool(File location) {
        return this.bundlePoolMap.addElement(location.getAbsolutePath(), null);
    }

    public void deleteBundlePool(BundlePool bundlePool) {
        this.bundlePoolMap.removeElement(bundlePool.getLocation().getAbsolutePath());
    }

    @Override
    public void refreshBundlePools(IProgressMonitor monitor) {
        monitor.subTask(NLS.bind((String)Messages.AgentImpl_Refreshing_task, (Object)this.getLocation()));
        this.bundlePoolMap.refresh();
        monitor.done();
    }

    @Override
    public synchronized IProfileRegistry getProfileRegistry() {
        this.getProvisioningAgent();
        return this.profileRegistry;
    }

    public PersistentMap<Profile> getProfileMap() {
        return this.profileMap;
    }

    @Override
    public Set<String> getAllProfileIDs() {
        return this.profileMap.getElementKeys();
    }

    @Override
    public Collection<Profile> getAllProfiles() {
        return this.profileMap.getElements();
    }

    @Override
    public Set<String> getProfileIDs() {
        return this.getProfileIDs(null);
    }

    public Set<String> getProfileIDs(BundlePool bundlePool) {
        HashSet<String> ids = new HashSet<String>();
        for (Profile profile : this.getAllProfiles()) {
            if (profile.getBundlePool() != bundlePool) continue;
            ids.add(profile.getProfileId());
        }
        return ids;
    }

    @Override
    public Collection<Profile> getProfiles() {
        return this.getProfiles(null);
    }

    public Collection<Profile> getProfiles(BundlePool bundlePool) {
        Collection<Profile> profiles = this.getAllProfiles();
        Iterator<Profile> it = profiles.iterator();
        while (it.hasNext()) {
            Profile profile = it.next();
            if (profile.getBundlePool() == bundlePool) continue;
            it.remove();
        }
        return profiles;
    }

    @Override
    public Profile getCurrentProfile() {
        IProfile delegate = this.getProfileRegistry().getProfile("_SELF_");
        if (delegate != null) {
            String profileID = delegate.getProfileId();
            return this.getProfile(profileID);
        }
        return null;
    }

    @Override
    public Profile getProfile(String id) {
        Profile profile = this.profileMap.getElement(id);
        if (profile == null) {
            if (this.provisioningAgent == null) {
                this.getProvisioningAgent();
                profile = this.profileMap.getElement(id);
            }
        } else if (!profile.isValid()) {
            this.profileMap.removeElement(id);
            this.getProfileRegistry().removeProfile(id);
            profile = null;
        }
        return profile;
    }

    @Override
    public Profile getProfile(File installFolder) {
        Profile profile = this.getProfileFromProfileMap(installFolder);
        if (profile == null) {
            if (this.provisioningAgent == null) {
                this.getProvisioningAgent();
                profile = this.getProfileFromProfileMap(installFolder);
            }
        } else if (!profile.isValid()) {
            String id = profile.getProfileId();
            this.profileMap.removeElement(id);
            this.getProfileRegistry().removeProfile(id);
            profile = null;
        }
        return profile;
    }

    private Profile getProfileFromProfileMap(File installFolder) {
        File canonicalLocation = IOUtil.getCanonicalFile((File)installFolder);
        Collection<Profile> profiles = this.profileMap.getElements();
        for (Profile profile : profiles) {
            File profileLocation = IOUtil.getCanonicalFile((File)profile.getInstallFolder());
            if (!canonicalLocation.equals(profileLocation)) continue;
            return profile;
        }
        return null;
    }

    @Override
    public ProfileCreator addProfile(String id, String type) {
        return new ProfileCreatorImpl(this, id, type){
            private static final long serialVersionUID = 1L;

            @Override
            protected Profile doCreateProfile() {
                return AgentImpl.this.createProfile(this);
            }
        };
    }

    public Profile createProfile(ProfileCreator creator) {
        if (creator.getEnvironments() == null) {
            creator.addOS(Platform.getOS());
            creator.addWS(Platform.getWS());
            creator.addArch(Platform.getOSArch());
            creator.addLanguage(Platform.getNL());
        }
        try {
            String profileID = creator.getProfileID();
            IProfile delegate = this.getProfileRegistry().addProfile(profileID, (Map)creator);
            String extraInfo = AgentImpl.getProfileExtraInfo(delegate);
            ProfileImpl profile = (ProfileImpl)this.profileMap.addElement(profileID, extraInfo);
            profile.setDelegate(delegate);
            return profile;
        }
        catch (ProvisionException ex) {
            throw new P2Exception((Throwable)ex);
        }
    }

    public void deleteProfile(Profile profile) {
        String profileID = profile.getProfileId();
        this.profileMap.removeElement(profileID);
        this.getProfileRegistry().removeProfile(profileID);
    }

    @Override
    public void refreshProfiles(IProgressMonitor monitor) {
        monitor.beginTask("", 10);
        try {
            this.getProvisioningAgent();
            if (this.profileRegistry instanceof LazyProfileRegistry) {
                LazyProfileRegistry lazyProfileRegistry = (LazyProfileRegistry)this.profileRegistry;
                lazyProfileRegistry.resetProfiles();
                lazyProfileRegistry.getProfileMap((IProgressMonitor)MonitorUtil.create((IProgressMonitor)monitor, (int)1));
            } else {
                monitor.worked(1);
            }
            this.fillProfileMap(this.profileMap, (IProgressMonitor)MonitorUtil.create((IProgressMonitor)monitor, (int)9));
            this.profileMap.refresh();
        }
        finally {
            monitor.done();
        }
    }

    private void fillProfileMap(PersistentMap<Profile> profileMap, IProgressMonitor monitor) {
        IProfileRegistry profileRegistry = this.getProfileRegistry();
        IProfile[] iProfileArray = profileRegistry instanceof LazyProfileRegistry ? ((LazyProfileRegistry)profileRegistry).getProfiles(monitor) : profileRegistry.getProfiles();
        int n = iProfileArray.length;
        int n2 = 0;
        while (n2 < n) {
            IProfile delegate = iProfileArray[n2];
            String key = delegate.getProfileId();
            String extraInfo = AgentImpl.getProfileExtraInfo(delegate);
            profileMap.addElement(key, extraInfo);
            ++n2;
        }
    }

    public void initializeProvisioningAgent(IProvisioningAgent provisioningAgent) {
        if (this.provisioningAgent == null) {
            File actualInstallFolder;
            String actualInstallFolderLocation;
            File cachedInstallFolder;
            IProvisioningEventBus eventBus;
            this.profileRegistry = (IProfileRegistry)provisioningAgent.getService(IProfileRegistry.SERVICE_NAME);
            this.metadataRepositoryManager = (IMetadataRepositoryManager)provisioningAgent.getService(IMetadataRepositoryManager.SERVICE_NAME);
            this.artifactRepositoryManager = (IArtifactRepositoryManager)provisioningAgent.getService(IArtifactRepositoryManager.SERVICE_NAME);
            Transport transport = (Transport)provisioningAgent.getService(Transport.SERVICE_NAME);
            if (AgentImpl.cacheTransport(transport)) {
                this.originalTransport = transport;
                CachingTransport cachingTransport = new CachingTransport(transport, provisioningAgent);
                provisioningAgent.registerService(Transport.SERVICE_NAME, (Object)cachingTransport);
                this.originalMetadataRepositoryManager = this.metadataRepositoryManager;
                this.metadataRepositoryManager = new CachingRepositoryManager.Metadata(provisioningAgent, cachingTransport);
                provisioningAgent.registerService(IMetadataRepositoryManager.SERVICE_NAME, (Object)this.metadataRepositoryManager);
                this.originalArtifactRepositoryManager = this.artifactRepositoryManager;
                this.artifactRepositoryManager = new CachingRepositoryManager.Artifact(provisioningAgent, cachingTransport);
                provisioningAgent.registerService(IArtifactRepositoryManager.SERVICE_NAME, (Object)this.artifactRepositoryManager);
            }
            if ((eventBus = (IProvisioningEventBus)provisioningAgent.getService(IProvisioningEventBus.SERVICE_NAME)) != null) {
                eventBus.addListener((ProvisioningListener)new SynchronousProvisioningListener(){
                    private Runnable restoreBundlePoolTimestamps;

                    public void notify(EventObject event) {
                        if (event instanceof TransactionEvent) {
                            File bundlePoolLocation;
                            String cache;
                            TransactionEvent transactionEvent = (TransactionEvent)event;
                            IProfile profile = transactionEvent.getProfile();
                            if ("true".equals(profile.getProperty("org.eclipse.oomph.p2.profile.shared.pool")) && (cache = profile.getProperty("org.eclipse.equinox.p2.cache")) != null && (bundlePoolLocation = new File(cache).getAbsoluteFile()).exists()) {
                                if (event instanceof BeginOperationEvent) {
                                    this.restoreBundlePoolTimestamps = P2Util.preserveBundlePoolTimestamps(bundlePoolLocation);
                                } else if ((event instanceof CommitOperationEvent || event instanceof RollbackOperationEvent) && this.restoreBundlePoolTimestamps != null) {
                                    this.restoreBundlePoolTimestamps.run();
                                }
                            }
                            if (event instanceof CommitOperationEvent && "Installation".equals(profile.getProperty("org.eclipse.oomph.p2.profile.type"))) {
                                AgentImpl.this.adjustInstallation(profile);
                            }
                        }
                    }
                });
            }
            this.provisioningAgent = provisioningAgent;
            Profile currentProfile = this.getCurrentProfile();
            if (currentProfile instanceof ProfileImpl && (cachedInstallFolder = currentProfile.getInstallFolder()) != null && (actualInstallFolderLocation = currentProfile.getProperty("org.eclipse.equinox.p2.installFolder")) != null && !(actualInstallFolder = new File(actualInstallFolderLocation)).equals(cachedInstallFolder)) {
                File bundlePoolLocation;
                ((ProfileImpl)currentProfile).setInstallFolder(actualInstallFolder);
                BundlePool bundlePool = currentProfile.getBundlePool();
                if (bundlePool instanceof BundlePoolImpl && (bundlePoolLocation = bundlePool.getLocation()).equals(cachedInstallFolder)) {
                    ((BundlePoolImpl)bundlePool).setLocation(actualInstallFolder);
                    this.bundlePoolMap.remap(cachedInstallFolder.toString(), actualInstallFolderLocation);
                }
                String profileID = currentProfile.getProfileId();
                this.profileMap.save(profileID, profileID);
            }
        }
    }

    @Override
    public synchronized IProvisioningAgent getProvisioningAgent() {
        if (this.provisioningAgent == null) {
            File location = this.getLocation();
            this.initializeProvisioningAgent(AgentImpl.getOrCreateProvisioningAgent(location));
        }
        return this.provisioningAgent;
    }

    @Override
    public synchronized IMetadataRepositoryManager getMetadataRepositoryManager() {
        this.getProvisioningAgent();
        return this.metadataRepositoryManager;
    }

    @Override
    public synchronized IArtifactRepositoryManager getArtifactRepositoryManager() {
        this.getProvisioningAgent();
        return this.artifactRepositoryManager;
    }

    @Override
    public synchronized IEngine getEngine() {
        if (this.engine == null) {
            this.engine = (IEngine)this.getProvisioningAgent().getService(IEngine.SERVICE_NAME);
            if (this.engine == null) {
                throw new IllegalStateException(Messages.AgentImpl_EngineNotLoaded_exception);
            }
        }
        return this.engine;
    }

    @Override
    public synchronized IPlanner getPlanner() {
        if (this.planner == null) {
            this.planner = (IPlanner)this.getProvisioningAgent().getService(IPlanner.SERVICE_NAME);
            if (this.planner == null) {
                throw new IllegalStateException(Messages.AgentImpl_PlannerNotLoaded_exception);
            }
        }
        return this.planner;
    }

    @Override
    public void flushCachedRepositories() {
        IArtifactRepositoryManager artifactRepositoryManager;
        IMetadataRepositoryManager metadataRepositoryManager = this.getMetadataRepositoryManager();
        if (metadataRepositoryManager instanceof CachingRepositoryManager.Metadata) {
            CachingRepositoryManager.Metadata manager = (CachingRepositoryManager.Metadata)metadataRepositoryManager;
            manager.flushCache();
        }
        if ((artifactRepositoryManager = this.getArtifactRepositoryManager()) instanceof CachingRepositoryManager.Artifact) {
            CachingRepositoryManager.Artifact manager = (CachingRepositoryManager.Artifact)artifactRepositoryManager;
            manager.flushCache();
        }
    }

    @Override
    public IFileArtifactRepository getDownloadCacheRepository() {
        try {
            return Util.getDownloadCacheRepo((IProvisioningAgent)this.getProvisioningAgent());
        }
        catch (ProvisionException ex) {
            throw new P2Exception((Throwable)ex);
        }
    }

    @Override
    public void clearRepositoryCaches(IProgressMonitor monitor) {
        File oomphP2Cache;
        File[] oomphP2CacheFiles;
        LinkedHashSet<File> cacheFiles = new LinkedHashSet<File>();
        IAgentLocation location = (IAgentLocation)this.getProvisioningAgent().getService(IAgentLocation.SERVICE_NAME);
        File p2Cache = URIUtil.toFile((java.net.URI)location.getDataArea("org.eclipse.equinox.p2.repository/cache/"));
        File[] p2CacheFiles = p2Cache.listFiles();
        if (p2CacheFiles != null) {
            cacheFiles.addAll(Arrays.asList(p2CacheFiles));
        }
        if ((oomphP2CacheFiles = (oomphP2Cache = new File(P2CorePlugin.getUserStateFolder(new File(PropertiesUtil.getUserHome())), "cache")).listFiles()) != null) {
            cacheFiles.addAll(Arrays.asList(oomphP2CacheFiles));
        }
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (String)Messages.AgentImpl_DeletingRepositoryCache_task, (int)cacheFiles.size());
        for (File cacheFile : cacheFiles) {
            if (subMonitor.isCanceled()) break;
            subMonitor.subTask(NLS.bind((String)Messages.AgentImpl_Deleting_task, (Object)cacheFile));
            IOUtil.deleteBestEffort((File)cacheFile, (boolean)false);
            subMonitor.worked(1);
        }
    }

    public String toString() {
        return this.getLocation().getAbsolutePath();
    }

    private File getSplashArtifactFile(IProfile profile, BundlePool bundlePool, String id) {
        for (IInstallableUnit installableUnit : P2Util.asIterable(profile.query(QueryUtil.createIUQuery((String)id), null))) {
            for (IArtifactKey artifactKey : installableUnit.getArtifacts()) {
                File artifactFile = bundlePool.getFileArtifactRepository().getArtifactFile(artifactKey);
                if (!(artifactFile.isDirectory() ? new File(artifactFile, "splash.bmp").exists() : URIConverter.INSTANCE.exists(URI.createURI((String)("archive:" + URI.createFileURI((String)(String.valueOf(artifactFile.getAbsolutePath()) + "!/splash.bmp")))), null))) continue;
                return artifactFile;
            }
        }
        return null;
    }

    private void adjustInstallation(IProfile profile) {
        String installFolderLocation;
        BundlePool bundlePool;
        String bundlePoolLocation = profile.getProperty("org.eclipse.equinox.p2.cache");
        if (bundlePoolLocation != null && (bundlePool = this.getBundlePool(new File(bundlePoolLocation))) != null && (installFolderLocation = profile.getProperty("org.eclipse.equinox.p2.installFolder")) != null) {
            File installFolder = new File(installFolderLocation);
            File configurationFolder = new File(installFolder, "configuration");
            if ("true".equals(profile.getProperty("org.eclipse.oomph.p2.profile.shared.pool"))) {
                try {
                    this.adjustConfigIni(profile, bundlePool, configurationFolder);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                try {
                    this.adjustLauncherIni(profile, bundlePool, installFolder, true);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                try {
                    this.adjustBundlesInfo(configurationFolder);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                try {
                    this.adjustPlatformXML(bundlePoolLocation, configurationFolder);
                }
                catch (Exception exception) {}
            } else {
                try {
                    this.adjustLauncherIni(profile, bundlePool, installFolder, false);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
    }

    private void adjustConfigIni(IProfile profile, BundlePool bundlePool, File configurationFolder) {
        URI uri;
        String osgiFramework;
        File splashArtifactFile;
        URI uri2;
        File configIniFile = new File(configurationFolder, "config.ini");
        Map configProperties = PropertiesUtil.loadProperties((File)configIniFile);
        boolean changed = false;
        String splashPath = (String)configProperties.get("osgi.splashPath");
        if (splashPath != null && "platform".equals((uri2 = URI.createURI((String)splashPath)).scheme()) && uri2.segmentCount() >= 2 && "base".equals(uri2.segment(0)) && (splashArtifactFile = this.getSplashArtifactFile(profile, bundlePool, uri2.lastSegment())) != null) {
            configProperties.put("osgi.splashPath", AgentImpl.createFileURI(splashArtifactFile));
            changed = true;
        }
        if ((osgiFramework = (String)configProperties.get("osgi.framework")) != null && (uri = URI.createURI((String)osgiFramework)).hasOpaquePart() && "file".equals(uri.scheme())) {
            URI configurationFolderURI = URI.createFileURI((String)configurationFolder.toString());
            URI absoluteOSGiFrameworkLocation = URI.createURI((String)uri.opaquePart()).resolve(configurationFolderURI);
            if (new File(absoluteOSGiFrameworkLocation.toFileString()).exists()) {
                configProperties.put("osgi.framework", AgentImpl.createFileURI(absoluteOSGiFrameworkLocation.toFileString()));
                changed = true;
            }
        }
        if (changed) {
            PropertiesUtil.saveProperties((File)configIniFile, (Map)configProperties, (boolean)false, (boolean)true, (String)NLS.bind((String)Messages.AgentImpl_ConfigurationWrittenBy_message, (Object)AgentImpl.class.getName()));
        }
    }

    private void adjustLauncherIni(IProfile profile, BundlePool bundlePool, File installFolder, boolean sharedPool) {
        String launcherName = profile.getProperty("eclipse.touchpoint.launcherName");
        File iniFile = new File(installFolder, launcherName == null ? "eclipse.ini" : String.valueOf(launcherName) + ".ini");
        String contents = new String(IOUtil.readFile((File)iniFile));
        LinkedHashMap<String, String> map = new LinkedHashMap<String, String>();
        Matcher matcher = ECLIPSE_INI_SECTION_PATTERN.matcher(contents);
        while (matcher.find()) {
            String extension;
            String argument = matcher.group(3);
            if (argument == null) {
                argument = matcher.group(1);
                extension = matcher.group(2);
            } else {
                extension = matcher.group(4);
            }
            if ((argument.startsWith("--launcher.XXMaxPermSize") || argument.startsWith("-startup")) && map.containsKey(argument)) continue;
            map.put(argument, extension);
        }
        URI baseURI = URI.createFileURI((String)installFolder.toString()).appendSegment("");
        StringBuilder newContents = new StringBuilder();
        for (Map.Entry entry : map.entrySet()) {
            String key = (String)entry.getKey();
            String trimmedKey = key.trim();
            String value = (String)entry.getValue();
            if (sharedPool) {
                String nl;
                if ("-startup".equals(trimmedKey)) {
                    File localLauncherLibraryFile;
                    URI absoluteLauncherLibraryLocation = URI.createFileURI((String)value.trim()).resolve(baseURI);
                    File absoluteLauncherLibraryFile = new File(absoluteLauncherLibraryLocation.toFileString());
                    if (absoluteLauncherLibraryFile.isFile() && !(localLauncherLibraryFile = new File(new File(installFolder, "plugins"), absoluteLauncherLibraryLocation.lastSegment())).equals(absoluteLauncherLibraryFile)) {
                        IOUtil.copyFile((File)absoluteLauncherLibraryFile, (File)localLauncherLibraryFile);
                        nl = key.substring(trimmedKey.length());
                        value = String.valueOf("macosx".equals(org.eclipse.equinox.internal.p2.touchpoint.eclipse.Util.getOSFromProfile((IProfile)profile)) ? "../Eclipse/plugins/" : "plugins/") + absoluteLauncherLibraryLocation.lastSegment() + nl;
                    }
                } else if ("--launcher.library".equals(trimmedKey)) {
                    URI absoluteBundleLocation;
                    if (value.startsWith("../") && new File((absoluteBundleLocation = URI.createURI((String)value.trim()).resolve(baseURI)).toFileString()).exists()) {
                        nl = key.substring(trimmedKey.length());
                        value = String.valueOf(absoluteBundleLocation.toFileString()) + nl;
                    }
                } else if ("-showsplash".equals(trimmedKey)) {
                    String name = new File(value.trim()).getName();
                    int index = name.indexOf(95);
                    while (true) {
                        String id;
                        File splashArtifactFile;
                        if ((splashArtifactFile = this.getSplashArtifactFile(profile, bundlePool, id = index == -1 ? name : name.substring(0, index))) != null) {
                            nl = key.substring(trimmedKey.length());
                            value = String.valueOf(splashArtifactFile.getPath()) + nl;
                        } else if (index != -1) {
                            index = name.indexOf(index + 1, 95);
                            continue;
                        }
                        break;
                    }
                } else if ("-configuration".equals(trimmedKey) || "-install".equals(trimmedKey)) continue;
            }
            newContents.append(key);
            newContents.append(value);
        }
        if (!contents.contentEquals(newContents)) {
            IOUtil.writeFile((File)iniFile, (byte[])newContents.toString().getBytes());
        }
    }

    private void adjustBundlesInfo(File configurationFolder) {
        File bundlesInfoFile = new File(configurationFolder, "org.eclipse.equinox.simpleconfigurator/bundles.info");
        List lines = IOUtil.readLines((File)bundlesInfoFile, (String)"UTF-8");
        ArrayList<String> result = new ArrayList<String>();
        boolean changed = false;
        URI configurationFolderURI = URI.createFileURI((String)configurationFolder.toString());
        for (String line : lines) {
            URI absoluteBundleLocation;
            String bundleReference;
            List elements;
            if (!line.startsWith("#") && (elements = StringUtil.explode((String)line, (String)",")).size() > 2 && (bundleReference = (String)elements.get(2)).startsWith("../") && new File((absoluteBundleLocation = URI.createURI((String)bundleReference).resolve(configurationFolderURI)).toFileString()).exists()) {
                elements.set(2, AgentImpl.createFileURI(absoluteBundleLocation.toFileString()));
                result.add(StringUtil.implode((List)elements, (char)',', (char)'\u0000'));
                changed = true;
                continue;
            }
            result.add(line);
        }
        if (changed) {
            IOUtil.writeLines((File)bundlesInfoFile, (String)"UTF-8", result);
        }
    }

    private void adjustPlatformXML(String bundlePoolLocation, File configurationFolder) throws ProvisionException {
        File platformXML = new File(configurationFolder, "org.eclipse.update/platform.xml");
        if (platformXML.isFile()) {
            URI configurationFolderURI = URI.createFileURI((String)configurationFolder.toString());
            Configuration configuration = Configuration.load((File)platformXML, null);
            boolean changed = false;
            for (Site site : configuration.getSites()) {
                File siteLocation;
                URI absoluteSiteURI;
                URI siteURI = URI.createURI((String)site.getUrl());
                if (siteURI.hasOpaquePart() && "file".equals(siteURI.scheme()) && new File((absoluteSiteURI = URI.createURI((String)siteURI.opaquePart()).resolve(configurationFolderURI)).toFileString()).exists()) {
                    siteURI = absoluteSiteURI;
                    site.setUrl(absoluteSiteURI.toFileString());
                    changed = true;
                }
                if ("MANAGED-ONLY".equals(site.getPolicy()) || !(siteLocation = new File(siteURI.toFileString())).equals(new File(bundlePoolLocation))) continue;
                site.setPolicy("MANAGED-ONLY");
                changed = true;
                break;
            }
            if (changed) {
                configuration.save(platformXML, null);
            }
        }
    }

    public static boolean isValid(File location) {
        return new File(location, ENGINE_PATH).isDirectory();
    }

    public static String getProfileType(IProfile delegate) {
        String type = delegate.getProperty("org.eclipse.oomph.p2.profile.type");
        if (type == null) {
            if (delegate.getProperty("targlet.container.id") != null) {
                return "Targlet";
            }
            if (delegate.getProperty("org.eclipse.equinox.p2.installFolder") != null) {
                return "Installation";
            }
        }
        return type;
    }

    public static String getProfileExtraInfo(IProfile delegate) {
        ArrayList<String> tokens = new ArrayList<String>();
        tokens.add(AgentImpl.getProfileType(delegate));
        tokens.add(delegate.getProperty("org.eclipse.equinox.p2.cache"));
        tokens.add(delegate.getProperty("org.eclipse.equinox.p2.installFolder"));
        tokens.add(delegate.getProperty("org.eclipse.oomph.p2.profile.referencer"));
        return StringUtil.implode(tokens, (char)'|');
    }

    public static IProvisioningAgent getOrCreateProvisioningAgent(File location) {
        IProvisioningAgent provisioningAgent;
        BundleContext context;
        block20: {
            context = P2CorePlugin.INSTANCE.getBundleContext();
            ServiceReference agentRef = null;
            provisioningAgent = null;
            try {
                try {
                    Collection agentRefs = null;
                    try {
                        agentRefs = context.getServiceReferences(IProvisioningAgent.class, "(locationURI=" + location.toURI() + ")");
                    }
                    catch (InvalidSyntaxException invalidSyntaxException) {
                        // empty catch block
                    }
                    if (agentRefs != null && !agentRefs.isEmpty()) {
                        agentRef = (ServiceReference)agentRefs.iterator().next();
                        provisioningAgent = (IProvisioningAgent)context.getService(agentRef);
                    }
                }
                catch (Exception ex) {
                    provisioningAgent = null;
                    if (agentRef != null) {
                        context.ungetService(agentRef);
                    }
                    break block20;
                }
            }
            catch (Throwable throwable) {
                if (agentRef != null) {
                    context.ungetService(agentRef);
                }
                throw throwable;
            }
            if (agentRef != null) {
                context.ungetService(agentRef);
            }
        }
        if (provisioningAgent == null) {
            location.mkdirs();
            ServiceReference providerRef = null;
            try {
                try {
                    providerRef = context.getServiceReference(IProvisioningAgentProvider.class);
                    if (providerRef != null) {
                        IProvisioningAgentProvider provider = (IProvisioningAgentProvider)context.getService(providerRef);
                        provisioningAgent = provider.createAgent(location.toURI());
                    }
                }
                catch (ProvisionException ex) {
                    throw new P2Exception((Throwable)ex);
                }
            }
            finally {
                if (providerRef != null) {
                    context.ungetService(providerRef);
                }
            }
        }
        if (provisioningAgent == null) {
            throw new P2Exception(NLS.bind((String)Messages.AgentImpl_AgentNotLoaded_exception, (Object)location));
        }
        return provisioningAgent;
    }

    private static boolean cacheTransport(Transport transport) {
        if (PropertiesUtil.isProperty((String)"oomph.p2.disable.offline")) {
            return false;
        }
        if (transport instanceof CachingTransport) {
            return false;
        }
        return transport != null;
    }

    private static File getFile(String path) {
        if (StringUtil.isEmpty((String)path)) {
            return null;
        }
        return new File(path);
    }

    private static String createFileURI(String path) {
        return AgentImpl.createFileURI(new File(path));
    }

    static String createFileURI(File file) {
        String path = file.getPath();
        if (File.separatorChar != '/') {
            path = path.replace(File.separatorChar, '/');
        }
        if (file.isAbsolute() && !path.startsWith(File.separator)) {
            return "file:/" + path;
        }
        return "file:" + path;
    }
}

