/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2e.core.internal.lifecyclemapping;

import java.util.Arrays;
import java.util.Objects;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.m2e.core.internal.lifecyclemapping.DuplicateMappingException;
import org.eclipse.m2e.core.internal.lifecyclemapping.model.LifecycleMappingMetadataSource;
import org.eclipse.m2e.core.internal.markers.MavenProblemInfo;
import org.eclipse.m2e.core.internal.markers.SourceLocation;
import org.osgi.framework.Bundle;
import org.osgi.framework.Version;

public class DuplicateMappingSourceProblem
extends MavenProblemInfo {
    private LifecycleMappingMetadataSource[] conflictingSources;
    private String type;
    private String value;

    public DuplicateMappingSourceProblem(SourceLocation location, String message, String type, String value, DuplicateMappingException error) {
        super(location, message, (Throwable)error);
        this.type = type;
        this.value = value;
        this.conflictingSources = error.getConflictingSources();
    }

    @Override
    public void processMarker(IMarker marker) throws CoreException {
        super.processMarker(marker);
        marker.setAttribute("duplicateMappingType", (Object)this.type);
        marker.setAttribute("duplicateMappingValue", (Object)this.value);
        Bundle[] bundles = (Bundle[])Arrays.stream(this.conflictingSources).map(LifecycleMappingMetadataSource::getSource).filter(Bundle.class::isInstance).map(Bundle.class::cast).toArray(Bundle[]::new);
        marker.setAttribute("duplicateMappingSources", bundles.length);
        int i = 0;
        while (i < bundles.length) {
            Bundle bundle = bundles[i];
            String prefix = "duplicateMappingSources." + i + ".";
            Version version = bundle.getVersion();
            String v = String.valueOf(version.getMajor()) + "." + version.getMinor() + "." + version.getMicro();
            marker.setAttribute(String.valueOf(prefix) + "name", (Object)Objects.requireNonNullElse((String)bundle.getHeaders().get("Bundle-Name"), bundle.getSymbolicName()));
            marker.setAttribute(String.valueOf(prefix) + "bundleSymbolicName", (Object)bundle.getSymbolicName());
            marker.setAttribute(String.valueOf(prefix) + "bundleVersionRange", (Object)v);
            ++i;
        }
        marker.setAttribute("editor_hint", (Object)"conflicting_lifecyclemaping");
    }
}

