/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2e.core.internal.markers;

import java.io.File;
import java.util.List;
import java.util.Objects;
import org.apache.maven.model.Dependency;
import org.apache.maven.model.DependencyManagement;
import org.apache.maven.model.InputLocation;
import org.apache.maven.model.InputSource;
import org.apache.maven.model.Plugin;
import org.apache.maven.model.PluginExecution;
import org.apache.maven.model.building.ModelProblem;
import org.apache.maven.project.MavenProject;
import org.eclipse.aether.artifact.Artifact;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IPath;
import org.eclipse.m2e.core.internal.markers.SourceLocation;
import org.eclipse.m2e.core.project.configurator.MojoExecutionKey;

public class SourceLocationHelper {
    private static final String SELF = "";
    private static final String PROJECT = "project";
    private static final String PACKAGING = "packaging";
    private static final String PLUGIN = "plugin";
    private static final String PARENT = "parent";
    public static final String CONFIGURATION = "configuration";
    public static final String VERSION = "version";
    public static final String EXECUTION = "execution";
    public static final String DEPENDENCY = "dependency";
    private static final int COLUMN_START_OFFSET = 2;
    private static final int COLUMN_END_OFFSET = 1;

    private SourceLocationHelper() {
    }

    public static SourceLocation findPackagingLocation(MavenProject mavenProject) {
        InputLocation inputLocation = mavenProject.getModel().getLocation((Object)PACKAGING);
        if (inputLocation != null) {
            return SourceLocationHelper.getSourceLocation(inputLocation, PACKAGING);
        }
        inputLocation = mavenProject.getModel().getLocation((Object)SELF);
        return SourceLocationHelper.getSourceLocation(inputLocation, PROJECT);
    }

    public static SourceLocation findLocation(Plugin plugin, String attribute) {
        InputLocation inputLocation = plugin.getLocation((Object)attribute);
        if (inputLocation != null) {
            return SourceLocationHelper.getSourceLocation(inputLocation, attribute);
        }
        inputLocation = plugin.getLocation((Object)SELF);
        return SourceLocationHelper.getSourceLocation(inputLocation, PLUGIN);
    }

    public static SourceLocation findLocation(IResource pomResource, ModelProblem modelProblem) {
        int lineNumber = Math.max(1, modelProblem.getLineNumber());
        if (pomResource == null) {
            return new SourceLocation(lineNumber, 1, 1);
        }
        int columnNumber = Math.max(1, modelProblem.getColumnNumber());
        IPath pomLocation = pomResource.getLocation();
        if (pomLocation != null && pomLocation.toOSString().equals(modelProblem.getSource())) {
            return new SourceLocation(lineNumber, 1, columnNumber - 1);
        }
        SourceLocation causeLocation = new SourceLocation(modelProblem.getSource(), modelProblem.getModelId(), lineNumber, 1, columnNumber - 1);
        return new SourceLocation(1, 1, 1, causeLocation);
    }

    public static SourceLocation findLocation(MavenProject mavenProject, MojoExecutionKey mojoExecutionKey) {
        String elementName;
        InputLocation inputLocation;
        Plugin plugin = mavenProject.getPlugin(String.valueOf(mojoExecutionKey.getGroupId()) + ":" + mojoExecutionKey.getArtifactId());
        InputLocation inputLocation2 = inputLocation = plugin != null ? plugin.getLocation((Object)SELF) : null;
        if (inputLocation == null || inputLocation.getLineNumber() < 0) {
            inputLocation = mavenProject.getModel().getLocation((Object)PACKAGING);
            if (inputLocation != null) {
                return SourceLocationHelper.getSourceLocation(inputLocation, PACKAGING);
            }
            inputLocation = mavenProject.getModel().getLocation((Object)SELF);
            return SourceLocationHelper.getSourceLocation(inputLocation, PROJECT);
        }
        InputLocation executionInputLocation = SourceLocationHelper.findExecutionLocation(plugin, mojoExecutionKey.getExecutionId());
        if (executionInputLocation != null && executionInputLocation.getLineNumber() >= 0) {
            inputLocation = executionInputLocation;
            elementName = EXECUTION;
        } else {
            elementName = PLUGIN;
        }
        File pomFile = mavenProject.getFile();
        if (pomFile.getAbsolutePath().equals(inputLocation.getSource().getLocation())) {
            return SourceLocationHelper.getSourceLocation(inputLocation, elementName);
        }
        SourceLocation causeLocation = SourceLocationHelper.getSourceLocation(inputLocation, elementName);
        inputLocation = mavenProject.getModel().getParent().getLocation((Object)SELF);
        if (inputLocation == null) {
            return new SourceLocation(1, 1, 1, causeLocation);
        }
        return SourceLocationHelper.getSourceLocation(inputLocation, PARENT, causeLocation);
    }

    private static InputLocation findExecutionLocation(Plugin plugin, String executionId) {
        if (executionId == null) {
            return null;
        }
        PluginExecution pluginExecution = (PluginExecution)plugin.getExecutionsAsMap().get(executionId);
        if (pluginExecution == null) {
            return null;
        }
        return pluginExecution.getLocation((Object)SELF);
    }

    private static Dependency getMavenDependency(MavenProject mavenProject, org.eclipse.aether.graph.Dependency dependency) {
        String depId;
        String projectId;
        DependencyManagement depMgmt;
        Dependency found = SourceLocationHelper.findDependency(mavenProject.getDependencies(), dependency);
        if (found == null && (depMgmt = mavenProject.getModel().getDependencyManagement()) != null && (found = SourceLocationHelper.findDependency(depMgmt.getDependencies(), dependency)) != null && !(projectId = mavenProject.getModel().getLocation((Object)SELF).getSource().getModelId()).equals(depId = found.getLocation((Object)SELF).getSource().getModelId())) {
            Dependency importDep;
            DependencyManagement origMgmt = mavenProject.getOriginalModel().getDependencyManagement();
            found = importDep = SourceLocationHelper.findDependencyImport(origMgmt, depId);
        }
        return found;
    }

    private static Dependency findDependencyImport(DependencyManagement origMgmt, String depId) {
        if (origMgmt != null) {
            for (Dependency dependency : origMgmt.getDependencies()) {
                String importId;
                if (!"import".equals(dependency.getScope()) || !"pom".equals(dependency.getType()) || !depId.equals(importId = String.valueOf(dependency.getGroupId()) + ":" + dependency.getArtifactId() + ":" + dependency.getVersion())) continue;
                return dependency;
            }
        }
        return null;
    }

    private static Dependency findDependency(List<Dependency> dependencies, org.eclipse.aether.graph.Dependency dependency) {
        for (Dependency mavenDependency : dependencies) {
            Artifact dependencyArtifact = dependency.getArtifact();
            if (!mavenDependency.getArtifactId().equals(dependencyArtifact.getArtifactId()) || !mavenDependency.getGroupId().equals(dependencyArtifact.getGroupId()) || !SourceLocationHelper.eq(mavenDependency.getVersion(), dependencyArtifact.getVersion()) || !SourceLocationHelper.eq(mavenDependency.getClassifier(), dependencyArtifact.getClassifier())) continue;
            return mavenDependency;
        }
        return null;
    }

    private static boolean eq(String s1, String s2) {
        if (s1 != null && s1.isBlank()) {
            s1 = null;
        }
        if (s2 != null && s2.isBlank()) {
            s2 = null;
        }
        return Objects.equals(s1, s2);
    }

    public static SourceLocation findLocation(MavenProject mavenProject, org.eclipse.aether.graph.Dependency dependency) {
        Dependency mavenDependency = SourceLocationHelper.getMavenDependency(mavenProject, dependency);
        return SourceLocationHelper.findLocation(mavenProject, mavenDependency);
    }

    public static SourceLocation findLocation(MavenProject mavenProject, Dependency dependency) {
        InputLocation inputLocation = null;
        if (dependency != null) {
            inputLocation = dependency.getLocation((Object)SELF);
        }
        if (inputLocation == null) {
            inputLocation = mavenProject.getModel().getLocation((Object)SELF);
            return new SourceLocation(inputLocation.getLineNumber(), 1, inputLocation.getColumnNumber() - 1);
        }
        File pomFile = mavenProject.getFile();
        if (pomFile.getAbsolutePath().equals(inputLocation.getSource().getLocation())) {
            return SourceLocationHelper.getSourceLocation(inputLocation, DEPENDENCY);
        }
        SourceLocation causeLocation = SourceLocationHelper.getSourceLocation(inputLocation, DEPENDENCY);
        inputLocation = mavenProject.getModel().getParent().getLocation((Object)SELF);
        return SourceLocationHelper.getSourceLocation(inputLocation, PARENT, causeLocation);
    }

    private static SourceLocation getSourceLocation(InputLocation inputLocation, String elementName) {
        InputSource source = inputLocation.getSource();
        return new SourceLocation(source != null ? source.getLocation() : null, source != null ? source.getModelId() : null, inputLocation.getLineNumber(), inputLocation.getColumnNumber() - elementName.length() - 2, inputLocation.getColumnNumber() - 1);
    }

    private static SourceLocation getSourceLocation(InputLocation inputLocation, String elementName, SourceLocation causeLocation) {
        return new SourceLocation(inputLocation.getLineNumber(), inputLocation.getColumnNumber() - elementName.length() - 2, inputLocation.getColumnNumber() - 1, causeLocation);
    }
}

