/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jsf.core.internal.project.facet;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jst.common.project.facet.core.libprov.ILibraryProvider;
import org.eclipse.jst.common.project.facet.core.libprov.LegacyLibraryProviderDetector;
import org.eclipse.jst.common.project.facet.core.libprov.LibraryProviderFramework;
import org.eclipse.jst.jsf.core.internal.JSFCorePlugin;
import org.eclipse.jst.jsf.core.internal.jsflibraryconfig.JSFLibraryRegistryUtil;
import org.eclipse.jst.jsf.core.internal.jsflibraryregistry.JSFLibrary;
import org.eclipse.wst.common.project.facet.core.IProjectFacet;

public final class LegacyJSFLibraryProviderDetector
extends LegacyLibraryProviderDetector {
    private static final String LEGACY_JSF_LIBRARY_PROVIDER_ID = "legacy-jsf-library-provider";

    public ILibraryProvider detect(IProject project, IProjectFacet facet) {
        try {
            IJavaProject jproj = JavaCore.create((IProject)project);
            IClasspathEntry[] iClasspathEntryArray = jproj.getRawClasspath();
            int n = iClasspathEntryArray.length;
            int n2 = 0;
            while (n2 < n) {
                IClasspathEntry cpe = iClasspathEntryArray[n2];
                if (LegacyJSFLibraryProviderDetector.detect(cpe)) {
                    return LibraryProviderFramework.getProvider((String)LEGACY_JSF_LIBRARY_PROVIDER_ID);
                }
                ++n2;
            }
        }
        catch (Exception e) {
            JSFCorePlugin.log(e, e.getMessage());
        }
        return null;
    }

    public static boolean detect(IClasspathEntry cpe) {
        IPath path;
        if (cpe.getEntryKind() == 5 && LegacyJSFLibraryProviderDetector.isJSFLibraryContainer(path = cpe.getPath())) {
            String libId = path.lastSegment();
            JSFLibrary ref = JSFLibraryRegistryUtil.getInstance().getJSFLibraryRegistry().getJSFLibraryByID(libId);
            if (ref != null && ref.isImplementation()) {
                return true;
            }
        }
        return false;
    }

    private static boolean isJSFLibraryContainer(IPath path) {
        return path != null && path.segmentCount() == 2 && "org.eclipse.jst.jsf.core.internal.jsflibrarycontainer".equals(path.segment(0));
    }
}

