/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xml.xpath2.wtptypes;

import java.util.Collections;
import java.util.List;
import org.eclipse.wst.xml.core.internal.contentmodel.CMAttributeDeclaration;
import org.eclipse.wst.xml.core.internal.contentmodel.CMDocument;
import org.eclipse.wst.xml.core.internal.contentmodel.CMElementDeclaration;
import org.eclipse.wst.xml.core.internal.contentmodel.CMNode;
import org.eclipse.wst.xml.core.internal.contentmodel.modelquery.CMDocumentManager;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMDocument;
import org.eclipse.wst.xml.core.internal.ssemodelquery.ModelQueryAdapter;
import org.eclipse.wst.xml.xpath2.api.typesystem.TypeDefinition;
import org.eclipse.wst.xml.xpath2.api.typesystem.TypeModel;
import org.eclipse.wst.xsd.contentmodel.internal.XSDImpl;
import org.eclipse.xsd.XSDAttributeDeclaration;
import org.eclipse.xsd.XSDAttributeUse;
import org.eclipse.xsd.XSDComplexTypeDefinition;
import org.eclipse.xsd.XSDElementDeclaration;
import org.eclipse.xsd.XSDSchema;
import org.eclipse.xsd.XSDSimpleTypeDefinition;
import org.eclipse.xsd.XSDTypeDefinition;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XsdDOMTypeProvider {
    public TypeModel getTypeModel(Document doc) {
        if (doc instanceof IDOMDocument) {
            return new XsdTypeModel((IDOMDocument)doc);
        }
        return null;
    }

    public static <R> R wrapCMQuery(CMDocumentManager documentManager, WrappedCMQuery<R> query) {
        boolean wasAsync = documentManager.getPropertyEnabled("asyncLoad");
        boolean wasAutoLoad = documentManager.getPropertyEnabled("autoLoad");
        try {
            documentManager.setPropertyEnabled("asyncLoad", false);
            documentManager.setPropertyEnabled("autoLoad", true);
            R r = query.query();
            return r;
        }
        finally {
            documentManager.setPropertyEnabled("asyncLoad", wasAsync);
            documentManager.setPropertyEnabled("autoLoad", wasAutoLoad);
        }
    }

    static boolean isDerivedFrom(XSDTypeDefinition base, XSDTypeDefinition derived, short derivationMethod) {
        return base == derived;
    }

    public TypeModel getTypeModel() {
        return null;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface WrappedCMQuery<R> {
        public R query();
    }

    public static class XsdTypeModel
    implements TypeModel {
        private final ModelQueryAdapter modelAdapter;
        private final IDOMDocument doc;

        public XsdTypeModel(IDOMDocument doc) {
            this.doc = doc;
            this.modelAdapter = (ModelQueryAdapter)doc.getAdapterFor(ModelQueryAdapter.class);
        }

        private XSDTypeDefinition lookupXSDType(final String namespace, final String localName) {
            return XsdDOMTypeProvider.wrapCMQuery(this.modelAdapter.getModelQuery().getCMDocumentManager(), new WrappedCMQuery<XSDTypeDefinition>(){

                @Override
                public XSDTypeDefinition query() {
                    CMDocument cmDoc = XsdTypeModel.this.modelAdapter.getModelQuery().getCorrespondingCMDocument((Node)XsdTypeModel.this.doc.getDocumentElement());
                    if (cmDoc instanceof XSDImpl.XSDSchemaAdapter) {
                        XSDSchema schema = (XSDSchema)((XSDImpl.XSDSchemaAdapter)cmDoc).getKey();
                        XSDTypeDefinition typeDefinition = schema.resolveTypeDefinition(namespace, localName);
                        if (typeDefinition.getBaseType() == null) {
                            return null;
                        }
                        return typeDefinition;
                    }
                    return null;
                }
            });
        }

        public TypeDefinition lookupType(String namespace, String name) {
            XSDTypeDefinition xsdDef = this.lookupXSDType(namespace, name);
            return xsdDef != null ? new XsdTypeDefinition(xsdDef) : null;
        }

        public TypeDefinition lookupElementDeclaration(final String namespace, final String elementName) {
            return XsdDOMTypeProvider.wrapCMQuery(this.modelAdapter.getModelQuery().getCMDocumentManager(), new WrappedCMQuery<XsdTypeDefinition>(){

                @Override
                public XsdTypeDefinition query() {
                    XSDSchema schema;
                    XSDElementDeclaration declaration;
                    CMDocument cmDoc = XsdTypeModel.this.modelAdapter.getModelQuery().getCorrespondingCMDocument((Node)XsdTypeModel.this.doc.getDocumentElement());
                    if (cmDoc instanceof XSDImpl.XSDSchemaAdapter && (declaration = (schema = (XSDSchema)((XSDImpl.XSDSchemaAdapter)cmDoc).getKey()).resolveElementDeclaration(namespace, elementName)) != null) {
                        return new XsdTypeDefinition(declaration.getTypeDefinition());
                    }
                    return null;
                }
            });
        }

        public TypeDefinition lookupAttributeDeclaration(final String namespace, final String attributeName) {
            return XsdDOMTypeProvider.wrapCMQuery(this.modelAdapter.getModelQuery().getCMDocumentManager(), new WrappedCMQuery<XsdTypeDefinition>(){

                @Override
                public XsdTypeDefinition query() {
                    XSDSchema schema;
                    XSDAttributeDeclaration declaration;
                    CMDocument cmDoc = XsdTypeModel.this.modelAdapter.getModelQuery().getCorrespondingCMDocument((Node)XsdTypeModel.this.doc.getDocumentElement());
                    if (cmDoc instanceof XSDImpl.XSDSchemaAdapter && (declaration = (schema = (XSDSchema)((XSDImpl.XSDSchemaAdapter)cmDoc).getKey()).resolveAttributeDeclaration(namespace, attributeName)) != null) {
                        return new XsdTypeDefinition((XSDTypeDefinition)declaration.getTypeDefinition());
                    }
                    return null;
                }
            });
        }

        public TypeDefinition getType(final Node node) {
            return XsdDOMTypeProvider.wrapCMQuery(this.modelAdapter.getModelQuery().getCMDocumentManager(), new WrappedCMQuery<XsdTypeDefinition>(){

                @Override
                public XsdTypeDefinition query() {
                    if (node instanceof Attr) {
                        CMNode nodeDecl;
                        CMAttributeDeclaration declaration = XsdTypeModel.this.modelAdapter.getModelQuery().getCMAttributeDeclaration((Attr)node);
                        if (declaration == null && (nodeDecl = XsdTypeModel.this.modelAdapter.getModelQuery().getOrigin(node)) instanceof CMAttributeDeclaration) {
                            declaration = (CMAttributeDeclaration)nodeDecl;
                        }
                        if (declaration instanceof XSDImpl.XSDAttributeUseAdapter) {
                            XSDAttributeUse au = (XSDAttributeUse)((XSDImpl.XSDAttributeUseAdapter)declaration).getKey();
                            return new XsdTypeDefinition((XSDTypeDefinition)au.getAttributeDeclaration().getTypeDefinition());
                        }
                    } else if (node instanceof Element) {
                        CMNode nodeDecl;
                        CMElementDeclaration declaration = XsdTypeModel.this.modelAdapter.getModelQuery().getCMElementDeclaration((Element)node);
                        if (declaration == null && (nodeDecl = XsdTypeModel.this.modelAdapter.getModelQuery().getOrigin(node)) instanceof CMElementDeclaration) {
                            declaration = (CMElementDeclaration)nodeDecl;
                        }
                        if (declaration instanceof XSDImpl.XSDElementDeclarationAdapter) {
                            XSDElementDeclaration decl = ((XSDElementDeclaration)((XSDImpl.XSDElementDeclarationAdapter)declaration).getKey()).getResolvedElementDeclaration();
                            return new XsdTypeDefinition(decl.getTypeDefinition());
                        }
                    }
                    return null;
                }
            });
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public class XsdTypeDefinition
        implements TypeDefinition {
            private final XSDTypeDefinition typeDefinition;

            public XsdTypeDefinition(XSDTypeDefinition typeDefinition) {
                this.typeDefinition = typeDefinition;
            }

            public String getNamespace() {
                return this.typeDefinition.getTargetNamespace();
            }

            public String getName() {
                return this.getName();
            }

            public boolean isComplexType() {
                return this.typeDefinition instanceof XSDComplexTypeDefinition;
            }

            public TypeDefinition getBaseType() {
                XSDSimpleTypeDefinition base = null;
                if (this.typeDefinition instanceof XSDSimpleTypeDefinition) {
                    base = ((XSDSimpleTypeDefinition)this.typeDefinition).getBaseTypeDefinition();
                } else if (this.typeDefinition instanceof XSDComplexTypeDefinition) {
                    base = ((XSDComplexTypeDefinition)this.typeDefinition).getBaseTypeDefinition();
                }
                return base != null ? new XsdTypeDefinition((XSDTypeDefinition)base) : null;
            }

            public TypeDefinition getSimpleType() {
                return null;
            }

            public boolean derivedFromType(TypeDefinition ancestorType, short derivationMethod) {
                if (ancestorType == null) {
                    throw new NullPointerException("ancestorType must be non-null");
                }
                XSDTypeDefinition xsdAncestor = this.mapXsdType(ancestorType);
                if (xsdAncestor == null) {
                    return false;
                }
                return XsdDOMTypeProvider.isDerivedFrom(xsdAncestor, this.typeDefinition, derivationMethod);
            }

            private XSDTypeDefinition mapXsdType(TypeDefinition ancestorType) {
                if (ancestorType instanceof XsdTypeDefinition) {
                    return ((XsdTypeDefinition)ancestorType).typeDefinition;
                }
                return XsdTypeModel.this.lookupXSDType(ancestorType.getNamespace(), ancestorType.getName());
            }

            public boolean derivedFrom(String namespace, String name, short derivationMethod) {
                XSDTypeDefinition ancestorType = XsdTypeModel.this.lookupXSDType(namespace, name);
                if (ancestorType == null) {
                    return false;
                }
                return XsdDOMTypeProvider.isDerivedFrom(ancestorType, this.typeDefinition, derivationMethod);
            }

            public List<Short> getSimpleTypes(Attr attr) {
                return Collections.singletonList((short)0);
            }

            public List<Short> getSimpleTypes(Element attr) {
                return Collections.singletonList((short)0);
            }

            public Class getNativeType() {
                return null;
            }
        }
    }
}

