/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.wikitext.ui.editor.operations;

import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.mylyn.internal.wikitext.ui.editor.operations.AbstractDocumentCommand;
import org.eclipse.mylyn.internal.wikitext.ui.editor.operations.InsertLocation;
import org.eclipse.mylyn.internal.wikitext.ui.editor.operations.Messages;
import org.eclipse.mylyn.wikitext.parser.outline.OutlineItem;
import org.eclipse.swt.widgets.Text;

public class MoveSectionsCommand
extends AbstractDocumentCommand {
    private final OutlineItem target;
    private final List<OutlineItem> items;
    private final InsertLocation location;

    public MoveSectionsCommand(OutlineItem target, List<OutlineItem> items, InsertLocation location) {
        if (target == null || items == null || location == null) {
            throw new IllegalArgumentException();
        }
        if (items.isEmpty()) {
            throw new IllegalArgumentException();
        }
        this.target = target;
        this.items = items;
        this.location = location;
        this.validate();
    }

    private void validate() {
        for (OutlineItem item : this.items) {
            if (!item.contains(this.target)) continue;
            this.setProblemText(Messages.MoveSectionsCommand_invalidTargetLocation_self);
        }
    }

    @Override
    protected void doCommand(IDocument document) throws BadLocationException {
        int x = 0;
        while (x < this.items.size()) {
            OutlineItem item = this.items.get(x);
            int y = 0;
            while (y < x) {
                OutlineItem previousItem = this.items.get(y);
                if (previousItem.contains(item)) {
                    this.items.remove(x);
                    --x;
                    break;
                }
                if (item.contains(previousItem)) {
                    this.items.remove(y);
                    --x;
                    --y;
                }
                ++y;
            }
            ++x;
        }
        if (this.items.size() > 1) {
            Collections.sort(this.items, new OffsetComparator());
        }
        Section[] sections = new Section[this.items.size()];
        int x2 = 0;
        while (x2 < this.items.size()) {
            OutlineItem item = this.items.get(x2);
            sections[x2] = new Section(item.getOffset(), item.getSectionLength());
            ++x2;
        }
        int insertLocation = this.target.getOffset();
        if (this.location == InsertLocation.WITHIN) {
            List children = this.target.getChildren();
            if (children.isEmpty()) {
                insertLocation += this.target.getLength();
                while (insertLocation < document.getLength()) {
                    char c = document.getChar(insertLocation);
                    if (c == '\r' || c == '\n') {
                        ++insertLocation;
                        continue;
                    }
                    break;
                }
            } else {
                insertLocation = ((OutlineItem)children.get(0)).getOffset();
            }
        } else if (this.location == InsertLocation.AFTER) {
            insertLocation += this.target.getSectionLength();
        }
        String twoNewlines = String.valueOf(Text.DELIMITER) + Text.DELIMITER;
        int x3 = 0;
        while (x3 < sections.length) {
            Section section = sections[x3];
            String text = document.get(section.offset, section.length);
            document.replace(section.offset, section.length, "");
            int adjustmentFactor = 0;
            if (!text.endsWith(twoNewlines)) {
                text = String.valueOf(text) + twoNewlines;
                adjustmentFactor = twoNewlines.length();
                section.length += adjustmentFactor;
            }
            if (section.offset < insertLocation) {
                insertLocation -= section.length;
            }
            int insertedLocation = insertLocation;
            document.replace(insertedLocation, 0, text);
            insertLocation += section.length;
            int y = x3 + 1;
            while (y < sections.length) {
                Section section2 = sections[y];
                if (section2.offset < insertedLocation) {
                    section2.offset -= section.length;
                } else if (adjustmentFactor > 0) {
                    section2.offset += adjustmentFactor;
                }
                ++y;
            }
            ++x3;
        }
    }

    public static class OffsetComparator
    implements Comparator<OutlineItem> {
        @Override
        public int compare(OutlineItem o1, OutlineItem o2) {
            if (o1 == o2) {
                return 0;
            }
            if (o1.getOffset() < o2.getOffset()) {
                return -1;
            }
            if (o1.getOffset() > o2.getOffset()) {
                return 1;
            }
            return 0;
        }
    }

    private static class Section {
        int offset;
        int length;

        public Section(int offset, int length) {
            this.offset = offset;
            this.length = length;
        }
    }
}

