/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.ws.internal.cxf.creation.core.commands;

import java.lang.reflect.InvocationTargetException;
import java.util.Set;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.corext.refactoring.structure.ExtractInterfaceProcessor;
import org.eclipse.jdt.internal.ui.actions.WorkbenchRunnableAdapter;
import org.eclipse.jdt.internal.ui.preferences.JavaPreferencesSettings;
import org.eclipse.jdt.internal.ui.util.BusyIndicatorRunnableContext;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jst.ws.internal.cxf.core.model.Java2WSDataModel;
import org.eclipse.jst.ws.internal.cxf.core.utils.CXFModelUtils;
import org.eclipse.jst.ws.internal.cxf.creation.core.CXFCreationCorePlugin;
import org.eclipse.jst.ws.jaxws.core.utils.JDTUtils;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.CheckConditionsOperation;
import org.eclipse.ltk.core.refactoring.CreateChangeOperation;
import org.eclipse.ltk.core.refactoring.PerformChangeOperation;
import org.eclipse.ltk.core.refactoring.Refactoring;
import org.eclipse.ltk.core.refactoring.RefactoringCore;
import org.eclipse.ltk.core.refactoring.participants.ProcessorBasedRefactoring;
import org.eclipse.ltk.core.refactoring.participants.RefactoringProcessor;
import org.eclipse.ui.PlatformUI;
import org.eclipse.wst.command.internal.env.ant.AntEnvironment;
import org.eclipse.wst.common.frameworks.datamodel.AbstractDataModelOperation;

public class Java2WSSelectSEICommand
extends AbstractDataModelOperation {
    private Change undoExtractInterfaceChange;
    private Java2WSDataModel model;
    private IType startingPointType;

    public Java2WSSelectSEICommand(Java2WSDataModel model) {
        this.model = model;
    }

    public IStatus execute(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
        IStatus status = Status.OK_STATUS;
        try {
            String projectName = this.model.getProjectName();
            String javaStartingPoint = this.model.getJavaStartingPoint();
            IJavaProject javaProject = JDTUtils.getJavaProject((String)projectName);
            this.startingPointType = JDTUtils.findType((IJavaProject)javaProject, (String)javaStartingPoint);
            if (this.startingPointType.isInterface()) {
                this.model.setFullyQualifiedJavaInterfaceName(this.startingPointType.getFullyQualifiedName());
            } else if (this.startingPointType.isClass()) {
                this.model.setFullyQualifiedJavaClassName(this.startingPointType.getFullyQualifiedName());
                if (this.model.isUseServiceEndpointInterface() && this.model.isExtractInterface()) {
                    this.extractInterface(this.startingPointType, monitor);
                }
            }
        }
        catch (JavaModelException jme) {
            status = jme.getStatus();
            CXFCreationCorePlugin.log(status);
        }
        return status;
    }

    private void extractInterface(IType type, IProgressMonitor monitor) {
        if (this.getEnvironment() instanceof AntEnvironment) {
            return;
        }
        try {
            final ExtractInterfaceProcessor extractInterfaceProcessor = new ExtractInterfaceProcessor(type, JavaPreferencesSettings.getCodeGenerationSettings((IJavaProject)type.getJavaProject()));
            ProcessorBasedRefactoring extractInterfaceRefactoring = new ProcessorBasedRefactoring((RefactoringProcessor)extractInterfaceProcessor){

                public RefactoringProcessor getProcessor() {
                    return extractInterfaceProcessor;
                }
            };
            String typeName = this.model.getServiceEndpointInterfaceName();
            if (typeName.indexOf(".") != -1) {
                typeName = typeName.substring(typeName.lastIndexOf(".") + 1, typeName.length());
            }
            extractInterfaceProcessor.setTypeName(typeName);
            extractInterfaceProcessor.setReplace(false);
            Set methods = this.model.getMethodMap().keySet();
            extractInterfaceProcessor.setExtractedMembers(methods.toArray(new IMember[methods.size()]));
            extractInterfaceProcessor.setComments(false);
            extractInterfaceProcessor.setInstanceOf(false);
            CreateChangeOperation createChangeOperation = new CreateChangeOperation(new CheckConditionsOperation((Refactoring)extractInterfaceRefactoring, 4), RefactoringCore.getConditionCheckingFailedSeverity());
            PerformChangeOperation performChangeOperation = new PerformChangeOperation(createChangeOperation);
            WorkbenchRunnableAdapter adapter = new WorkbenchRunnableAdapter((IWorkspaceRunnable)performChangeOperation);
            PlatformUI.getWorkbench().getProgressService().runInUI((IRunnableContext)new BusyIndicatorRunnableContext(), (IRunnableWithProgress)adapter, adapter.getSchedulingRule());
            if (performChangeOperation.changeExecuted()) {
                String packageName = type.getPackageFragment().getElementName();
                if (packageName.trim().length() > 0) {
                    packageName = String.valueOf(packageName) + ".";
                }
                String fullyQualifiedJavaInterfaceName = String.valueOf(packageName) + extractInterfaceProcessor.getTypeName();
                this.model.setFullyQualifiedJavaInterfaceName(fullyQualifiedJavaInterfaceName);
                this.model.setMethodMap(CXFModelUtils.getMethodMap((IType)JDTUtils.findType((String)this.model.getProjectName(), (String)fullyQualifiedJavaInterfaceName), (Java2WSDataModel)this.model));
                this.undoExtractInterfaceChange = performChangeOperation.getUndoChange();
            }
        }
        catch (JavaModelException jme) {
            CXFCreationCorePlugin.log(jme.getStatus());
        }
        catch (InvocationTargetException ite) {
            CXFCreationCorePlugin.log(ite);
        }
        catch (InterruptedException ie) {
            CXFCreationCorePlugin.log(ie);
        }
    }

    public IStatus undo(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
        IStatus status = Status.OK_STATUS;
        if (this.undoExtractInterfaceChange != null) {
            try {
                PerformChangeOperation changeOperation = new PerformChangeOperation(this.undoExtractInterfaceChange);
                WorkbenchRunnableAdapter adapter = new WorkbenchRunnableAdapter((IWorkspaceRunnable)changeOperation);
                PlatformUI.getWorkbench().getProgressService().runInUI((IRunnableContext)new BusyIndicatorRunnableContext(), (IRunnableWithProgress)adapter, adapter.getSchedulingRule());
                if (!this.startingPointType.getCompilationUnit().isConsistent()) {
                    this.startingPointType.getCompilationUnit().makeConsistent(monitor);
                }
                this.model.setMethodMap(CXFModelUtils.getMethodMap((IType)this.startingPointType, (Java2WSDataModel)this.model));
            }
            catch (JavaModelException jme) {
                status = jme.getStatus();
                CXFCreationCorePlugin.log(status);
            }
            catch (InvocationTargetException ite) {
                status = new Status(4, "org.eclipse.jst.ws.cxf.creation.core", ite.getLocalizedMessage());
                CXFCreationCorePlugin.log(status);
            }
            catch (InterruptedException ie) {
                status = new Status(4, "org.eclipse.jst.ws.cxf.creation.core", ie.getLocalizedMessage());
                CXFCreationCorePlugin.log(status);
            }
        }
        return status;
    }
}

