/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.geo;

import org.apache.lucene.util.SloppyMath;

public final class GeoUtils {
    public static final double MIN_LON_INCL = -180.0;
    public static final double MAX_LON_INCL = 180.0;
    public static final double MIN_LAT_INCL = -90.0;
    public static final double MAX_LAT_INCL = 90.0;
    public static final double MIN_LON_RADIANS = -Math.PI;
    public static final double MIN_LAT_RADIANS = -1.5707963267948966;
    public static final double MAX_LON_RADIANS = Math.PI;
    public static final double MAX_LAT_RADIANS = 1.5707963267948966;
    public static final double EARTH_MEAN_RADIUS_METERS = 6371008.7714;
    private static final double PIO2 = 1.5707963267948966;

    private GeoUtils() {
    }

    public static void checkLatitude(double latitude) {
        if (Double.isNaN(latitude) || latitude < -90.0 || latitude > 90.0) {
            throw new IllegalArgumentException("invalid latitude " + latitude + "; must be between " + -90.0 + " and " + 90.0);
        }
    }

    public static void checkLongitude(double longitude) {
        if (Double.isNaN(longitude) || longitude < -180.0 || longitude > 180.0) {
            throw new IllegalArgumentException("invalid longitude " + longitude + "; must be between " + -180.0 + " and " + 180.0);
        }
    }

    public static double sloppySin(double a) {
        return SloppyMath.cos(a - 1.5707963267948966);
    }
}

