/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.ws.internal.cxf.core.context;

import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.jst.ws.internal.cxf.core.CXFCorePlugin;
import org.eclipse.jst.ws.internal.cxf.core.model.CXFContext;
import org.eclipse.jst.ws.internal.cxf.core.model.CXFFactory;
import org.eclipse.jst.ws.internal.cxf.core.model.CXFInstall;
import org.eclipse.jst.ws.internal.cxf.core.utils.CXFModelUtils;
import org.eclipse.wst.command.internal.env.context.PersistentContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class CXFPersistentContext
extends PersistentContext
implements CXFContext {
    private Map<String, CXFInstall> installations;
    private static final String PREFERENCE_DEFAULT_RUNTIME_LOCATION = "defaultRuntimeLocation";
    private static final String PREFERENCE_DEFAULT_RUNTIME_TYPE = "defaultRuntimeType";
    private static final String PREFERENCE_DEFAULT_RUNTIME_VERSION = "defaultRuntimeVersion";
    private static final String PREFERENCE_CXF_RUNTIME_VERSIONS = "cxfRuntimeVersions";
    private static final String PREFERENCE_CXF_RUNTIME_LOCATIONS = "cxfRuntimeLocations";
    private static final String PREFERENCE_CXF_RUNTIME_TYPES = "cxfRuntimeTypes";
    private static final String PREFERENCE_EXPORT_CXF_CLASSPATH_CONTAINER = "exportCXFClasspathContainer";
    private static final String PREFERENCE_CXF_VERBOSE = "cxfVerbose";
    private static final String PREFERENCE_CXF_USE_SPRING_APP_CONTEXT = "cxfUseSpringAppContext";

    public CXFPersistentContext(Plugin plugin) {
        super((Plugin)CXFCorePlugin.getDefault());
    }

    public void load() {
        this.setDefault(PREFERENCE_DEFAULT_RUNTIME_LOCATION, "");
        this.setDefault(PREFERENCE_DEFAULT_RUNTIME_TYPE, "");
        this.setDefault(PREFERENCE_DEFAULT_RUNTIME_VERSION, "");
        this.setDefault(PREFERENCE_CXF_RUNTIME_VERSIONS, "");
        this.setDefault(PREFERENCE_CXF_RUNTIME_LOCATIONS, "");
        this.setDefault(PREFERENCE_CXF_RUNTIME_TYPES, "");
        this.setDefault(PREFERENCE_EXPORT_CXF_CLASSPATH_CONTAINER, CXFModelUtils.getDefaultBooleanValue(0, 10));
        this.setDefault(PREFERENCE_CXF_VERBOSE, CXFModelUtils.getDefaultBooleanValue(0, 3));
        this.setDefault(PREFERENCE_CXF_USE_SPRING_APP_CONTEXT, CXFModelUtils.getDefaultBooleanValue(0, 9));
    }

    @Override
    public Map<String, CXFInstall> getInstallations() {
        if (this.installations == null) {
            this.installations = new HashMap<String, CXFInstall>();
            String versions = this.getValueAsString(PREFERENCE_CXF_RUNTIME_VERSIONS).trim();
            String loctions = this.getValueAsString(PREFERENCE_CXF_RUNTIME_LOCATIONS).trim();
            String types = this.getValueAsString(PREFERENCE_CXF_RUNTIME_TYPES).trim();
            if (versions.trim().length() > 0 && loctions.trim().length() > 0 && types.trim().length() > 0) {
                String[] cxfVersions = versions.split(",");
                String[] cxfLocations = loctions.split(",");
                String[] cxfTypes = types.split(",");
                int i = 0;
                while (i < cxfVersions.length) {
                    CXFInstall cxfInstall = CXFFactory.eINSTANCE.createCXFInstall();
                    cxfInstall.setVersion(cxfVersions[i]);
                    cxfInstall.setLocation(cxfLocations[i]);
                    cxfInstall.setType(cxfTypes[i]);
                    this.installations.put(cxfVersions[i], cxfInstall);
                    ++i;
                }
            }
        }
        return this.installations;
    }

    @Override
    public void setInstallations(Map<String, CXFInstall> installations) {
        this.installations = installations;
        Collection<CXFInstall> installs = installations.values();
        StringBuilder versions = new StringBuilder();
        StringBuilder locations = new StringBuilder();
        StringBuilder types = new StringBuilder();
        Iterator<CXFInstall> installIter = installs.iterator();
        while (installIter.hasNext()) {
            CXFInstall cxfInstall = installIter.next();
            versions.append(cxfInstall.getVersion());
            locations.append(cxfInstall.getLocation());
            types.append(cxfInstall.getType());
            if (!installIter.hasNext()) continue;
            versions.append(",");
            locations.append(",");
            types.append(",");
        }
        this.setValue(PREFERENCE_CXF_RUNTIME_VERSIONS, versions.toString());
        this.setValue(PREFERENCE_CXF_RUNTIME_LOCATIONS, locations.toString());
        this.setValue(PREFERENCE_CXF_RUNTIME_TYPES, types.toString());
    }

    @Override
    public String getDefaultRuntimeLocation() {
        return this.getValueAsString(PREFERENCE_DEFAULT_RUNTIME_LOCATION);
    }

    @Override
    public void setDefaultRuntimeLocation(String runtimeLocation) {
        this.setValue(PREFERENCE_DEFAULT_RUNTIME_LOCATION, runtimeLocation);
    }

    @Override
    public String getDefaultRuntimeType() {
        return this.getValueAsString(PREFERENCE_DEFAULT_RUNTIME_TYPE);
    }

    @Override
    public void setDefaultRuntimeType(String runtimeEdition) {
        this.setValue(PREFERENCE_DEFAULT_RUNTIME_TYPE, runtimeEdition);
    }

    @Override
    public String getDefaultRuntimeVersion() {
        return this.getValueAsString(PREFERENCE_DEFAULT_RUNTIME_VERSION);
    }

    @Override
    public void setDefaultRuntimeVersion(String runtimeVersion) {
        this.setValue(PREFERENCE_DEFAULT_RUNTIME_VERSION, runtimeVersion);
    }

    @Override
    public boolean isExportCXFClasspathContainer() {
        return this.getValueAsBoolean(PREFERENCE_EXPORT_CXF_CLASSPATH_CONTAINER);
    }

    @Override
    public void setExportCXFClasspathContainer(boolean exportCXFClasspathContainer) {
        this.setValue(PREFERENCE_EXPORT_CXF_CLASSPATH_CONTAINER, exportCXFClasspathContainer);
    }

    @Override
    public boolean isVerbose() {
        return this.getValueAsBoolean(PREFERENCE_CXF_VERBOSE);
    }

    @Override
    public void setVerbose(boolean verbose) {
        this.setValue(PREFERENCE_CXF_VERBOSE, true);
    }

    @Override
    public boolean isUseSpringApplicationContext() {
        return this.getValueAsBoolean(PREFERENCE_CXF_USE_SPRING_APP_CONTEXT);
    }

    @Override
    public void setUseSpringApplicationContext(boolean useSpringAppContext) {
        this.setValue(PREFERENCE_CXF_USE_SPRING_APP_CONTEXT, useSpringAppContext);
    }
}

