/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.quickaccess.providers;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.ui.IPerspectiveDescriptor;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.activities.WorkbenchActivityHelper;
import org.eclipse.ui.internal.WorkbenchImages;
import org.eclipse.ui.internal.quickaccess.QuickAccessMessages;
import org.eclipse.ui.internal.quickaccess.QuickAccessProvider;
import org.eclipse.ui.internal.quickaccess.providers.PerspectiveElement;
import org.eclipse.ui.quickaccess.QuickAccessElement;

public class PerspectiveProvider
extends QuickAccessProvider {
    private QuickAccessElement[] cachedElements;
    private Map<String, PerspectiveElement> idToElement = new HashMap<String, PerspectiveElement>();

    @Override
    public String getId() {
        return "org.eclipse.ui.perspectives";
    }

    @Override
    public QuickAccessElement findElement(String id, String filterText) {
        this.getElements();
        return this.idToElement.get(id);
    }

    @Override
    public QuickAccessElement[] getElements() {
        if (this.cachedElements == null) {
            IPerspectiveDescriptor[] perspectives = PlatformUI.getWorkbench().getPerspectiveRegistry().getPerspectives();
            this.cachedElements = new QuickAccessElement[perspectives.length];
            IPerspectiveDescriptor[] iPerspectiveDescriptorArray = perspectives;
            int n = perspectives.length;
            int n2 = 0;
            while (n2 < n) {
                IPerspectiveDescriptor perspective = iPerspectiveDescriptorArray[n2];
                if (!WorkbenchActivityHelper.filterItem(perspective)) {
                    PerspectiveElement perspectiveElement = new PerspectiveElement(perspective);
                    this.idToElement.put(perspectiveElement.getId(), perspectiveElement);
                }
                ++n2;
            }
            this.cachedElements = this.idToElement.values().toArray(new QuickAccessElement[this.idToElement.size()]);
        }
        return this.cachedElements;
    }

    @Override
    public ImageDescriptor getImageDescriptor() {
        return WorkbenchImages.getImageDescriptor("IMG_ETOOL_DEF_PERSPECTIVE");
    }

    @Override
    public String getName() {
        return QuickAccessMessages.QuickAccess_Perspectives;
    }

    @Override
    protected void doReset() {
        this.cachedElements = null;
        this.idToElement.clear();
    }

    @Override
    public boolean requiresUiAccess() {
        return true;
    }
}

