/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.connectivity.internal.ui;

import java.util.ArrayList;
import org.eclipse.datatools.connectivity.drivers.IPropertySet;
import org.eclipse.datatools.connectivity.drivers.models.CategoryDescriptor;
import org.eclipse.datatools.connectivity.drivers.models.TemplateDescriptor;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;

public class DriverTreeFilter
extends ViewerFilter {
    private String mCategoryId;
    private CategoryDescriptor mCategoryDescriptor;
    private String mDriverTemplateId;
    protected ArrayList okCategoryIds;
    protected ArrayList okTemplateIds;
    private boolean parentIsOk = true;

    public DriverTreeFilter() {
    }

    public DriverTreeFilter(boolean flag) {
        this.parentIsOk = flag;
    }

    public void setCategoryId(String categoryId) {
        this.mCategoryId = categoryId;
        this.mCategoryDescriptor = CategoryDescriptor.getCategoryDescriptor((String)categoryId);
        this.refreshOkList();
    }

    public String getCategoryId() {
        return this.mCategoryId;
    }

    public CategoryDescriptor getCategoryDescriptor() {
        return this.mCategoryDescriptor;
    }

    public void setDriverTemplateId(String driverTemplateId) {
        this.mDriverTemplateId = driverTemplateId;
    }

    private void refreshOkList() {
        block7: {
            block6: {
                this.okCategoryIds = new ArrayList();
                this.okTemplateIds = new ArrayList();
                if (this.mCategoryId == null) break block6;
                this.okCategoryIds = new ArrayList();
                this.okCategoryIds.add(this.mCategoryId);
                CategoryDescriptor category = CategoryDescriptor.getCategoryDescriptor((String)this.mCategoryId);
                if (category == null) break block7;
                if (category.getParentCategory() != null && this.parentIsOk) {
                    CategoryDescriptor parent = CategoryDescriptor.getCategoryDescriptor((String)category.getParentCategory());
                    this.okCategoryIds.add(parent.getId());
                    while (parent.getParentCategory() != null) {
                        parent = CategoryDescriptor.getCategoryDescriptor((String)parent.getParentCategory());
                        this.okCategoryIds.add(parent.getId());
                    }
                } else {
                    this.addChildren(category);
                }
                break block7;
            }
            if (this.mDriverTemplateId != null) {
                this.okTemplateIds.add(this.mDriverTemplateId);
                TemplateDescriptor template = TemplateDescriptor.getDriverTemplateDescriptor((String)this.mDriverTemplateId);
                if (template != null && template.getParentCategory() != null) {
                    CategoryDescriptor parent = CategoryDescriptor.getCategoryDescriptor((String)template.getParentCategory());
                    this.okCategoryIds.add(parent.getId());
                    while (parent.getParentCategory() != null) {
                        parent = CategoryDescriptor.getCategoryDescriptor((String)parent.getParentCategory());
                        this.okCategoryIds.add(parent.getId());
                    }
                }
            }
        }
    }

    private void addChildren(CategoryDescriptor parent) {
        Object[] children = parent.getChildCategories().toArray();
        if (children.length > 0) {
            int i = 0;
            while (i < children.length) {
                CategoryDescriptor child = (CategoryDescriptor)children[i];
                this.okCategoryIds.add(child.getId());
                this.addChildren(child);
                ++i;
            }
        }
    }

    public boolean select(Viewer viewer, Object parentElement, Object element) {
        if (element instanceof TemplateDescriptor) {
            CategoryDescriptor cd = ((TemplateDescriptor)element).getParent();
            while (cd != null) {
                if (cd.getId().equals(this.mCategoryId)) {
                    return true;
                }
                cd = cd.getParent();
            }
        } else if (element instanceof CategoryDescriptor) {
            CategoryDescriptor cd = this.mCategoryDescriptor;
            while (cd != null) {
                if (cd.getId().equals(((CategoryDescriptor)element).getId())) {
                    return true;
                }
                cd = cd.getParent();
            }
            cd = (CategoryDescriptor)element;
            while (cd != null) {
                if (cd.getId().equals(this.mCategoryId)) {
                    return true;
                }
                cd = cd.getParent();
            }
        } else if (element instanceof IPropertySet) {
            TemplateDescriptor template;
            if (this.mDriverTemplateId != null && this.okTemplateIds.contains((template = (TemplateDescriptor)element).getId())) {
                return true;
            }
            return true;
        }
        return false;
    }
}

