/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpa.core.internal.jpa1.context.orm;

import java.util.ArrayList;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jpt.common.utility.internal.ObjectTools;
import org.eclipse.jpt.common.utility.internal.collection.ListTools;
import org.eclipse.jpt.common.utility.internal.iterable.EmptyIterable;
import org.eclipse.jpt.common.utility.internal.iterable.IterableTools;
import org.eclipse.jpt.common.utility.iterable.ListIterable;
import org.eclipse.jpt.jpa.core.context.DatabaseGenerator;
import org.eclipse.jpt.jpa.core.context.JpaContextModel;
import org.eclipse.jpt.jpa.core.context.SpecifiedUniqueConstraint;
import org.eclipse.jpt.jpa.core.context.TableGenerator;
import org.eclipse.jpt.jpa.core.context.java.JavaSpecifiedUniqueConstraint;
import org.eclipse.jpt.jpa.core.context.java.JavaTableGenerator;
import org.eclipse.jpt.jpa.core.context.orm.OrmSpecifiedUniqueConstraint;
import org.eclipse.jpt.jpa.core.context.orm.OrmTableGenerator;
import org.eclipse.jpt.jpa.core.internal.context.AbstractJpaContextModel;
import org.eclipse.jpt.jpa.core.internal.context.orm.AbstractOrmDatabaseGenerator;
import org.eclipse.jpt.jpa.core.resource.orm.OrmFactory;
import org.eclipse.jpt.jpa.core.resource.orm.XmlTableGenerator;
import org.eclipse.jpt.jpa.core.resource.orm.XmlUniqueConstraint;
import org.eclipse.jpt.jpa.db.Schema;
import org.eclipse.jpt.jpa.db.Table;

public class GenericOrmTableGenerator
extends AbstractOrmDatabaseGenerator<XmlTableGenerator>
implements OrmTableGenerator,
SpecifiedUniqueConstraint.Parent {
    protected String specifiedTableName;
    protected String defaultTableName;
    protected String specifiedSchema;
    protected String defaultSchema;
    protected String specifiedCatalog;
    protected String defaultCatalog;
    protected String specifiedPkColumnName;
    protected String defaultPkColumnName;
    protected String specifiedValueColumnName;
    protected String defaultValueColumnName;
    protected String specifiedPkColumnValue;
    protected String defaultPkColumnValue;
    protected final AbstractJpaContextModel.ContextListContainer<OrmSpecifiedUniqueConstraint, XmlUniqueConstraint> uniqueConstraintContainer;

    public GenericOrmTableGenerator(JpaContextModel parent, XmlTableGenerator xmlTableGenerator) {
        super(parent, xmlTableGenerator);
        this.specifiedTableName = xmlTableGenerator.getTable();
        this.specifiedSchema = xmlTableGenerator.getSchema();
        this.specifiedCatalog = xmlTableGenerator.getCatalog();
        this.specifiedPkColumnName = xmlTableGenerator.getPkColumnName();
        this.specifiedValueColumnName = xmlTableGenerator.getValueColumnName();
        this.specifiedPkColumnValue = xmlTableGenerator.getPkColumnValue();
        this.uniqueConstraintContainer = this.buildUniqueConstraintContainer();
    }

    @Override
    public void synchronizeWithResourceModel(IProgressMonitor monitor) {
        super.synchronizeWithResourceModel(monitor);
        this.setSpecifiedTableName_(((XmlTableGenerator)this.xmlGenerator).getTable());
        this.setSpecifiedSchema_(((XmlTableGenerator)this.xmlGenerator).getSchema());
        this.setSpecifiedCatalog_(((XmlTableGenerator)this.xmlGenerator).getCatalog());
        this.setSpecifiedPkColumnName_(((XmlTableGenerator)this.xmlGenerator).getPkColumnName());
        this.setSpecifiedValueColumnName_(((XmlTableGenerator)this.xmlGenerator).getValueColumnName());
        this.setSpecifiedPkColumnValue_(((XmlTableGenerator)this.xmlGenerator).getPkColumnValue());
        this.syncUniqueConstraints(monitor);
    }

    @Override
    public void update(IProgressMonitor monitor) {
        super.update(monitor);
        this.setDefaultTableName(this.buildDefaultTableName());
        this.setDefaultSchema(this.buildDefaultSchema());
        this.setDefaultCatalog(this.buildDefaultCatalog());
        this.setDefaultPkColumnName(this.buildDefaultPkColumnName());
        this.setDefaultValueColumnName(this.buildDefaultValueColumnName());
        this.setDefaultPkColumnValue(this.buildDefaultPkColumnValue());
        this.updateModels((Iterable<? extends JpaContextModel>)this.getUniqueConstraints(), monitor);
    }

    @Override
    protected int buildDefaultInitialValue() {
        return 0;
    }

    @Override
    public String getTableName() {
        return this.specifiedTableName != null ? this.specifiedTableName : this.defaultTableName;
    }

    @Override
    public String getSpecifiedTableName() {
        return this.specifiedTableName;
    }

    @Override
    public void setSpecifiedTableName(String tableName) {
        this.setSpecifiedTableName_(tableName);
        ((XmlTableGenerator)this.xmlGenerator).setTable(tableName);
    }

    protected void setSpecifiedTableName_(String tableName) {
        String old = this.specifiedTableName;
        this.specifiedTableName = tableName;
        this.firePropertyChanged("specifiedTableName", old, tableName);
    }

    @Override
    public String getDefaultTableName() {
        return this.defaultTableName;
    }

    protected void setDefaultTableName(String tableName) {
        String old = this.defaultTableName;
        this.defaultTableName = tableName;
        this.firePropertyChanged("defaultTableName", old, tableName);
    }

    protected String buildDefaultTableName() {
        return null;
    }

    @Override
    public Table getDbTable() {
        Schema dbSchema = this.getDbSchema();
        return dbSchema == null ? null : dbSchema.getTableForIdentifier(this.getTableName());
    }

    @Override
    public String getSchema() {
        return this.specifiedSchema != null ? this.specifiedSchema : this.defaultSchema;
    }

    @Override
    public String getSpecifiedSchema() {
        return this.specifiedSchema;
    }

    @Override
    public void setSpecifiedSchema(String schema) {
        this.setSpecifiedSchema_(schema);
        ((XmlTableGenerator)this.xmlGenerator).setSchema(schema);
    }

    protected void setSpecifiedSchema_(String schema) {
        String old = this.specifiedSchema;
        this.specifiedSchema = schema;
        this.firePropertyChanged("specifiedSchema", old, schema);
    }

    @Override
    public String getDefaultSchema() {
        return this.defaultSchema;
    }

    protected void setDefaultSchema(String schema) {
        String old = this.defaultSchema;
        this.defaultSchema = schema;
        this.firePropertyChanged("defaultSchema", old, schema);
    }

    protected String buildDefaultSchema() {
        return this.getContextDefaultSchema();
    }

    @Override
    public String getCatalog() {
        return this.specifiedCatalog != null ? this.specifiedCatalog : this.defaultCatalog;
    }

    @Override
    public String getSpecifiedCatalog() {
        return this.specifiedCatalog;
    }

    @Override
    public void setSpecifiedCatalog(String catalog) {
        this.setSpecifiedCatalog_(catalog);
        ((XmlTableGenerator)this.xmlGenerator).setCatalog(catalog);
    }

    protected void setSpecifiedCatalog_(String catalog) {
        String old = this.specifiedCatalog;
        this.specifiedCatalog = catalog;
        this.firePropertyChanged("specifiedCatalog", old, catalog);
    }

    @Override
    public String getDefaultCatalog() {
        return this.defaultCatalog;
    }

    protected void setDefaultCatalog(String catalog) {
        String old = this.defaultCatalog;
        this.defaultCatalog = catalog;
        this.firePropertyChanged("defaultCatalog", old, catalog);
    }

    protected String buildDefaultCatalog() {
        return this.getContextDefaultCatalog();
    }

    @Override
    public String getPkColumnName() {
        return this.specifiedPkColumnName != null ? this.specifiedPkColumnName : this.defaultPkColumnName;
    }

    @Override
    public String getSpecifiedPkColumnName() {
        return this.specifiedPkColumnName;
    }

    @Override
    public void setSpecifiedPkColumnName(String name) {
        this.setSpecifiedPkColumnName_(name);
        ((XmlTableGenerator)this.xmlGenerator).setPkColumnName(name);
    }

    protected void setSpecifiedPkColumnName_(String name) {
        String old = this.specifiedPkColumnName;
        this.specifiedPkColumnName = name;
        this.firePropertyChanged("specifiedPkColumnName", old, name);
    }

    @Override
    public String getDefaultPkColumnName() {
        return this.defaultPkColumnName;
    }

    protected void setDefaultPkColumnName(String name) {
        String old = this.defaultPkColumnName;
        this.defaultPkColumnName = name;
        this.firePropertyChanged("defaultPkColumnName", old, name);
    }

    protected String buildDefaultPkColumnName() {
        return null;
    }

    @Override
    public String getValueColumnName() {
        return this.specifiedValueColumnName != null ? this.specifiedValueColumnName : this.defaultValueColumnName;
    }

    @Override
    public String getSpecifiedValueColumnName() {
        return this.specifiedValueColumnName;
    }

    @Override
    public void setSpecifiedValueColumnName(String name) {
        this.setSpecifiedValueColumnName_(name);
        ((XmlTableGenerator)this.xmlGenerator).setValueColumnName(name);
    }

    protected void setSpecifiedValueColumnName_(String name) {
        String old = this.specifiedValueColumnName;
        this.specifiedValueColumnName = name;
        this.firePropertyChanged("specifiedValueColumnName", old, name);
    }

    @Override
    public String getDefaultValueColumnName() {
        return this.defaultValueColumnName;
    }

    protected void setDefaultValueColumnName(String name) {
        String old = this.defaultValueColumnName;
        this.defaultValueColumnName = name;
        this.firePropertyChanged("defaultValueColumnName", old, name);
    }

    protected String buildDefaultValueColumnName() {
        return null;
    }

    @Override
    public String getPkColumnValue() {
        return this.specifiedPkColumnValue != null ? this.specifiedPkColumnValue : this.defaultPkColumnValue;
    }

    @Override
    public String getSpecifiedPkColumnValue() {
        return this.specifiedPkColumnValue;
    }

    @Override
    public void setSpecifiedPkColumnValue(String value) {
        this.setSpecifiedPkColumnValue_(value);
        ((XmlTableGenerator)this.xmlGenerator).setPkColumnValue(value);
    }

    protected void setSpecifiedPkColumnValue_(String value) {
        String old = this.specifiedPkColumnValue;
        this.specifiedPkColumnValue = value;
        this.firePropertyChanged("specifiedPkColummValue", old, value);
    }

    @Override
    public String getDefaultPkColumnValue() {
        return this.defaultPkColumnValue;
    }

    protected void setDefaultPkColumnValue(String value) {
        String old = this.defaultPkColumnValue;
        this.defaultPkColumnValue = value;
        this.firePropertyChanged("defaultPkColummValue", old, value);
    }

    protected String buildDefaultPkColumnValue() {
        return null;
    }

    public ListIterable<OrmSpecifiedUniqueConstraint> getUniqueConstraints() {
        return this.uniqueConstraintContainer;
    }

    @Override
    public int getUniqueConstraintsSize() {
        return this.uniqueConstraintContainer.size();
    }

    @Override
    public OrmSpecifiedUniqueConstraint getUniqueConstraint(int index) {
        return (OrmSpecifiedUniqueConstraint)this.uniqueConstraintContainer.get(index);
    }

    @Override
    public OrmSpecifiedUniqueConstraint addUniqueConstraint() {
        return this.addUniqueConstraint(this.getUniqueConstraintsSize());
    }

    @Override
    public OrmSpecifiedUniqueConstraint addUniqueConstraint(int index) {
        XmlUniqueConstraint xmlConstraint = this.buildXmlUniqueConstraint();
        OrmSpecifiedUniqueConstraint constraint = (OrmSpecifiedUniqueConstraint)this.uniqueConstraintContainer.addContextElement(index, xmlConstraint);
        ((XmlTableGenerator)this.xmlGenerator).getUniqueConstraints().add(index, (Object)xmlConstraint);
        return constraint;
    }

    protected XmlUniqueConstraint buildXmlUniqueConstraint() {
        return OrmFactory.eINSTANCE.createXmlUniqueConstraint();
    }

    @Override
    public void removeUniqueConstraint(SpecifiedUniqueConstraint uniqueConstraint) {
        this.removeUniqueConstraint(this.uniqueConstraintContainer.indexOf((OrmSpecifiedUniqueConstraint)uniqueConstraint));
    }

    @Override
    public void removeUniqueConstraint(int index) {
        this.uniqueConstraintContainer.remove(index);
        ((XmlTableGenerator)this.xmlGenerator).getUniqueConstraints().remove(index);
    }

    @Override
    public void moveUniqueConstraint(int targetIndex, int sourceIndex) {
        this.uniqueConstraintContainer.move(targetIndex, sourceIndex);
        ((XmlTableGenerator)this.xmlGenerator).getUniqueConstraints().move(targetIndex, sourceIndex);
    }

    protected OrmSpecifiedUniqueConstraint buildUniqueConstraint(XmlUniqueConstraint resourceUniqueConstraint) {
        return this.getContextModelFactory().buildOrmUniqueConstraint(this, resourceUniqueConstraint);
    }

    protected void syncUniqueConstraints(IProgressMonitor monitor) {
        this.uniqueConstraintContainer.synchronizeWithResourceModel(monitor);
    }

    protected ListIterable<XmlUniqueConstraint> getXmlUniqueConstraints() {
        return IterableTools.cloneLive(((XmlTableGenerator)this.xmlGenerator).getUniqueConstraints());
    }

    protected AbstractJpaContextModel.ContextListContainer<OrmSpecifiedUniqueConstraint, XmlUniqueConstraint> buildUniqueConstraintContainer() {
        return this.buildSpecifiedContextListContainer("uniqueConstraints", new UniqueConstraintContainerAdapter());
    }

    @Override
    public Iterable<String> getCandidateUniqueConstraintColumnNames() {
        Table dbTable = this.getDbTable();
        return dbTable != null ? dbTable.getSortedColumnIdentifiers() : EmptyIterable.instance();
    }

    @Override
    public Class<TableGenerator> getGeneratorType() {
        return TableGenerator.class;
    }

    @Override
    protected boolean isEquivalentTo_(DatabaseGenerator other) {
        return super.isEquivalentTo_(other) && this.isEquivalentTo_((TableGenerator)other);
    }

    protected boolean isEquivalentTo_(TableGenerator other) {
        return ObjectTools.equals((Object)this.specifiedTableName, (Object)other.getSpecifiedTableName()) && ObjectTools.equals((Object)this.specifiedSchema, (Object)other.getSpecifiedSchema()) && ObjectTools.equals((Object)this.specifiedCatalog, (Object)other.getSpecifiedCatalog()) && ObjectTools.equals((Object)this.specifiedPkColumnName, (Object)other.getSpecifiedPkColumnName()) && ObjectTools.equals((Object)this.specifiedValueColumnName, (Object)other.getSpecifiedValueColumnName()) && ObjectTools.equals((Object)this.specifiedPkColumnValue, (Object)other.getSpecifiedPkColumnValue()) && this.uniqueConstraintsAreEquivalentTo(other);
    }

    protected boolean uniqueConstraintsAreEquivalentTo(TableGenerator generator) {
        ArrayList uniqueConstraints1 = ListTools.arrayList(this.getUniqueConstraints());
        ArrayList uniqueConstraints2 = ListTools.arrayList(generator.getUniqueConstraints());
        if (uniqueConstraints1.size() != uniqueConstraints2.size()) {
            return false;
        }
        int i = 0;
        while (i < uniqueConstraints1.size()) {
            if (!((OrmSpecifiedUniqueConstraint)uniqueConstraints1.get(i)).isEquivalentTo((SpecifiedUniqueConstraint)uniqueConstraints2.get(i))) {
                return false;
            }
            ++i;
        }
        return true;
    }

    @Override
    public void convertFrom(JavaTableGenerator javaTableGenerator) {
        super.convertFrom(javaTableGenerator);
        this.setSpecifiedTableName(javaTableGenerator.getSpecifiedTableName());
        this.setSpecifiedSchema(javaTableGenerator.getSpecifiedSchema());
        this.setSpecifiedCatalog(javaTableGenerator.getSpecifiedCatalog());
        this.setSpecifiedPkColumnName(javaTableGenerator.getSpecifiedPkColumnName());
        this.setSpecifiedValueColumnName(javaTableGenerator.getSpecifiedValueColumnName());
        this.setSpecifiedPkColumnValue(javaTableGenerator.getSpecifiedPkColumnValue());
        for (JavaSpecifiedUniqueConstraint javaUniqueConstraint : javaTableGenerator.getUniqueConstraints()) {
            this.addUniqueConstraint().convertFrom(javaUniqueConstraint);
        }
    }

    @Override
    public Iterable<String> getCompletionProposals(int pos) {
        Iterable<String> result = super.getCompletionProposals(pos);
        if (result != null) {
            return result;
        }
        for (OrmSpecifiedUniqueConstraint constraint : this.getUniqueConstraints()) {
            result = constraint.getCompletionProposals(pos);
            if (result == null) continue;
            return result;
        }
        return null;
    }

    @Override
    protected Iterable<String> getConnectedCompletionProposals(int pos) {
        Iterable<String> result = super.getConnectedCompletionProposals(pos);
        if (result != null) {
            return result;
        }
        if (this.tableTouches(pos)) {
            return this.getCandidateTables();
        }
        if (this.pkColumnNameTouches(pos)) {
            return this.getCandidateColumnNames();
        }
        if (this.valueColumnNameTouches(pos)) {
            return this.getCandidateColumnNames();
        }
        return null;
    }

    protected boolean tableTouches(int pos) {
        return ((XmlTableGenerator)this.xmlGenerator).tableTouches(pos);
    }

    protected Iterable<String> getCandidateTables() {
        Schema dbSchema = this.getDbSchema();
        return dbSchema != null ? dbSchema.getSortedTableIdentifiers() : EmptyIterable.instance();
    }

    protected boolean pkColumnNameTouches(int pos) {
        return ((XmlTableGenerator)this.xmlGenerator).pkColumnNameTouches(pos);
    }

    protected Iterable<String> getCandidateColumnNames() {
        Table table = this.getDbTable();
        return table != null ? table.getSortedColumnIdentifiers() : EmptyIterable.instance();
    }

    protected boolean valueColumnNameTouches(int pos) {
        return ((XmlTableGenerator)this.xmlGenerator).valueColumnNameTouches(pos);
    }

    public class UniqueConstraintContainerAdapter
    extends AbstractJpaContextModel.AbstractContainerAdapter<OrmSpecifiedUniqueConstraint, XmlUniqueConstraint> {
        public UniqueConstraintContainerAdapter() {
            super(GenericOrmTableGenerator.this);
        }

        @Override
        public OrmSpecifiedUniqueConstraint buildContextElement(XmlUniqueConstraint resourceElement) {
            return GenericOrmTableGenerator.this.buildUniqueConstraint(resourceElement);
        }

        @Override
        public ListIterable<XmlUniqueConstraint> getResourceElements() {
            return GenericOrmTableGenerator.this.getXmlUniqueConstraints();
        }

        @Override
        public XmlUniqueConstraint extractResourceElement(OrmSpecifiedUniqueConstraint contextElement) {
            return contextElement.getXmlUniqueConstraint();
        }
    }
}

