/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.j2ee.internal.web.operations;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.emf.common.util.EList;
import org.eclipse.jst.j2ee.internal.web.operations.AddFilterOperation;
import org.eclipse.jst.j2ee.internal.web.operations.FilterMappingItem;
import org.eclipse.jst.j2ee.internal.web.operations.IFilterMappingItem;
import org.eclipse.jst.j2ee.internal.web.operations.NewWebClassDataModelProvider;
import org.eclipse.jst.j2ee.internal.web.operations.WebMessages;
import org.eclipse.jst.j2ee.internal.web.plugin.WebPlugin;
import org.eclipse.jst.j2ee.model.IModelProvider;
import org.eclipse.jst.j2ee.model.ModelProviderManager;
import org.eclipse.jst.j2ee.web.validation.UrlPattern;
import org.eclipse.jst.javaee.web.Filter;
import org.eclipse.jst.javaee.web.WebApp;
import org.eclipse.osgi.util.NLS;
import org.eclipse.wst.common.frameworks.datamodel.IDataModelOperation;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NewFilterClassDataModelProvider
extends NewWebClassDataModelProvider {
    private static final String[] FILTER_INTERFACES = new String[]{"javax.servlet.Filter"};
    private static final String[] JAKARTA_FILTER_INTERFACES = new String[]{"jakarta.servlet.Filter"};

    @Override
    public boolean isPropertyEnabled(String propertyName) {
        if ("NewJavaClassDataModel.ABSTRACT_METHODS".equals(propertyName)) {
            return false;
        }
        if ("NewFilterClassDataModel.INIT".equals(propertyName)) {
            return false;
        }
        if ("NewFilterClassDataModel.DESTROY".equals(propertyName)) {
            return false;
        }
        if ("NewFilterClassDataModel.DO_FILTER".equals(propertyName)) {
            return false;
        }
        return super.isPropertyEnabled(propertyName);
    }

    public IDataModelOperation getDefaultOperation() {
        return new AddFilterOperation(this.getDataModel());
    }

    @Override
    public Set getPropertyNames() {
        Set propertyNames = super.getPropertyNames();
        propertyNames.add("NewFilterClassDataModel.INIT");
        propertyNames.add("NewFilterClassDataModel.DESTROY");
        propertyNames.add("NewFilterClassDataModel.DO_FILTER");
        propertyNames.add("NewFilterClassDataModel.INIT_PARAM");
        propertyNames.add("NewFilterClassDataModel.FILTER_MAPPINGS");
        propertyNames.add("NewFilterClassDataModel.ASYNC_SUPPORT");
        return propertyNames;
    }

    @Override
    public Object getDefaultProperty(String propertyName) {
        if (propertyName.equals("NewFilterClassDataModel.DESTROY")) {
            return Boolean.TRUE;
        }
        if (propertyName.equals("NewFilterClassDataModel.DO_FILTER")) {
            return Boolean.TRUE;
        }
        if (propertyName.equals("NewFilterClassDataModel.INIT")) {
            return Boolean.TRUE;
        }
        if (propertyName.equals("NewFilterClassDataModel.FILTER_MAPPINGS")) {
            return this.getDefaultFilterMapping();
        }
        if (propertyName.equals("NewJavaClassDataModel.INTERFACES")) {
            if (this.projectUsesJakartaPackages()) {
                return this.getJakartaFilterInterfaces();
            }
            return this.getFilterInterfaces();
        }
        if (propertyName.equals("NewJavaClassDataModel.SUPERCLASS")) {
            if (this.projectUsesJakartaPackages()) {
                return "jakarta.servlet.http.HttpFilter";
            }
            return "javax.servlet.http.HttpFilter";
        }
        return super.getDefaultProperty(propertyName);
    }

    private Object getDefaultFilterMapping() {
        ArrayList<FilterMappingItem> filterMappings = null;
        String text = (String)this.getProperty("NewServletClassDataModel.DISPLAY_NAME");
        if (text != null) {
            filterMappings = new ArrayList<FilterMappingItem>();
            filterMappings.add(new FilterMappingItem(0, "/" + text));
        }
        return filterMappings;
    }

    @Override
    public IStatus validate(String propertyName) {
        if (propertyName.equals("NewJavaClassDataModel.SUPERCLASS") && "".equals(this.getStringProperty(propertyName))) {
            return WebPlugin.OK_STATUS;
        }
        if (propertyName.equals("NewFilterClassDataModel.INIT_PARAM")) {
            return this.validateInitParamList((List)this.getProperty(propertyName));
        }
        if (propertyName.equals("NewFilterClassDataModel.FILTER_MAPPINGS")) {
            return this.validateFilterMappingList((List)this.getProperty("NewFilterClassDataModel.FILTER_MAPPINGS"));
        }
        if (propertyName.equals("NewServletClassDataModel.DISPLAY_NAME")) {
            return this.validateDisplayName(this.getStringProperty(propertyName));
        }
        return super.validate(propertyName);
    }

    private IStatus validateInitParamList(List prop) {
        boolean dup;
        if (prop != null && !prop.isEmpty() && (dup = this.hasDuplicatesInStringArrayList(prop))) {
            String msg = WebMessages.ERR_DUPLICATED_INIT_PARAMETER;
            return WebPlugin.createStatus(4, msg);
        }
        return WebPlugin.OK_STATUS;
    }

    private IStatus validateFilterMappingList(List prop) {
        if (prop != null && !prop.isEmpty()) {
            boolean dup = this.hasDuplicatesInFilterMappingItemList(prop);
            if (dup) {
                String msg = WebMessages.ERR_DUPLICATED_URL_MAPPING;
                return WebPlugin.createStatus(4, msg);
            }
            String isValidValue = this.validateValue(prop);
            if (isValidValue != null && isValidValue.length() > 0) {
                NLS.bind((String)WebMessages.ERR_URL_PATTERN_INVALID, (Object)isValidValue);
                String resourceString = WebMessages.getResourceString(WebMessages.ERR_URL_PATTERN_INVALID, new String[]{isValidValue});
                return WebPlugin.createStatus(4, resourceString);
            }
        } else {
            String msg = WebMessages.ERR_FILTER_MAPPING_EMPTY;
            return WebPlugin.createStatus(4, msg);
        }
        return WebPlugin.OK_STATUS;
    }

    private boolean hasDuplicatesInFilterMappingItemList(List<IFilterMappingItem> input) {
        if (input == null) {
            return false;
        }
        int n = input.size();
        boolean dup = false;
        int i = 0;
        while (i < n) {
            IFilterMappingItem item = input.get(i);
            int j = i + 1;
            while (j < n) {
                IFilterMappingItem item2 = input.get(j);
                if (item.getName().equals(item2.getName()) && item.getMappingType() == item2.getMappingType()) {
                    dup = true;
                    break;
                }
                ++j;
            }
            if (dup) break;
            ++i;
        }
        return dup;
    }

    private String validateValue(List prop) {
        if (prop == null) {
            return "";
        }
        int size = prop.size();
        int i = 0;
        while (i < size) {
            IFilterMappingItem filterMappingValue = (IFilterMappingItem)prop.get(i);
            if (filterMappingValue.isUrlPatternType() && !UrlPattern.isValid(filterMappingValue.getName())) {
                return filterMappingValue.getName();
            }
            ++i;
        }
        return "";
    }

    private List getFilterInterfaces() {
        if (this.interfaceList == null) {
            this.interfaceList = new ArrayList(FILTER_INTERFACES.length);
            int i = 0;
            while (i < FILTER_INTERFACES.length) {
                this.interfaceList.add(FILTER_INTERFACES[i]);
                ++i;
            }
        }
        return this.interfaceList;
    }

    private List<String> getJakartaFilterInterfaces() {
        if (this.jakartaInterfaceList == null) {
            this.jakartaInterfaceList = new ArrayList(JAKARTA_FILTER_INTERFACES.length);
            int i = 0;
            while (i < JAKARTA_FILTER_INTERFACES.length) {
                this.jakartaInterfaceList.add(JAKARTA_FILTER_INTERFACES[i]);
                ++i;
            }
        }
        return this.interfaceList;
    }

    private IStatus validateDisplayName(String prop) {
        if (prop == null || prop.trim().length() == 0) {
            String msg = WebMessages.ERR_DISPLAY_NAME_EMPTY;
            return WebPlugin.createStatus(4, msg);
        }
        if (this.getTargetProject() == null || this.getTargetComponent() == null) {
            return WebPlugin.OK_STATUS;
        }
        IModelProvider provider = ModelProviderManager.getModelProvider((IProject)this.getTargetProject());
        Object mObj = provider.getModelObject();
        if (mObj instanceof org.eclipse.jst.j2ee.webapplication.WebApp) {
            org.eclipse.jst.j2ee.webapplication.WebApp webApp = (org.eclipse.jst.j2ee.webapplication.WebApp)mObj;
            EList filters = webApp.getFilters();
            boolean exists = false;
            if (filters != null && !filters.isEmpty()) {
                int i = 0;
                while (i < filters.size()) {
                    String name = ((org.eclipse.jst.j2ee.webapplication.Filter)filters.get(i)).getName();
                    if (prop.equals(name)) {
                        exists = true;
                    }
                    ++i;
                }
            }
            if (exists) {
                String msg = WebMessages.getResourceString(WebMessages.ERR_FILTER_NAME_EXIST, new String[]{prop});
                return WebPlugin.createStatus(4, msg);
            }
        } else if (mObj instanceof WebApp) {
            WebApp webApp = (WebApp)mObj;
            List filters = webApp.getFilters();
            boolean exists = false;
            if (filters != null && !filters.isEmpty()) {
                int i = 0;
                while (i < filters.size()) {
                    String name = ((Filter)filters.get(i)).getFilterName();
                    if (prop.equals(name)) {
                        exists = true;
                    }
                    ++i;
                }
            }
            if (exists) {
                String msg = WebMessages.getResourceString(WebMessages.ERR_FILTER_NAME_EXIST, new String[]{prop});
                return WebPlugin.createStatus(4, msg);
            }
        }
        return WebPlugin.OK_STATUS;
    }

    @Override
    public boolean propertySet(String propertyName, Object propertyValue) {
        if ("NewServletClassDataModel.DISPLAY_NAME".equals(propertyName) || "NewJavaClassDataModel.CLASS_NAME".equals(propertyName)) {
            this.model.notifyPropertyChange("NewFilterClassDataModel.FILTER_MAPPINGS", 2);
        }
        return super.propertySet(propertyName, propertyValue);
    }
}

