/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buildship.core.internal.workspace;

import com.google.common.base.Optional;
import com.google.common.collect.Lists;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.buildship.core.internal.CorePlugin;
import org.eclipse.buildship.core.internal.GradlePluginsRuntimeException;
import org.eclipse.buildship.core.internal.launch.GradleClasspathProvider;
import org.eclipse.buildship.core.internal.launch.LaunchConfigurationScope;
import org.eclipse.buildship.core.internal.preferences.PersistentModel;
import org.eclipse.buildship.core.internal.util.eclipse.PlatformUtils;
import org.eclipse.buildship.core.internal.workspace.GradleClasspathContainer;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.jdt.core.IClasspathAttribute;
import org.eclipse.jdt.core.IClasspathContainer;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.launching.IRuntimeClasspathEntry;
import org.eclipse.jdt.launching.IRuntimeClasspathEntryResolver;
import org.eclipse.jdt.launching.IVMInstall;
import org.eclipse.jdt.launching.JavaRuntime;

public final class GradleClasspathContainerRuntimeClasspathEntryResolver
implements IRuntimeClasspathEntryResolver {
    public IRuntimeClasspathEntry[] resolveRuntimeClasspathEntry(IRuntimeClasspathEntry entry, ILaunchConfiguration configuration) throws CoreException {
        if (entry == null || entry.getJavaProject() == null) {
            return new IRuntimeClasspathEntry[0];
        }
        LaunchConfigurationScope configurationScopes = LaunchConfigurationScope.from(configuration);
        boolean excludeTestCode = configuration.getAttribute("org.eclipse.jdt.launching.ATTR_EXCLUDE_TEST_CODE", false);
        return this.resolveRuntimeClasspathEntry(entry, entry.getJavaProject(), configurationScopes, excludeTestCode, GradleClasspathContainerRuntimeClasspathEntryResolver.hasModuleSupport());
    }

    public IRuntimeClasspathEntry[] resolveRuntimeClasspathEntry(IRuntimeClasspathEntry entry, IJavaProject project) throws CoreException {
        return this.resolveRuntimeClasspathEntry(entry, project, LaunchConfigurationScope.INCLUDE_ALL, false, GradleClasspathContainerRuntimeClasspathEntryResolver.hasModuleSupport());
    }

    public IRuntimeClasspathEntry[] resolveRuntimeClasspathEntry(IRuntimeClasspathEntry entry, IJavaProject project, boolean excludeTestCode) throws CoreException {
        return this.resolveRuntimeClasspathEntry(entry, project, LaunchConfigurationScope.INCLUDE_ALL, excludeTestCode, GradleClasspathContainerRuntimeClasspathEntryResolver.hasModuleSupport());
    }

    private static boolean hasModuleSupport() {
        return CorePlugin.configurationManager().loadWorkspaceConfiguration().isExperimentalModuleSupportEnabled();
    }

    private IRuntimeClasspathEntry[] resolveRuntimeClasspathEntry(IRuntimeClasspathEntry entry, IJavaProject project, LaunchConfigurationScope configurationScopes, boolean excludeTestCode, boolean moduleSupport) throws CoreException {
        if (entry.getType() != 4 || !entry.getPath().equals((Object)GradleClasspathContainer.CONTAINER_PATH)) {
            return new IRuntimeClasspathEntry[0];
        }
        PersistentModel model = CorePlugin.modelPersistence().loadModel(project.getProject());
        if (!model.isPresent()) {
            throw new GradlePluginsRuntimeException("Model not available for " + project.getProject().getName());
        }
        IRuntimeClasspathEntry[] result = model.getGradleVersion().supportsTestAttributes() && PlatformUtils.supportsTestAttributes() ? this.runtimeClasspathWithTestSources(project, excludeTestCode, moduleSupport) : this.runtimeClasspathWithGradleScopes(project, configurationScopes, excludeTestCode, moduleSupport);
        return (IRuntimeClasspathEntry[])Arrays.stream(result).distinct().toArray(IRuntimeClasspathEntry[]::new);
    }

    private IRuntimeClasspathEntry[] runtimeClasspathWithGradleScopes(IJavaProject project, LaunchConfigurationScope configurationScopes, boolean excludeTestCode, boolean modular) throws CoreException {
        ArrayList result = Lists.newArrayList();
        this.collectContainerRuntimeClasspathWithGradleScopes(project, (List<IRuntimeClasspathEntry>)result, false, modular, configurationScopes);
        return result.toArray(new IRuntimeClasspathEntry[result.size()]);
    }

    private void collectContainerRuntimeClasspathWithGradleScopes(IJavaProject project, List<IRuntimeClasspathEntry> result, boolean includeExportedEntriesOnly, boolean modular, LaunchConfigurationScope configurationScopes) throws CoreException {
        IClasspathContainer container = JavaCore.getClasspathContainer((IPath)GradleClasspathContainer.CONTAINER_PATH, (IJavaProject)project);
        if (container != null) {
            this.collectContainerRuntimeClasspathWithGradleScopes(container, result, includeExportedEntriesOnly, configurationScopes, modular);
        }
    }

    private void collectContainerRuntimeClasspathWithGradleScopes(IClasspathContainer container, List<IRuntimeClasspathEntry> result, boolean includeExportedEntriesOnly, LaunchConfigurationScope configurationScopes, boolean modular) throws CoreException {
        for (IClasspathEntry cpe : container.getClasspathEntries()) {
            Optional<IProject> candidate;
            if (includeExportedEntriesOnly && !cpe.isExported()) continue;
            if (cpe.getEntryKind() == 1 && configurationScopes.isEntryIncluded(cpe)) {
                this.addLibraryClasspathEntry(result, cpe, modular);
                continue;
            }
            if (cpe.getEntryKind() != 2 || !(candidate = GradleClasspathContainerRuntimeClasspathEntryResolver.findAccessibleJavaProject(cpe.getPath().segment(0))).isPresent()) continue;
            IJavaProject dependencyProject = JavaCore.create((IProject)((IProject)candidate.get()));
            IRuntimeClasspathEntry projectRuntimeEntry = JavaRuntime.newProjectRuntimeClasspathEntry((IJavaProject)dependencyProject);
            result.add(projectRuntimeEntry);
            Collections.addAll(result, GradleClasspathProvider.resolveOutputLocations(projectRuntimeEntry, dependencyProject, configurationScopes));
            this.collectContainerRuntimeClasspathWithGradleScopes(dependencyProject, result, true, modular, configurationScopes);
        }
    }

    private IRuntimeClasspathEntry[] runtimeClasspathWithTestSources(IJavaProject project, boolean excludeTestCode, boolean moduleSuppport) throws CoreException {
        ArrayList result = Lists.newArrayList();
        IClasspathContainer container = JavaCore.getClasspathContainer((IPath)GradleClasspathContainer.CONTAINER_PATH, (IJavaProject)project);
        if (container == null) {
            return new IRuntimeClasspathEntry[0];
        }
        for (IClasspathEntry cpe : container.getClasspathEntries()) {
            Optional<IProject> candidate;
            if (!(cpe.getEntryKind() != 1 || excludeTestCode && this.hasTestAttribute(cpe))) {
                this.addLibraryClasspathEntry(result, cpe, moduleSuppport);
                continue;
            }
            if (cpe.getEntryKind() != 2 || !(candidate = GradleClasspathContainerRuntimeClasspathEntryResolver.findAccessibleJavaProject(cpe.getPath().segment(0))).isPresent()) continue;
            IJavaProject dependencyProject = JavaCore.create((IProject)((IProject)candidate.get()));
            IRuntimeClasspathEntry projectRuntimeEntry = JavaRuntime.newProjectRuntimeClasspathEntry((IJavaProject)dependencyProject);
            result.add(projectRuntimeEntry);
            Collections.addAll(result, GradleClasspathContainerRuntimeClasspathEntryResolver.invokeJavaRuntimeResolveRuntimeClasspathEntry(projectRuntimeEntry, dependencyProject, excludeTestCode || GradleClasspathContainerRuntimeClasspathEntryResolver.isTestCodeExcluded(cpe)));
        }
        return result.toArray(new IRuntimeClasspathEntry[result.size()]);
    }

    private void addLibraryClasspathEntry(List<IRuntimeClasspathEntry> result, IClasspathEntry cpe, boolean moduleSupport) {
        if (moduleSupport) {
            try {
                Method m = JavaRuntime.class.getMethod("newArchiveRuntimeClasspathEntry", IPath.class, Integer.TYPE);
                int modulePathAttribute = IRuntimeClasspathEntry.class.getField("MODULE_PATH").getInt(null);
                int classPathAttribute = IRuntimeClasspathEntry.class.getField("CLASS_PATH").getInt(null);
                result.add((IRuntimeClasspathEntry)m.invoke(null, cpe.getPath(), this.hasModuleAttribute(cpe) ? modulePathAttribute : classPathAttribute));
            }
            catch (Exception e) {
                result.add(JavaRuntime.newArchiveRuntimeClasspathEntry((IPath)cpe.getPath()));
            }
        } else {
            result.add(JavaRuntime.newArchiveRuntimeClasspathEntry((IPath)cpe.getPath()));
        }
    }

    private static IRuntimeClasspathEntry[] invokeJavaRuntimeResolveRuntimeClasspathEntry(IRuntimeClasspathEntry projectRuntimeEntry, IJavaProject dependencyProject, boolean excludeTestCode) throws CoreException {
        try {
            Method method = JavaRuntime.class.getMethod("resolveRuntimeClasspathEntry", IRuntimeClasspathEntry.class, IJavaProject.class, Boolean.TYPE);
            return (IRuntimeClasspathEntry[])method.invoke(null, projectRuntimeEntry, dependencyProject, excludeTestCode);
        }
        catch (Exception e) {
            throw new GradlePluginsRuntimeException("JavaRuntime.resolveRuntimeClasspathEntry() should not be called when Buildship is installed for Eclipse 4.8", e);
        }
    }

    private boolean hasModuleAttribute(IClasspathEntry entry) {
        return GradleClasspathContainerRuntimeClasspathEntryResolver.hasEnabledBooleanAttribute("module", entry);
    }

    private boolean hasTestAttribute(IClasspathEntry entry) {
        return GradleClasspathContainerRuntimeClasspathEntryResolver.hasEnabledBooleanAttribute("test", entry);
    }

    private static boolean isTestCodeExcluded(IClasspathEntry entry) {
        return GradleClasspathContainerRuntimeClasspathEntryResolver.hasEnabledBooleanAttribute("without_test_code", entry);
    }

    private static boolean hasEnabledBooleanAttribute(String key, IClasspathEntry entry) {
        for (IClasspathAttribute attribute : entry.getExtraAttributes()) {
            if (!key.equals(attribute.getName()) || !Boolean.parseBoolean(attribute.getValue())) continue;
            return true;
        }
        return false;
    }

    private static Optional<IProject> findAccessibleJavaProject(String name) {
        IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(name);
        if (project != null && project.isAccessible() && GradleClasspathContainerRuntimeClasspathEntryResolver.hasJavaNature(project)) {
            return Optional.of((Object)project);
        }
        return Optional.absent();
    }

    private static boolean hasJavaNature(IProject project) {
        try {
            return project.hasNature("org.eclipse.jdt.core.javanature");
        }
        catch (CoreException e) {
            return false;
        }
    }

    public IVMInstall resolveVMInstall(IClasspathEntry entry) throws CoreException {
        return null;
    }
}

