/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.web.core.javascript.search;

import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.resources.IResourceProxy;
import org.eclipse.core.resources.IResourceProxyVisitor;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Platform;
import org.eclipse.wst.jsdt.core.search.IJavaScriptSearchScope;
import org.eclipse.wst.jsdt.core.search.SearchPattern;
import org.eclipse.wst.jsdt.web.core.internal.validation.Util;
import org.eclipse.wst.jsdt.web.core.javascript.search.JsSearchSupport;

public class JsPathIndexer {
    static final boolean DEBUG;

    static {
        String value = Platform.getDebugOption((String)"org.eclipse.wst.jsdt.web.core/debug/jssearch");
        DEBUG = value != null && value.equalsIgnoreCase("true");
    }

    public IPath[] getVisibleJspPaths(SearchPattern pattern, IJavaScriptSearchScope scope) {
        JSPFileVisitor jspFileVisitor = new JSPFileVisitor(pattern, scope);
        try {
            ResourcesPlugin.getWorkspace().getRoot().accept((IResourceProxyVisitor)jspFileVisitor, 0);
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
        return jspFileVisitor.getPaths();
    }

    class JSPFileVisitor
    implements IResourceProxyVisitor {
        private Set<IPath> fPaths = new HashSet<IPath>();
        IJavaScriptSearchScope fScope = null;
        SearchPattern fPattern = null;

        public JSPFileVisitor(SearchPattern pattern, IJavaScriptSearchScope scope) {
            this.fPattern = pattern;
            this.fScope = scope;
        }

        public boolean visit(IResourceProxy proxy) throws CoreException {
            if (JsSearchSupport.getInstance().isCanceled() || proxy.isDerived()) {
                return false;
            }
            if (proxy.getType() == 1) {
                if (Util.isJsType(proxy.getName()) && this.fScope.encloses(proxy.requestFullPath().toString())) {
                    IPath folderPath = proxy.requestFullPath().removeLastSegments(1);
                    if (DEBUG) {
                        System.out.println("adding selected index path:" + folderPath);
                    }
                    this.fPaths.add(JsSearchSupport.getInstance().computeIndexLocation(folderPath));
                }
                return false;
            }
            return true;
        }

        public IPath[] getPaths() {
            return this.fPaths.toArray(new IPath[this.fPaths.size()]);
        }
    }
}

