/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.web.core.javascript.search;

import java.io.File;
import java.util.zip.CRC32;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.wst.jsdt.core.IJavaScriptElement;
import org.eclipse.wst.jsdt.core.search.IJavaScriptSearchConstants;
import org.eclipse.wst.jsdt.core.search.IJavaScriptSearchScope;
import org.eclipse.wst.jsdt.core.search.SearchDocument;
import org.eclipse.wst.jsdt.core.search.SearchEngine;
import org.eclipse.wst.jsdt.core.search.SearchParticipant;
import org.eclipse.wst.jsdt.core.search.SearchPattern;
import org.eclipse.wst.jsdt.core.search.SearchRequestor;
import org.eclipse.wst.jsdt.internal.core.JavaModelManager;
import org.eclipse.wst.jsdt.web.core.internal.JsCoreMessages;
import org.eclipse.wst.jsdt.web.core.internal.JsCorePlugin;
import org.eclipse.wst.jsdt.web.core.internal.Logger;
import org.eclipse.wst.jsdt.web.core.internal.validation.Util;
import org.eclipse.wst.jsdt.web.core.javascript.JsNameManglerUtil;
import org.eclipse.wst.jsdt.web.core.javascript.search.JSDTSearchDocumentDelegate;
import org.eclipse.wst.jsdt.web.core.javascript.search.JsIndexManager;
import org.eclipse.wst.jsdt.web.core.javascript.search.JsSearchDocument;
import org.eclipse.wst.jsdt.web.core.javascript.search.JsSearchParticipant;

public class JsSearchSupport {
    static final boolean DEBUG;
    private static JsSearchSupport singleton;
    private JsSearchParticipant fParticipant = null;
    private IPath fJsPluginLocation = null;
    private final CRC32 fChecksumCalculator = new CRC32();
    private final IProgressMonitor fMonitor = new NullProgressMonitor();

    static {
        String value = Platform.getDebugOption((String)"org.eclipse.wst.jsdt.web.core/debug/jssearch");
        DEBUG = value != null && value.equalsIgnoreCase("true");
        singleton = null;
    }

    private JsSearchSupport() {
    }

    public static synchronized JsSearchSupport getInstance() {
        if (singleton == null) {
            singleton = new JsSearchSupport();
        }
        return singleton;
    }

    public static boolean isJsp(IFile file) {
        return Util.isJsType(file.getName());
    }

    public SearchDocument addJspFile(IFile file) {
        SearchDocument delegate;
        block6: {
            if (JsSearchSupport.getInstance().isCanceled() || !file.isAccessible()) {
                return null;
            }
            if (DEBUG) {
                System.out.println("adding web page file:" + file.getFullPath());
            }
            if ((delegate = this.createSearchDocument(file)) != null) {
                try {
                    this.getSearchParticipant().scheduleDocumentIndexing(delegate, this.computeIndexLocation(file.getParent().getFullPath()));
                }
                catch (Exception e) {
                    if (!DEBUG) break block6;
                    e.printStackTrace();
                }
            }
        }
        if (DEBUG) {
            System.out.println("scheduled" + delegate + "for indexing");
        }
        return delegate;
    }

    public void search(String searchText, IJavaScriptSearchScope scope, int searchFor, int limitTo, int matchMode, boolean isCaseSensitive, SearchRequestor requestor) {
        JsIndexManager.getInstance().rebuildIndexIfNeeded();
        SearchJob job = new SearchJob(searchText, scope, searchFor, limitTo, matchMode, isCaseSensitive, requestor);
        this.setCanceled(false);
        job.setUser(true);
        job.schedule();
    }

    public void search(IJavaScriptElement element, IJavaScriptSearchScope scope, SearchRequestor requestor) {
        JsIndexManager.getInstance().rebuildIndexIfNeeded();
        SearchJob job = new SearchJob(element, scope, requestor);
        this.setCanceled(false);
        job.setUser(true);
        job.schedule();
    }

    public void searchRunnable(IJavaScriptElement element, IJavaScriptSearchScope scope, SearchRequestor requestor) {
        JsIndexManager.getInstance().rebuildIndexIfNeeded();
        SearchRunnable searchRunnable = new SearchRunnable(element, scope, requestor);
        try {
            this.setCanceled(false);
            ResourcesPlugin.getWorkspace().run((IWorkspaceRunnable)searchRunnable, JsSearchSupport.getInstance().getProgressMonitor());
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
    }

    private SearchDocument createSearchDocument(IFile jsFile) {
        JSDTSearchDocumentDelegate delegate = null;
        if (jsFile != null && jsFile.exists() && JsSearchSupport.isJsp(jsFile)) {
            delegate = new JSDTSearchDocumentDelegate(new JsSearchDocument(jsFile.getFullPath().toString(), this.getSearchParticipant()));
        }
        return delegate;
    }

    public SearchDocument getSearchDocument(String searchDocPath) {
        SearchDocument delegate = null;
        IFile f = this.fileForCUPath(searchDocPath);
        if (f != null) {
            delegate = this.createSearchDocument(f);
        }
        return delegate;
    }

    private IFile fileForCUPath(String searchDocPath) {
        Path path;
        String[] split = searchDocPath.split("/");
        String classname = split[split.length - 1];
        if (!searchDocPath.endsWith(".js")) {
            return null;
        }
        String filePath = JsNameManglerUtil.unmangle(classname);
        IFile f = ResourcesPlugin.getWorkspace().getRoot().getFileForLocation((IPath)new Path(filePath));
        if (f == null && (path = new Path(filePath)).segmentCount() >= 2) {
            f = ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)path);
        }
        return f;
    }

    JsSearchParticipant getSearchParticipant() {
        if (this.fParticipant == null) {
            this.fParticipant = new JsSearchParticipant();
        }
        return this.fParticipant;
    }

    public final IPath computeIndexLocation(IPath containerPath) {
        IPath indexLocation = null;
        String pathString = containerPath.toOSString();
        this.fChecksumCalculator.reset();
        this.fChecksumCalculator.update(pathString.getBytes());
        String fileName = String.valueOf(Long.toString(this.fChecksumCalculator.getValue())) + ".index";
        indexLocation = this.getModelJspPluginWorkingLocation().append(fileName);
        JavaModelManager.getJavaModelManager().getIndexManager().indexLocations.put((Object)containerPath, (Object)indexLocation);
        return indexLocation;
    }

    public IPath getModelJspPluginWorkingLocation(IProject project) {
        IPath workingLocationFile;
        File folder;
        if (project == null) {
            System.out.println("Null project");
        }
        if (!(folder = new File((workingLocationFile = project.getWorkingLocation("org.eclipse.wst.jsdt.web.core").append("jssearch")).toOSString())).isDirectory()) {
            try {
                folder.mkdir();
            }
            catch (SecurityException securityException) {}
        }
        return workingLocationFile;
    }

    public IPath getModelJspPluginWorkingLocation() {
        File folder;
        if (this.fJsPluginLocation != null) {
            return this.fJsPluginLocation;
        }
        IPath stateLocation = JsCorePlugin.getDefault().getStateLocation().addTrailingSeparator().append("jssearch");
        String device = stateLocation.getDevice();
        if (device != null && device.charAt(0) == '/') {
            stateLocation = stateLocation.setDevice(device.substring(1));
        }
        if (!(folder = new File(stateLocation.toOSString())).isDirectory()) {
            try {
                folder.mkdir();
            }
            catch (SecurityException securityException) {}
        }
        this.fJsPluginLocation = stateLocation;
        return this.fJsPluginLocation;
    }

    public final synchronized void setCanceled(boolean cancel) {
        this.fMonitor.setCanceled(cancel);
    }

    public final synchronized boolean isCanceled() {
        return this.fMonitor.isCanceled();
    }

    public final IProgressMonitor getProgressMonitor() {
        return this.fMonitor;
    }

    private class SearchJob
    extends Job
    implements IJavaScriptSearchConstants {
        String fSearchText;
        IJavaScriptSearchScope fScope;
        int fSearchFor;
        int fLimitTo;
        int fMatchMode;
        SearchRequestor fRequestor;
        IJavaScriptElement fElement;

        public SearchJob(IJavaScriptElement element, IJavaScriptSearchScope scope, SearchRequestor requestor) {
            super(String.valueOf(JsCoreMessages.JSP_Search) + element.getElementName());
            this.fSearchText = "";
            this.fScope = null;
            this.fSearchFor = 4;
            this.fLimitTo = 3;
            this.fMatchMode = 2;
            this.fRequestor = null;
            this.fElement = null;
            this.fElement = element;
            this.fScope = scope;
            this.fRequestor = requestor;
        }

        public SearchJob(String searchText, IJavaScriptSearchScope scope, int searchFor, int limitTo, int matchMode, boolean isCaseSensitive, SearchRequestor requestor) {
            super(String.valueOf(JsCoreMessages.JSP_Search) + searchText);
            this.fSearchText = "";
            this.fScope = null;
            this.fSearchFor = 4;
            this.fLimitTo = 3;
            this.fMatchMode = 2;
            this.fRequestor = null;
            this.fElement = null;
            this.fSearchText = searchText;
            this.fScope = scope;
            this.fSearchFor = searchFor;
            this.fLimitTo = limitTo;
            this.fMatchMode = matchMode;
            this.fRequestor = requestor;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public IStatus run(IProgressMonitor jobMonitor) {
            if (jobMonitor != null && jobMonitor.isCanceled()) {
                return Status.CANCEL_STATUS;
            }
            if (JsSearchSupport.getInstance().isCanceled()) {
                return Status.CANCEL_STATUS;
            }
            SearchPattern javaSearchPattern = null;
            javaSearchPattern = this.fElement != null ? SearchPattern.createPattern((IJavaScriptElement)this.fElement, (int)this.fLimitTo) : SearchPattern.createPattern((String)this.fSearchText, (int)this.fSearchFor, (int)this.fLimitTo, (int)this.fMatchMode);
            if (javaSearchPattern == null) return Status.OK_STATUS;
            SearchParticipant[] participants = new JsSearchParticipant[]{JsSearchSupport.this.getSearchParticipant()};
            SearchEngine engine = new SearchEngine();
            try {
                try {
                    if (jobMonitor != null) {
                        jobMonitor.beginTask("", -1);
                    }
                    engine.search(javaSearchPattern, participants, this.fScope, this.fRequestor, jobMonitor);
                    return Status.OK_STATUS;
                }
                catch (CoreException e) {
                    if (DEBUG) {
                        Logger.logException(e);
                    }
                    if (jobMonitor == null) return Status.OK_STATUS;
                    jobMonitor.done();
                    return Status.OK_STATUS;
                }
                catch (Exception e) {
                    if (DEBUG) {
                        Logger.logException(e);
                    }
                    if (jobMonitor == null) return Status.OK_STATUS;
                    jobMonitor.done();
                    return Status.OK_STATUS;
                }
            }
            finally {
                if (jobMonitor != null) {
                    jobMonitor.done();
                }
            }
        }
    }

    private class SearchRunnable
    implements IWorkspaceRunnable,
    IJavaScriptSearchConstants {
        String fSearchText = "";
        IJavaScriptSearchScope fScope = null;
        int fSearchFor = 4;
        int fLimitTo = 3;
        int fMatchMode = 2;
        SearchRequestor fRequestor = null;
        IJavaScriptElement fElement = null;

        public SearchRunnable(IJavaScriptElement element, IJavaScriptSearchScope scope, SearchRequestor requestor) {
            this.fElement = element;
            this.fScope = scope;
            this.fRequestor = requestor;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public void run(IProgressMonitor monitor) throws CoreException {
            if (monitor != null && monitor.isCanceled()) {
                return;
            }
            if (JsSearchSupport.getInstance().isCanceled()) {
                return;
            }
            SearchPattern javaSearchPattern = null;
            javaSearchPattern = this.fElement != null ? SearchPattern.createPattern((IJavaScriptElement)this.fElement, (int)this.fLimitTo) : SearchPattern.createPattern((String)this.fSearchText, (int)this.fSearchFor, (int)this.fLimitTo, (int)this.fMatchMode);
            if (javaSearchPattern == null) return;
            SearchParticipant[] participants = new JsSearchParticipant[]{JsSearchSupport.this.getSearchParticipant()};
            SearchEngine engine = new SearchEngine();
            try {
                try {
                    if (monitor != null) {
                        monitor.beginTask("", 0);
                    }
                    engine.search(javaSearchPattern, participants, this.fScope, this.fRequestor, monitor);
                    return;
                }
                catch (CoreException e) {
                    Logger.logException(e);
                    if (monitor == null) return;
                    monitor.done();
                    return;
                }
                catch (Exception e) {
                    Logger.logException(e);
                    if (monitor == null) return;
                    monitor.done();
                    return;
                }
            }
            finally {
                if (monitor != null) {
                    monitor.done();
                }
            }
        }
    }
}

