/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lsp4e.operations.codeactions;

import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResource;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jface.text.IDocument;
import org.eclipse.lsp4e.LSPEclipseUtils;
import org.eclipse.lsp4e.command.CommandExecutor;
import org.eclipse.lsp4j.Command;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.IMarkerResolution;
import org.eclipse.ui.views.markers.WorkbenchMarkerResolution;

public class CommandMarkerResolution
extends WorkbenchMarkerResolution
implements IMarkerResolution {
    private final @NonNull Command command;

    public CommandMarkerResolution(@NonNull Command command) {
        this.command = command;
    }

    public String getLabel() {
        return this.command.getTitle();
    }

    public void run(IMarker marker) {
        IResource resource = marker.getResource();
        IDocument document = LSPEclipseUtils.getDocument(resource);
        String languageServerId = marker.getAttribute("languageServerId", null);
        if (document != null) {
            CommandExecutor.executeCommand(this.command, document, languageServerId);
        }
    }

    public String getDescription() {
        return this.command.getTitle();
    }

    public Image getImage() {
        return null;
    }

    public IMarker[] findOtherMarkers(IMarker[] markers) {
        return new IMarker[0];
    }
}

