/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.server.ui.internal.wizard.page;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.help.IWorkbenchHelpSystem;
import org.eclipse.wst.server.core.IRuntime;
import org.eclipse.wst.server.core.IRuntimeType;
import org.eclipse.wst.server.core.IRuntimeWorkingCopy;
import org.eclipse.wst.server.core.IServerType;
import org.eclipse.wst.server.core.IServerWorkingCopy;
import org.eclipse.wst.server.core.ServerCore;
import org.eclipse.wst.server.core.TaskModel;
import org.eclipse.wst.server.core.internal.Runtime;
import org.eclipse.wst.server.core.internal.RuntimeProxy;
import org.eclipse.wst.server.core.internal.RuntimeTypeProxy;
import org.eclipse.wst.server.core.internal.RuntimeTypeWithServerProxy;
import org.eclipse.wst.server.core.internal.RuntimeWorkingCopy;
import org.eclipse.wst.server.core.internal.ServerTypeProxy;
import org.eclipse.wst.server.discovery.Discovery;
import org.eclipse.wst.server.discovery.ErrorMessage;
import org.eclipse.wst.server.ui.internal.ImageResource;
import org.eclipse.wst.server.ui.internal.Messages;
import org.eclipse.wst.server.ui.internal.SWTUtil;
import org.eclipse.wst.server.ui.internal.ServerUIPlugin;
import org.eclipse.wst.server.ui.internal.Trace;
import org.eclipse.wst.server.ui.internal.viewers.RuntimeTypeComposite;
import org.eclipse.wst.server.ui.wizard.IWizardHandle;
import org.eclipse.wst.server.ui.wizard.WizardFragment;

public class NewRuntimeComposite
extends Composite {
    protected Tree tree;
    protected TreeViewer treeViewer;
    protected Button createServer;
    protected IRuntimeWorkingCopy runtime;
    protected Map<IRuntimeType, IRuntimeWorkingCopy> cache = new HashMap<IRuntimeType, IRuntimeWorkingCopy>();
    protected Map<IRuntime, IServerWorkingCopy> serverCache = new HashMap<IRuntime, IServerWorkingCopy>();
    protected TaskModel taskModel;
    protected IWizardHandle wizard;
    protected String type;
    protected String version;
    protected String runtimeTypeId;
    protected IServerType serverType;
    boolean success;

    public NewRuntimeComposite(Composite parent, IWizardHandle wizard, TaskModel tm, String type, String version, String runtimeTypeId) {
        super(parent, 0);
        this.wizard = wizard;
        this.taskModel = tm;
        this.type = type;
        this.version = version;
        this.runtimeTypeId = runtimeTypeId;
        this.createControl();
        wizard.setTitle(Messages.wizNewRuntimeTitle);
        wizard.setDescription(Messages.wizNewRuntimeDescription);
        wizard.setImageDescriptor(ImageResource.getImageDescriptor("newServerWiz"));
    }

    public void createControl() {
        GridLayout layout = new GridLayout();
        layout.horizontalSpacing = SWTUtil.convertHorizontalDLUsToPixels(this, 4);
        layout.verticalSpacing = SWTUtil.convertVerticalDLUsToPixels(this, 4);
        this.setLayout((Layout)layout);
        IWorkbenchHelpSystem whs = PlatformUI.getWorkbench().getHelpSystem();
        whs.setHelp((Control)this, "org.eclipse.wst.server.ui.swnr0000");
        RuntimeTypeComposite comp = new RuntimeTypeComposite(this, true, new RuntimeTypeComposite.RuntimeTypeSelectionListener(){

            @Override
            public void runtimeTypeSelected(IRuntimeType runtimeType) {
                NewRuntimeComposite.this.handleSelection(runtimeType);
            }
        }, this.type, this.version, this.runtimeTypeId);
        GridData data = new GridData(1808);
        data.heightHint = 300;
        comp.setLayoutData(data);
        this.createServer = new Button((Composite)this, 32);
        this.createServer.setText(Messages.wizNewRuntimeCreateServer);
        this.createServer.setSelection(ServerUIPlugin.getPreferences().getCreateServerWithRuntime());
        this.createServer.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                NewRuntimeComposite.this.handleServer();
                ServerUIPlugin.getPreferences().setCreateServerWithRuntime(NewRuntimeComposite.this.createServer.getSelection());
            }
        });
    }

    protected void handleSelection(IRuntimeType runtimeType) {
        this.wizard.setMessage(null, 0);
        if (runtimeType == null) {
            this.runtime = null;
        } else {
            if (runtimeType instanceof RuntimeTypeWithServerProxy) {
                this.success = false;
                final RuntimeTypeWithServerProxy runtimeTypeFinal = (RuntimeTypeWithServerProxy)runtimeType;
                try {
                    this.wizard.run(true, true, new IRunnableWithProgress(){

                        public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                            NewRuntimeComposite.this.success = NewRuntimeComposite.this.showDownloadableServerWizard(runtimeTypeFinal, monitor);
                        }
                    });
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
                catch (InvocationTargetException e) {
                    e.printStackTrace();
                }
                if (!this.success) {
                    return;
                }
                this.wizard.update();
            }
            try {
                this.runtime = null;
                this.runtime = this.cache.get(runtimeType);
            }
            catch (Exception exception) {}
            if (this.runtime == null) {
                try {
                    this.runtime = runtimeType.createRuntime(null, null);
                    if (this.runtime != null) {
                        this.cache.put(runtimeType, this.runtime);
                    } else if (runtimeType instanceof RuntimeTypeWithServerProxy) {
                        this.serverType = ((RuntimeTypeWithServerProxy)runtimeType).getServerTypeProxy();
                        this.runtime = new RuntimeWorkingCopy((Runtime)new RuntimeProxy((RuntimeTypeProxy)this.serverType.getRuntimeType()));
                    }
                }
                catch (Exception exception) {}
            }
        }
        if (!(runtimeType instanceof RuntimeTypeWithServerProxy)) {
            this.serverType = NewRuntimeComposite.getCompatibleServerType(runtimeType);
        }
        this.handleServer();
    }

    protected boolean showDownloadableServerWizard(RuntimeTypeWithServerProxy runtimeType, IProgressMonitor monitor) {
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                NewRuntimeComposite.this.wizard.setMessage(Messages.downLoadableAdapterDescription, 1);
            }
        });
        this.serverType = runtimeType.getServerTypeProxy();
        WizardFragment fragment2 = ServerUIPlugin.getWizardFragment(this.serverType.getRuntimeType().getId());
        if (fragment2 == null) {
            return false;
        }
        TaskModel fragmentTaskModel = fragment2.getTaskModel();
        if (fragmentTaskModel == null) {
            fragmentTaskModel = new TaskModel();
        }
        fragmentTaskModel.putObject("extension", (Object)runtimeType.getServerTypeProxy().getExtension());
        fragmentTaskModel.putObject("runtime", (Object)this.serverType.getRuntimeType());
        fragmentTaskModel.putObject("server", (Object)this.serverType);
        fragment2.setTaskModel(fragmentTaskModel);
        return true;
    }

    protected void handleServer() {
        boolean option = false;
        if (this.serverType != null && this.serverType.hasRuntime()) {
            option = true;
        }
        this.createServer.setVisible(option);
        if (option && this.createServer.getSelection()) {
            IServerWorkingCopy server = this.getServer();
            this.taskModel.putObject("server", (Object)server);
        } else if (!(this.serverType instanceof ServerTypeProxy)) {
            this.taskModel.putObject("server", null);
        } else {
            this.taskModel.putObject("server", (Object)this.serverType);
        }
        this.taskModel.putObject("runtime", (Object)this.runtime);
        this.wizard.update();
    }

    protected static IServerType getCompatibleServerType(IRuntimeType runtimeType) {
        ArrayList<IServerType> list = new ArrayList<IServerType>();
        IServerType[] serverTypes = ServerCore.getServerTypes();
        int size = serverTypes.length;
        int i = 0;
        while (i < size) {
            IRuntimeType rt = serverTypes[i].getRuntimeType();
            if (rt != null && rt.equals(runtimeType)) {
                list.add(serverTypes[i]);
            }
            ++i;
        }
        if (list.size() == 1) {
            return (IServerType)list.get(0);
        }
        return null;
    }

    protected IServerWorkingCopy getServer() {
        block5: {
            if (this.serverType == null || this.runtime == null || !this.serverType.hasRuntime()) {
                return null;
            }
            IServerWorkingCopy server = this.serverCache.get(this.runtime);
            if (server != null) {
                return server;
            }
            try {
                server = this.serverType.createServer(null, null, (IRuntime)this.runtime, null);
                if (server != null) {
                    this.serverCache.put((IRuntime)this.runtime, server);
                    return server;
                }
            }
            catch (CoreException ce) {
                if (!Trace.SEVERE) break block5;
                Trace.trace("/severe", "Error creating server", ce);
            }
        }
        return null;
    }

    public IRuntimeWorkingCopy getRuntime() {
        return this.runtime;
    }

    public void setVisible(boolean visible) {
        super.setVisible(visible);
        Control[] c = this.getChildren();
        if (c != null) {
            int size = c.length;
            int i = 0;
            while (i < size) {
                if (c[i] != null) {
                    c[i].setVisible(visible);
                }
                ++i;
            }
        }
    }

    public boolean hasValidSelectedRuntime() {
        return this.runtime != null;
    }

    public boolean refreshExtension() {
        block5: {
            if (!(this.serverType instanceof ServerTypeProxy)) {
                return true;
            }
            final ServerTypeProxy finalServerType = (ServerTypeProxy)this.serverType;
            try {
                this.wizard.run(true, true, new IRunnableWithProgress(){

                    public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                        ErrorMessage errorMsg = Discovery.refreshExtension((String)finalServerType.getExtension(), (String)finalServerType.getURI(), (IProgressMonitor)monitor);
                        if (errorMsg != null) {
                            final ErrorMessage errorMsgFinal = errorMsg;
                            Display.getDefault().asyncExec(new Runnable(){

                                @Override
                                public void run() {
                                    (this).NewRuntimeComposite.this.wizard.setMessage(errorMsgFinal.getErrorTitle(), 3);
                                    WizardFragment fragment2 = ServerUIPlugin.getWizardFragment(finalServerType.getRuntimeType().getId());
                                    if (fragment2 != null) {
                                        TaskModel fragmentTaskModel = fragment2.getTaskModel();
                                        fragmentTaskModel.putObject("license", (Object)errorMsgFinal.getErrorDescription());
                                        fragmentTaskModel.putObject("license_error", (Object)new Integer(3));
                                    }
                                    (this).NewRuntimeComposite.this.wizard.update();
                                }
                            });
                        } else {
                            WizardFragment fragment2 = ServerUIPlugin.getWizardFragment(finalServerType.getRuntimeType().getId());
                            if (fragment2 != null) {
                                TaskModel fragmentTaskModel = fragment2.getTaskModel();
                                fragmentTaskModel.putObject("license", (Object)Discovery.getLicenseText((String)finalServerType.getExtension()));
                                fragmentTaskModel.putObject("license_error", (Object)new Integer(0));
                            }
                        }
                    }
                });
            }
            catch (InvocationTargetException e) {
                if (Trace.WARNING) {
                    Trace.trace("/warning", "Error refreshing extension", e);
                }
            }
            catch (InterruptedException e) {
                if (!Trace.WARNING) break block5;
                Trace.trace("/warning", "Error refreshing extension", e);
            }
        }
        return true;
    }
}

