/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.commons.ui;

import org.eclipse.jface.resource.CompositeImageDescriptor;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.mylyn.commons.ui.CommonImages;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.Point;

public class CompositeSyncImageDescriptor
extends CompositeImageDescriptor {
    private final ImageData base;
    private final ImageData background;
    private final boolean fillBackground;
    protected Point size;
    static int WIDTH;

    public CompositeSyncImageDescriptor(ImageDescriptor icon, boolean fillBackground) {
        this.base = this.getImageData(icon);
        this.background = this.getImageData(CommonImages.OVERLAY_WHITE);
        this.size = new Point(this.background.width, this.background.height);
        this.fillBackground = fillBackground;
    }

    protected void drawCompositeImage(int width, int height) {
        if (this.fillBackground) {
            this.drawImage(this.background, 0, 0);
        }
        this.drawImage(this.base, 3, 2);
    }

    private ImageData getImageData(ImageDescriptor descriptor) {
        ImageData data = descriptor.getImageData();
        if (data == null) {
            data = DEFAULT_IMAGE_DATA;
        }
        return data;
    }

    protected Point getSize() {
        return new Point(this.size.x, this.size.y);
    }
}

