/**
 * @license
 * Copyright Google LLC All Rights Reserved.
 *
 * Use of this source code is governed by an MIT-style license that can be
 * found in the LICENSE file at https://angular.io/license
 */
(function (factory) {
    if (typeof module === "object" && typeof module.exports === "object") {
        var v = factory(require, exports);
        if (v !== undefined) module.exports = v;
    }
    else if (typeof define === "function" && define.amd) {
        define("@angular/language-service/api", ["require", "exports"], factory);
    }
})(function (require, exports) {
    "use strict";
    Object.defineProperty(exports, "__esModule", { value: true });
    exports.isNgLanguageService = void 0;
    function isNgLanguageService(ls) {
        return 'getTcb' in ls;
    }
    exports.isNgLanguageService = isNgLanguageService;
});
//# sourceMappingURL=data:application/json;base64,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