import { DebugProtocol } from 'vscode-debugprotocol';
import { ILaunchRequestArgs, IAttachRequestArgs, IStackTraceResponseBody } from '../debugAdapterInterfaces';
/**
 * Converts a local path from Code to a path on the target.
 */
export declare class BasePathTransformer {
    launch(args: ILaunchRequestArgs): Promise<void>;
    attach(args: IAttachRequestArgs): Promise<void>;
    setBreakpoints(source: DebugProtocol.Source): DebugProtocol.Source;
    clearTargetContext(): void;
    scriptParsed(scriptPath: string): Promise<string>;
    breakpointResolved(bp: DebugProtocol.Breakpoint, targetPath: string): string;
    stackTraceResponse(response: IStackTraceResponseBody): void;
    fixSource(source: DebugProtocol.Source): Promise<void>;
    getTargetPathFromClientPath(clientPath: string): string;
    getClientPathFromTargetPath(targetPath: string): string;
}
