# Contributing

Want to contribute? Great! Please take the time to read this page first.

## Code of Conduct

Please note that this project tries to follow the [Contributor Covenant Code of
Conduct][1]. By participating in this project you agree to abide by its terms.

## Code review

All submissions, including submissions by project members, require review. We
use Github pull requests for this purpose.

Some tips for good pull requests:

- Write a descriptive commit message. What problem are you solving and what
  are the consequences? Where and what did you test? Some good tips:
  [here](http://robots.thoughtbot.com/5-useful-tips-for-a-better-commit-message)
  and [here](https://www.kernel.org/doc/Documentation/SubmittingPatches).
- If your PR consists of multiple commits which are successive improvements /
  fixes to your first commit, consider squashing them into a single commit
  (`git rebase -i`) such that your PR is a single commit on top of the current
  HEAD. This make reviewing the code so much easier, and our history more
  readable.
- Please make sure that your code respect the [Coding Style][2].


[1]: https://www.contributor-covenant.org
[2]: https://github.com/jeanguyomarch/eovim/wiki/Developing-Eovim#coding-style
