/*
 * Decompiled with CFR 0.152.
 */
package org.grails.taglib;

import org.grails.core.exceptions.GrailsException;
import org.grails.exceptions.reporting.SourceCodeAware;
import org.grails.io.support.GrailsResourceUtils;

public class GrailsTagException
extends GrailsException
implements SourceCodeAware {
    private static final long serialVersionUID = -2340187595590923592L;
    private String fileName;
    private int lineNumber;

    public GrailsTagException(String message) {
        super(message);
    }

    public GrailsTagException(String message, Throwable cause) {
        super(message, cause);
    }

    public GrailsTagException(Throwable cause) {
        super(cause);
    }

    public GrailsTagException(String message, String pageName, int lineNumber) {
        this(message, null, pageName, lineNumber);
    }

    public GrailsTagException(String message, Throwable cause, String fileName, int lineNumber) {
        super(message, cause);
        String path = GrailsResourceUtils.getPathFromBaseDir((String)fileName);
        this.fileName = path != null ? path : fileName;
        this.lineNumber = lineNumber;
    }

    public String getFileName() {
        return this.fileName;
    }

    public int getLineNumber() {
        return this.lineNumber;
    }

    public String getMessage() {
        String fn = this.getFileName();
        int ln = this.getLineNumber();
        if (fn != null && ln > 0) {
            return "[" + fn + ":" + ln + "] " + super.getMessage();
        }
        return super.getMessage();
    }
}

