/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.capability;

import com.google.common.base.Throwables;
import com.google.common.eventbus.Subscribe;
import java.util.Collection;
import java.util.Date;
import java.util.Map;
import javax.annotation.Nullable;
import org.sonatype.goodies.common.ComponentSupport;
import org.sonatype.nexus.capability.CapabilityReference;
import org.sonatype.nexus.capability.CapabilityReferenceFilterBuilder;
import org.sonatype.nexus.capability.CapabilityRegistry;
import org.sonatype.nexus.capability.CapabilityRegistryEvent;
import org.sonatype.nexus.capability.CapabilityType;
import org.sonatype.nexus.common.event.EventAware;

public abstract class CapabilityBooterSupport
extends ComponentSupport
implements EventAware {
    @Subscribe
    public void handle(CapabilityRegistryEvent.Ready event) {
        CapabilityRegistry registry = event.getCapabilityRegistry();
        try {
            this.boot(registry);
        }
        catch (Exception e) {
            Throwables.throwIfUnchecked((Throwable)e);
            throw new RuntimeException(e);
        }
    }

    protected abstract void boot(CapabilityRegistry var1) throws Exception;

    protected void maybeAddCapability(CapabilityRegistry capabilityRegistry, CapabilityType type, boolean enabled, @Nullable String notes, @Nullable Map<String, String> properties) throws Exception {
        CapabilityReference reference = this.findCapability(capabilityRegistry, type);
        if (reference == null) {
            this.log.debug("Automatically adding capability type: {}; enabled: {}", (Object)type, (Object)enabled);
            this.addCapability(capabilityRegistry, type, enabled, notes, properties);
        }
    }

    protected CapabilityReference findCapability(CapabilityRegistry capabilityRegistry, CapabilityType type) {
        return this.findCapability(capabilityRegistry, type, true);
    }

    protected CapabilityReference findCapability(CapabilityRegistry capabilityRegistry, CapabilityType type, boolean includeNotExposed) {
        Collection<? extends CapabilityReference> capabilities;
        CapabilityReferenceFilterBuilder.CapabilityReferenceFilter filter = CapabilityReferenceFilterBuilder.capabilities().withType(type);
        if (includeNotExposed) {
            filter.includeNotExposed();
        }
        if ((capabilities = capabilityRegistry.get(filter)) != null && !capabilities.isEmpty()) {
            return capabilities.iterator().next();
        }
        return null;
    }

    protected void addCapability(CapabilityRegistry capabilityRegistry, CapabilityType type, boolean enabled, @Nullable String notes, @Nullable Map<String, String> properties) throws Exception {
        capabilityRegistry.add(type, enabled, notes == null ? "Automatically added on " + new Date() : notes, properties);
    }
}

