/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.capability;

import com.google.common.base.Preconditions;
import java.net.URL;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Nullable;
import javax.inject.Inject;
import javax.inject.Provider;
import javax.validation.ValidationException;
import javax.validation.Validator;
import javax.validation.groups.Default;
import org.slf4j.Logger;
import org.sonatype.goodies.common.ComponentSupport;
import org.sonatype.nexus.capability.CapabilityDescriptor;
import org.sonatype.nexus.capability.CapabilityIdentity;
import org.sonatype.nexus.capability.CapabilityReference;
import org.sonatype.nexus.capability.CapabilityReferenceFilterBuilder;
import org.sonatype.nexus.capability.CapabilityRegistry;
import org.sonatype.nexus.common.template.TemplateHelper;
import org.sonatype.nexus.common.template.TemplateParameters;
import org.sonatype.nexus.formfields.FormField;
import org.sonatype.nexus.validation.ConstraintViolations;
import org.sonatype.nexus.validation.group.Create;
import org.sonatype.nexus.validation.group.Update;

public abstract class CapabilityDescriptorSupport<ConfigT>
extends ComponentSupport
implements CapabilityDescriptor {
    private Provider<CapabilityRegistry> capabilityRegistry;
    private boolean exposed = true;
    private boolean hidden = false;
    private Provider<Validator> validatorProvider;
    private TemplateHelper templateHelper;

    @Inject
    public void installComponents(Provider<CapabilityRegistry> capabilityRegistry) {
        this.capabilityRegistry = (Provider)Preconditions.checkNotNull(capabilityRegistry);
    }

    @Override
    public String about() {
        try {
            return this.renderAbout();
        }
        catch (Exception e) {
            this.log.warn("Failed to render about", (Throwable)e);
            return null;
        }
    }

    protected String renderAbout() throws Exception {
        return null;
    }

    @Override
    public boolean isExposed() {
        return this.exposed;
    }

    protected void setExposed(boolean exposed) {
        this.exposed = exposed;
    }

    @Override
    public boolean isHidden() {
        return this.hidden;
    }

    protected void setHidden(boolean hidden) {
        this.hidden = hidden;
    }

    @Override
    public int version() {
        return 1;
    }

    @Override
    public Map<String, String> convert(Map<String, String> properties, int fromVersion) {
        return properties;
    }

    @Inject
    public void installValidationComponents(Provider<Validator> validatorProvider) {
        Preconditions.checkState((this.validatorProvider == null ? 1 : 0) != 0);
        this.validatorProvider = (Provider)Preconditions.checkNotNull(validatorProvider);
    }

    @Override
    public void validate(@Nullable CapabilityIdentity id, Map<String, String> properties, CapabilityDescriptor.ValidationMode validationMode) {
        this.validateConfig(properties, validationMode);
        if (validationMode != CapabilityDescriptor.ValidationMode.LOAD) {
            this.validateUnique(id, properties);
        }
    }

    @Override
    public boolean isDuplicated(@Nullable CapabilityIdentity id, Map<String, String> properties) {
        return !((CapabilityRegistry)this.capabilityRegistry.get()).get(this.duplicatesFilter(id, properties)).isEmpty();
    }

    @Nullable
    protected Set<String> uniqueProperties() {
        return null;
    }

    protected void validateConfig(Map<String, String> properties, CapabilityDescriptor.ValidationMode validationMode) {
        Preconditions.checkNotNull(properties);
        Preconditions.checkNotNull((Object)((Object)validationMode));
        ConfigT config = this.createConfig(properties);
        if (config != null) {
            if (validationMode == CapabilityDescriptor.ValidationMode.CREATE) {
                this.validate(config, Create.class, Default.class);
            } else {
                this.validate(config, Update.class, Default.class);
            }
        }
    }

    protected void validate(Object value, Class<?> ... groups) {
        Preconditions.checkNotNull((Object)value);
        Preconditions.checkNotNull(groups);
        if (this.log.isTraceEnabled()) {
            this.log.trace("Validating: {} in groups: {}", value, Arrays.asList(groups));
        }
        Validator validator = (Validator)this.validatorProvider.get();
        Set violations = validator.validate(value, (Class[])groups);
        ConstraintViolations.maybePropagate((Set)violations, (Logger)this.log);
    }

    private CapabilityReferenceFilterBuilder.CapabilityReferenceFilter duplicatesFilter(@Nullable CapabilityIdentity id, Map<String, String> properties) {
        Set<String> uniqueProperties;
        Preconditions.checkNotNull(properties);
        Preconditions.checkNotNull(this.capabilityRegistry);
        CapabilityReferenceFilterBuilder.CapabilityReferenceFilter filter = CapabilityReferenceFilterBuilder.capabilities().withType(this.type());
        if (id != null) {
            filter.ignore(id);
        }
        if ((uniqueProperties = this.uniqueProperties()) != null) {
            for (String key : uniqueProperties) {
                filter.withProperty(key, properties.get(key));
            }
        }
        return filter;
    }

    protected void validateUnique(@Nullable CapabilityIdentity id, Map<String, String> properties) {
        CapabilityReferenceFilterBuilder.CapabilityReferenceFilter filter = this.duplicatesFilter(id, properties);
        this.log.trace("Validating that unique capability of type {} and properties {}", (Object)this.type(), filter.getProperties());
        Collection<? extends CapabilityReference> references = ((CapabilityRegistry)this.capabilityRegistry.get()).get(filter);
        if (!references.isEmpty()) {
            StringBuilder message = new StringBuilder().append("Only one capability of type '").append(this.name()).append("'");
            for (Map.Entry<String, String> entry : filter.getProperties().entrySet()) {
                message.append(", ").append(this.propertyName(entry.getKey()).toLowerCase()).append(" '").append(entry.getValue()).append("'");
            }
            message.append(" can be created");
            throw new ValidationException(message.toString());
        }
    }

    protected ConfigT createConfig(Map<String, String> properties) {
        return null;
    }

    private String propertyName(String key) {
        List formFields = this.formFields();
        if (formFields != null) {
            for (FormField field : formFields) {
                if (!Objects.equals(key, field.getId())) continue;
                return field.getLabel();
            }
        }
        return key;
    }

    @Inject
    public void setTemplateHelper(TemplateHelper templateHelper) {
        this.templateHelper = (TemplateHelper)Preconditions.checkNotNull((Object)templateHelper);
    }

    protected String render(String template, TemplateParameters params) {
        URL url = this.getClass().getResource(template);
        return this.templateHelper.render(url, params);
    }

    protected String render(String template) {
        return this.render(template, new TemplateParameters());
    }
}

