/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.capability;

import com.google.common.base.Preconditions;
import javax.inject.Inject;
import javax.inject.Named;
import javax.validation.ConstraintValidatorContext;
import org.sonatype.nexus.capability.CapabilityDescriptorRegistry;
import org.sonatype.nexus.capability.CapabilityFactoryRegistry;
import org.sonatype.nexus.capability.CapabilityType;
import org.sonatype.nexus.capability.CapabilityTypeExists;
import org.sonatype.nexus.validation.ConstraintValidatorSupport;

@Named
public class CapabilityTypeExistsValidator
extends ConstraintValidatorSupport<CapabilityTypeExists, String> {
    private final CapabilityFactoryRegistry capabilityFactoryRegistry;
    private final CapabilityDescriptorRegistry capabilityDescriptorRegistry;

    @Inject
    public CapabilityTypeExistsValidator(CapabilityFactoryRegistry capabilityFactoryRegistry, CapabilityDescriptorRegistry capabilityDescriptorRegistry) {
        this.capabilityFactoryRegistry = (CapabilityFactoryRegistry)Preconditions.checkNotNull((Object)capabilityFactoryRegistry);
        this.capabilityDescriptorRegistry = (CapabilityDescriptorRegistry)Preconditions.checkNotNull((Object)capabilityDescriptorRegistry);
    }

    public boolean isValid(String value, ConstraintValidatorContext context) {
        if (value != null) {
            this.log.trace("Validating capability type exists: {}", (Object)value);
            CapabilityType type = CapabilityType.capabilityType(value);
            return this.capabilityFactoryRegistry.get(type) != null && this.capabilityDescriptorRegistry.get(type) != null;
        }
        return true;
    }
}

