/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.capability;

import com.google.common.base.Preconditions;
import com.google.common.collect.Sets;
import java.util.Set;

public class Tag {
    public static final String CATEGORY = "Category";
    public static final String REPOSITORY = "Repository";
    private final String key;
    private final String value;

    public Tag(String key, String value) {
        this.key = (String)Preconditions.checkNotNull((Object)key);
        this.value = (String)Preconditions.checkNotNull((Object)value);
    }

    public String key() {
        return this.key;
    }

    public String value() {
        return this.value;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Tag)) {
            return false;
        }
        Tag tag = (Tag)o;
        return this.key.equals(tag.key);
    }

    public int hashCode() {
        return this.key.hashCode();
    }

    public static Set<Tag> tags(Tag ... tags) {
        return Sets.newHashSet((Object[])((Tag[])Preconditions.checkNotNull((Object)tags)));
    }

    public static Tag categoryTag(String category) {
        return new Tag(CATEGORY, category);
    }

    public static Tag repositoryTag(String repository) {
        return new Tag(REPOSITORY, repository);
    }
}

