/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.capability.condition;

import com.google.common.base.Preconditions;
import javax.inject.Provider;
import org.sonatype.goodies.common.ComponentSupport;
import org.sonatype.nexus.capability.Condition;
import org.sonatype.nexus.capability.ConditionEvent;
import org.sonatype.nexus.common.event.EventBus;
import org.sonatype.nexus.common.event.EventManager;

public abstract class ConditionSupport
extends ComponentSupport
implements Condition {
    private final Provider<EventManager> eventManagerProvider;
    private boolean satisfied;
    private boolean active;

    protected ConditionSupport(EventManager eventManager) {
        this(eventManager, false);
    }

    protected ConditionSupport(final EventManager eventManager, boolean satisfied) {
        this(new Provider<EventManager>(){

            public EventManager get() {
                return eventManager;
            }
        }, satisfied);
    }

    protected ConditionSupport(Provider<EventManager> eventManagerProvider) {
        this(eventManagerProvider, false);
    }

    protected ConditionSupport(Provider<EventManager> eventManagerProvider, boolean satisfied) {
        this.eventManagerProvider = (Provider)Preconditions.checkNotNull(eventManagerProvider);
        this.satisfied = satisfied;
        this.active = false;
    }

    public EventManager getEventManager() {
        return (EventManager)this.eventManagerProvider.get();
    }

    @Override
    public boolean isSatisfied() {
        return this.satisfied;
    }

    public boolean isActive() {
        return this.active;
    }

    @Override
    public final Condition bind() {
        if (!this.active) {
            this.active = true;
            this.doBind();
        }
        return this;
    }

    @Override
    public final Condition release() {
        if (this.active) {
            this.doRelease();
            this.active = false;
        }
        return this;
    }

    @Override
    public String explainSatisfied() {
        return this + " is satisfied";
    }

    @Override
    public String explainUnsatisfied() {
        return this + " is not satisfied";
    }

    protected abstract void doBind();

    protected abstract void doRelease();

    protected void setSatisfied(boolean satisfied) {
        if (this.satisfied != satisfied) {
            this.satisfied = satisfied;
            if (this.active) {
                if (this.satisfied) {
                    this.getEventManager().post((Object)new ConditionEvent.Satisfied(this));
                } else {
                    this.getEventManager().post((Object)new ConditionEvent.Unsatisfied(this));
                }
            }
        }
    }

    @Deprecated
    protected ConditionSupport(EventBus eventBus) {
        this((EventManager)eventBus, false);
    }

    @Deprecated
    protected ConditionSupport(EventBus eventBus, boolean satisfied) {
        this((EventManager)eventBus, satisfied);
    }

    @Deprecated
    public EventBus getEventBus() {
        return (EventBus)this.eventManagerProvider.get();
    }
}

