/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.capability.condition.internal;

import com.google.common.base.Preconditions;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.sonatype.nexus.capability.CapabilityDescriptorRegistry;
import org.sonatype.nexus.capability.CapabilityRegistry;
import org.sonatype.nexus.capability.CapabilityType;
import org.sonatype.nexus.capability.Condition;
import org.sonatype.nexus.capability.Evaluable;
import org.sonatype.nexus.capability.condition.CapabilityConditions;
import org.sonatype.nexus.capability.condition.internal.CapabilityHasNoDuplicatesCondition;
import org.sonatype.nexus.capability.condition.internal.CapabilityHasNoFailuresCondition;
import org.sonatype.nexus.capability.condition.internal.CapabilityOfTypeActiveCondition;
import org.sonatype.nexus.capability.condition.internal.CapabilityOfTypeExistsCondition;
import org.sonatype.nexus.capability.condition.internal.EvaluableCondition;
import org.sonatype.nexus.capability.condition.internal.PassivateCapabilityDuringUpdateCondition;
import org.sonatype.nexus.common.event.EventManager;

@Named
@Singleton
public class CapabilityConditionsImpl
implements CapabilityConditions {
    private final CapabilityRegistry capabilityRegistry;
    private final EventManager eventManager;
    private final CapabilityDescriptorRegistry descriptorRegistry;

    @Inject
    public CapabilityConditionsImpl(EventManager eventManager, CapabilityDescriptorRegistry descriptorRegistry, CapabilityRegistry capabilityRegistry) {
        this.descriptorRegistry = (CapabilityDescriptorRegistry)Preconditions.checkNotNull((Object)descriptorRegistry);
        this.capabilityRegistry = (CapabilityRegistry)Preconditions.checkNotNull((Object)capabilityRegistry);
        this.eventManager = (EventManager)Preconditions.checkNotNull((Object)eventManager);
    }

    @Override
    public Condition capabilityOfTypeExists(CapabilityType type) {
        return new CapabilityOfTypeExistsCondition(this.eventManager, this.descriptorRegistry, this.capabilityRegistry, type);
    }

    @Override
    public Condition capabilityOfTypeActive(CapabilityType type) {
        return new CapabilityOfTypeActiveCondition(this.eventManager, this.descriptorRegistry, this.capabilityRegistry, type);
    }

    @Override
    public Condition passivateCapabilityDuringUpdate() {
        return new PassivateCapabilityDuringUpdateCondition(this.eventManager, new String[0]);
    }

    @Override
    public Condition passivateCapabilityWhenPropertyChanged(String ... propertyNames) {
        return new PassivateCapabilityDuringUpdateCondition(this.eventManager, propertyNames);
    }

    @Override
    public Condition capabilityHasNoFailures() {
        return new CapabilityHasNoFailuresCondition(this.eventManager);
    }

    @Override
    public Condition evaluable(Evaluable condition) {
        return new EvaluableCondition(this.eventManager, condition);
    }

    @Override
    public Condition capabilityHasNoDuplicates() {
        return new CapabilityHasNoDuplicatesCondition(this.eventManager);
    }
}

