/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.capability.condition.internal;

import com.google.common.base.Preconditions;
import com.google.common.eventbus.AllowConcurrentEvents;
import com.google.common.eventbus.Subscribe;
import org.sonatype.nexus.capability.CapabilityContext;
import org.sonatype.nexus.capability.CapabilityContextAware;
import org.sonatype.nexus.capability.CapabilityEvent;
import org.sonatype.nexus.capability.condition.ConditionSupport;
import org.sonatype.nexus.common.event.EventManager;

public class CapabilityHasNoFailuresCondition
extends ConditionSupport
implements CapabilityContextAware {
    private CapabilityContext context;
    private String failingAction;
    private Exception failure;

    public CapabilityHasNoFailuresCondition(EventManager eventManager) {
        super(eventManager);
    }

    @Override
    public CapabilityHasNoFailuresCondition setContext(CapabilityContext context) {
        Preconditions.checkState((!this.isActive() ? 1 : 0) != 0, (Object)"Cannot contextualize when already bounded");
        Preconditions.checkState((this.context == null ? 1 : 0) != 0, (Object)("Already contextualized with '" + this.context + "'"));
        this.context = context;
        return this;
    }

    @Override
    protected void doBind() {
        Preconditions.checkState((this.context != null ? 1 : 0) != 0, (Object)"Not yet contextualized");
        this.getEventManager().register((Object)this);
        this.failingAction = this.context.failingAction();
        this.failure = this.context.failure();
        this.setSatisfied(this.failure == null);
    }

    @Override
    public void doRelease() {
        this.getEventManager().unregister((Object)this);
    }

    @AllowConcurrentEvents
    @Subscribe
    public void handle(CapabilityEvent.CallbackFailure event) {
        if (event.getReference().context().id().equals(this.context.id())) {
            this.failingAction = event.failingAction();
            this.failure = event.failure();
            this.setSatisfied(false);
        }
    }

    @AllowConcurrentEvents
    @Subscribe
    public void handle(CapabilityEvent.CallbackFailureCleared event) {
        if (event.getReference().context().id().equals(this.context.id())) {
            this.failingAction = null;
            this.failure = null;
            this.setSatisfied(true);
        }
    }

    public String toString() {
        return "Has no failures: " + this.context.id();
    }

    @Override
    public String explainSatisfied() {
        return "Capability has not failures";
    }

    @Override
    public String explainUnsatisfied() {
        return String.valueOf(this.failingAction) + " failed: " + this.failure;
    }
}

