/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.capability.condition.internal;

import com.google.common.eventbus.AllowConcurrentEvents;
import com.google.common.eventbus.Subscribe;
import org.sonatype.nexus.capability.CapabilityDescriptorRegistry;
import org.sonatype.nexus.capability.CapabilityEvent;
import org.sonatype.nexus.capability.CapabilityReference;
import org.sonatype.nexus.capability.CapabilityRegistry;
import org.sonatype.nexus.capability.CapabilityType;
import org.sonatype.nexus.capability.condition.internal.CapabilityOfTypeExistsCondition;
import org.sonatype.nexus.common.event.EventManager;

public class CapabilityOfTypeActiveCondition
extends CapabilityOfTypeExistsCondition {
    public CapabilityOfTypeActiveCondition(EventManager eventManager, CapabilityDescriptorRegistry descriptorRegistry, CapabilityRegistry capabilityRegistry, CapabilityType type) {
        super(eventManager, descriptorRegistry, capabilityRegistry, type);
    }

    @Override
    boolean isSatisfiedBy(CapabilityReference reference) {
        return super.isSatisfiedBy(reference) && reference.context().isActive();
    }

    @AllowConcurrentEvents
    @Subscribe
    public void handle(CapabilityEvent.AfterActivated event) {
        if (!this.isSatisfied() && this.type.equals(event.getReference().context().type())) {
            this.checkAllCapabilities();
        }
    }

    @AllowConcurrentEvents
    @Subscribe
    public void handle(CapabilityEvent.BeforePassivated event) {
        if (this.isSatisfied() && this.type.equals(event.getReference().context().type())) {
            this.checkAllCapabilities();
        }
    }

    @Override
    public String toString() {
        return "Active " + this.type;
    }

    @Override
    public String explainSatisfied() {
        return String.valueOf(this.typeName) + " is active";
    }

    @Override
    public String explainUnsatisfied() {
        return String.valueOf(this.typeName) + " is not active";
    }
}

