/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.capability.condition.internal;

import com.google.common.base.Preconditions;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.sonatype.nexus.capability.Condition;
import org.sonatype.nexus.capability.condition.CapabilityConditions;
import org.sonatype.nexus.capability.condition.Conditions;
import org.sonatype.nexus.capability.condition.CryptoConditions;
import org.sonatype.nexus.capability.condition.LogicalConditions;
import org.sonatype.nexus.capability.condition.NexusConditions;
import org.sonatype.nexus.capability.condition.internal.SatisfiedCondition;
import org.sonatype.nexus.capability.condition.internal.UnsatisfiedCondition;

@Named
@Singleton
public class ConditionsImpl
implements Conditions {
    private final LogicalConditions logicalConditions;
    private final CapabilityConditions capabilityConditions;
    private final NexusConditions nexusConditions;
    private final CryptoConditions cryptoConditions;

    @Inject
    public ConditionsImpl(LogicalConditions logicalConditions, CapabilityConditions capabilityConditions, NexusConditions nexusConditions, CryptoConditions cryptoConditions) {
        this.logicalConditions = (LogicalConditions)Preconditions.checkNotNull((Object)logicalConditions);
        this.capabilityConditions = (CapabilityConditions)Preconditions.checkNotNull((Object)capabilityConditions);
        this.nexusConditions = (NexusConditions)Preconditions.checkNotNull((Object)nexusConditions);
        this.cryptoConditions = (CryptoConditions)Preconditions.checkNotNull((Object)cryptoConditions);
    }

    @Override
    public LogicalConditions logical() {
        return this.logicalConditions;
    }

    @Override
    public CapabilityConditions capabilities() {
        return this.capabilityConditions;
    }

    @Override
    public NexusConditions nexus() {
        return this.nexusConditions;
    }

    @Override
    public CryptoConditions crypto() {
        return this.cryptoConditions;
    }

    @Override
    public Condition always(String reason) {
        return new SatisfiedCondition(reason);
    }

    @Override
    public Condition never(String reason) {
        return new UnsatisfiedCondition(reason);
    }
}

