/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.capability.condition.internal;

import com.google.common.base.Preconditions;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.sonatype.nexus.capability.Condition;
import org.sonatype.nexus.capability.condition.CryptoConditions;
import org.sonatype.nexus.capability.condition.internal.CipherKeyHighStrengthCondition;
import org.sonatype.nexus.capability.condition.internal.CipherKeyUnlimitedStrengthCondition;
import org.sonatype.nexus.capability.condition.internal.CipherRequiredCondition;
import org.sonatype.nexus.common.event.EventManager;
import org.sonatype.nexus.crypto.CryptoHelper;

@Named
@Singleton
public class CryptoConditionsImpl
implements CryptoConditions {
    private final EventManager eventManager;
    private final CryptoHelper crypto;

    @Inject
    public CryptoConditionsImpl(EventManager eventManager, CryptoHelper crypto) {
        this.eventManager = (EventManager)Preconditions.checkNotNull((Object)eventManager);
        this.crypto = (CryptoHelper)Preconditions.checkNotNull((Object)crypto);
    }

    @Override
    public Condition requireCipher(String algorithm) {
        return new CipherRequiredCondition(this.eventManager, this.crypto, algorithm);
    }

    @Override
    public Condition highStrengthCipherKey(String algorithm) {
        return new CipherKeyHighStrengthCondition(this.eventManager, this.crypto, algorithm);
    }

    @Override
    public Condition unlimitedStrengthCipherKey(String algorithm) {
        return new CipherKeyUnlimitedStrengthCondition(this.eventManager, this.crypto, algorithm);
    }
}

