/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.capability.condition.internal;

import com.google.common.base.Preconditions;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.sonatype.nexus.capability.Condition;
import org.sonatype.nexus.capability.condition.LogicalConditions;
import org.sonatype.nexus.capability.condition.internal.ConjunctionCondition;
import org.sonatype.nexus.capability.condition.internal.DisjunctionCondition;
import org.sonatype.nexus.capability.condition.internal.InversionCondition;
import org.sonatype.nexus.common.event.EventManager;

@Named
@Singleton
public class LogicalConditionsImpl
implements LogicalConditions {
    private final EventManager eventManager;

    @Inject
    public LogicalConditionsImpl(EventManager eventManager) {
        this.eventManager = (EventManager)Preconditions.checkNotNull((Object)eventManager);
    }

    @Override
    public Condition and(Condition ... conditions) {
        return new ConjunctionCondition(this.eventManager, conditions);
    }

    @Override
    public Condition or(Condition ... conditions) {
        return new DisjunctionCondition(this.eventManager, conditions);
    }

    @Override
    public Condition not(Condition condition) {
        return new InversionCondition(this.eventManager, condition);
    }
}

