/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.repository.rubygems;

import com.google.common.base.Supplier;
import com.google.common.collect.ImmutableMap;
import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import java.util.Set;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.sonatype.nexus.repository.Repository;
import org.sonatype.nexus.repository.rest.UploadDefinitionExtension;
import org.sonatype.nexus.repository.rubygems.GemCoordinate;
import org.sonatype.nexus.repository.rubygems.RubygemsContentFacet;
import org.sonatype.nexus.repository.rubygems.internal.GemsUtils;
import org.sonatype.nexus.repository.rubygems.internal.RubygemsCommonUtils;
import org.sonatype.nexus.repository.security.ContentPermissionChecker;
import org.sonatype.nexus.repository.security.VariableResolverAdapter;
import org.sonatype.nexus.repository.storage.StorageFacet;
import org.sonatype.nexus.repository.storage.TempBlob;
import org.sonatype.nexus.repository.upload.AssetUpload;
import org.sonatype.nexus.repository.upload.ComponentUpload;
import org.sonatype.nexus.repository.upload.UploadDefinition;
import org.sonatype.nexus.repository.upload.UploadHandlerSupport;
import org.sonatype.nexus.repository.upload.UploadResponse;
import org.sonatype.nexus.repository.view.Payload;
import org.sonatype.nexus.transaction.UnitOfWork;

@Named(value="rubygems")
@Singleton
public class RubygemsUploadHandler
extends UploadHandlerSupport {
    private UploadDefinition definition;
    private final ContentPermissionChecker contentPermissionChecker;
    private final VariableResolverAdapter variableResolverAdapter;

    @Inject
    public RubygemsUploadHandler(ContentPermissionChecker contentPermissionChecker, @Named(value="simple") VariableResolverAdapter variableResolverAdapter, Set<UploadDefinitionExtension> uploadDefinitionExtensions) {
        super(uploadDefinitionExtensions);
        this.contentPermissionChecker = contentPermissionChecker;
        this.variableResolverAdapter = variableResolverAdapter;
    }

    public UploadResponse handle(Repository repository, ComponentUpload upload) throws IOException {
        RubygemsContentFacet facet = (RubygemsContentFacet)repository.facet(RubygemsContentFacet.class);
        StorageFacet storageFacet = (StorageFacet)repository.facet(StorageFacet.class);
        Throwable throwable = null;
        Object var6_7 = null;
        try {
            TempBlob tempBlob = storageFacet.createTempBlob((Payload)((AssetUpload)upload.getAssetUploads().get(0)).getPayload(), RubygemsCommonUtils.HASH_ALGORITHMS);
            GemCoordinate coordinates = GemsUtils.retrieveGemSpecification((Supplier<InputStream>)tempBlob).getCoordinate();
            this.ensurePermitted(repository.getName(), "rubygems", coordinates.gemPath(), this.coordinatesToMap(coordinates));
            UnitOfWork.begin((Supplier)storageFacet.txSupplier());
            UploadResponse uploadResponse = new UploadResponse(facet.doPutGem(coordinates, tempBlob));
            return uploadResponse;
            {
                finally {
                    UnitOfWork.end();
                }
            }
            finally {
                if (tempBlob != null) {
                    tempBlob.close();
                }
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    private Map<String, String> coordinatesToMap(GemCoordinate coordinates) {
        return ImmutableMap.of((Object)"name", (Object)coordinates.getName(), (Object)"version", (Object)coordinates.getVersion());
    }

    public UploadDefinition getDefinition() {
        if (this.definition == null) {
            this.definition = this.getDefinition("rubygems", false);
        }
        return this.definition;
    }

    public VariableResolverAdapter getVariableResolverAdapter() {
        return this.variableResolverAdapter;
    }

    public ContentPermissionChecker contentPermissionChecker() {
        return this.contentPermissionChecker;
    }
}

