/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.repository.rubygems.internal;

import com.google.common.base.Supplier;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import javax.annotation.Nullable;
import javax.validation.constraints.NotNull;
import org.sonatype.nexus.blobstore.api.Blob;
import org.sonatype.nexus.repository.Repository;
import org.sonatype.nexus.repository.rubygems.AssetKind;
import org.sonatype.nexus.repository.rubygems.GemCoordinate;
import org.sonatype.nexus.repository.rubygems.internal.RubygemsCommonUtils;
import org.sonatype.nexus.repository.rubygems.marshal.BundlerGem;
import org.sonatype.nexus.repository.rubygems.marshal.BundlerGems;
import org.sonatype.nexus.repository.rubygems.marshal.GemSpecification;
import org.sonatype.nexus.repository.rubygems.marshal.Marshal;
import org.sonatype.nexus.repository.storage.Asset;
import org.sonatype.nexus.repository.storage.Bucket;
import org.sonatype.nexus.repository.storage.StorageTx;

public class BundlerApiUtils {
    private BundlerApiUtils() {
    }

    @Nullable
    public static Asset findBundlerApiDependencies(@NotNull StorageTx tx, @NotNull Bucket bucket, @NotNull String name) {
        return RubygemsCommonUtils.findAsset(tx, bucket, GemCoordinate.dependenciesPath(name));
    }

    @NotNull
    public static Asset getBundlerApiDependencies(@NotNull StorageTx tx, @NotNull Bucket bucket, @NotNull Repository repository, @NotNull String name) {
        Asset asset = BundlerApiUtils.findBundlerApiDependencies(tx, bucket, name);
        if (asset == null) {
            asset = (Asset)tx.createAsset(bucket, repository.getFormat()).name(GemCoordinate.dependenciesPath(name));
            asset.formatAttributes().set("asset_kind", (Object)AssetKind.BUNDLER_API_DEPENDENCIES.name());
        }
        return asset;
    }

    @NotNull
    public static BundlerGems asBundlerGems(@NotNull StorageTx tx, @NotNull Asset asset) throws IOException {
        if (asset.isNew()) {
            return new BundlerGems();
        }
        Blob blob = tx.requireBlob(asset.requireBlobRef());
        Throwable throwable = null;
        Object var4_5 = null;
        try (InputStream is = blob.getInputStream();){
            return Marshal.loadAs(is, BundlerGems.class);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    public static void addToBundlerApi(@NotNull StorageTx tx, @NotNull Bucket bucket, @NotNull Repository repository, @NotNull GemSpecification gemspec) throws IOException {
        Asset asset = BundlerApiUtils.getBundlerApiDependencies(tx, bucket, repository, gemspec.getName());
        BundlerGems gems = BundlerApiUtils.asBundlerGems(tx, asset);
        gems.add(new BundlerGem(gemspec));
        BundlerApiUtils.updateBundlerGems(tx, asset, gems);
    }

    public static void deleteFromBundlerApi(StorageTx tx, Bucket bucket, GemCoordinate coordinate) throws IOException {
        Asset asset = BundlerApiUtils.findBundlerApiDependencies(tx, bucket, coordinate.getName());
        if (asset != null) {
            BundlerGems gems = BundlerApiUtils.asBundlerGems(tx, asset);
            gems.remove(new BundlerGem(coordinate));
            BundlerApiUtils.updateBundlerGems(tx, asset, gems);
        }
    }

    public static void updateBundlerGems(@NotNull StorageTx tx, @NotNull Asset asset, @NotNull BundlerGems gems) throws IOException {
        if (gems.getGems().isEmpty()) {
            tx.deleteAsset(asset);
        } else {
            byte[] bytes = Marshal.dumpAsBytes(gems);
            RubygemsCommonUtils.updateAsset(tx, asset, (Supplier<InputStream>)((Supplier)() -> new ByteArrayInputStream(bytes)));
        }
    }
}

