/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.repository.rubygems.internal;

import com.google.common.base.Supplier;
import com.google.common.io.ByteStreams;
import com.google.common.io.Closeables;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.zip.GZIPOutputStream;
import javax.annotation.Nonnull;
import org.sonatype.goodies.common.ComponentSupport;
import org.sonatype.nexus.repository.view.payloads.StreamPayload;

class GZippedTempStreamSupplier
extends ComponentSupport
implements AutoCloseable,
Supplier<InputStream>,
StreamPayload.InputStreamSupplier {
    private final Path tempFile = Files.createTempFile("", "", new FileAttribute[0]);

    public GZippedTempStreamSupplier(InputStream inputStream) throws IOException {
        try {
            Throwable throwable = null;
            Object var3_4 = null;
            try (GZIPOutputStream outputStream = new GZIPOutputStream(Files.newOutputStream(this.tempFile, new OpenOption[0]));){
                ByteStreams.copy((InputStream)inputStream, (OutputStream)outputStream);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        finally {
            Closeables.closeQuietly((InputStream)inputStream);
        }
    }

    @Override
    public void close() {
        try {
            Files.delete(this.tempFile);
        }
        catch (IOException e) {
            this.log.warn("Unable to delete temp file {}", (Object)this.tempFile, (Object)e);
        }
    }

    @Nonnull
    public InputStream get() {
        try {
            return Files.newInputStream(this.tempFile, new OpenOption[0]);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

