/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.repository.rubygems.internal;

import com.google.common.base.Preconditions;
import com.google.common.base.Supplier;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import java.util.Map;
import java.util.zip.DeflaterInputStream;
import java.util.zip.GZIPInputStream;
import javax.annotation.Nullable;
import javax.validation.constraints.NotNull;
import org.apache.commons.compress.archivers.tar.TarArchiveEntry;
import org.apache.commons.compress.archivers.tar.TarArchiveInputStream;
import org.slf4j.Logger;
import org.sonatype.goodies.common.Loggers;
import org.sonatype.nexus.common.collect.AttributesMap;
import org.sonatype.nexus.common.collect.NestedAttributesMap;
import org.sonatype.nexus.repository.Repository;
import org.sonatype.nexus.repository.rubygems.AssetKind;
import org.sonatype.nexus.repository.rubygems.GemCoordinate;
import org.sonatype.nexus.repository.rubygems.internal.RubygemsCommonUtils;
import org.sonatype.nexus.repository.rubygems.internal.YamlParser;
import org.sonatype.nexus.repository.rubygems.marshal.GemSpecification;
import org.sonatype.nexus.repository.rubygems.marshal.Marshal;
import org.sonatype.nexus.repository.storage.Asset;
import org.sonatype.nexus.repository.storage.Bucket;
import org.sonatype.nexus.repository.storage.Component;
import org.sonatype.nexus.repository.storage.Query;
import org.sonatype.nexus.repository.storage.StorageTx;
import org.sonatype.nexus.repository.storage.TempBlob;

public class GemsUtils {
    public static final String METADATA_GZ = "metadata.gz";
    private static final YamlParser yaml = new YamlParser();
    private static final Logger log = (Logger)Preconditions.checkNotNull((Object)Loggers.getLogger(GemsUtils.class));

    private GemsUtils() {
    }

    @NotNull
    public static Component getOrCreateGemComponent(@NotNull StorageTx tx, @NotNull Bucket bucket, @NotNull Repository repository, @NotNull GemCoordinate coordinate) {
        Component componentFound = GemsUtils.getComponent(tx, repository, coordinate);
        if (componentFound != null) {
            return componentFound;
        }
        Component component = (Component)tx.createComponent(bucket, repository.getFormat()).version(coordinate.getGemVersion().getVersion()).name(coordinate.getName());
        log.trace("Created gem component: {} {}", (Object)component.name(), (Object)component.version());
        tx.saveComponent(component);
        return component;
    }

    @Nullable
    public static Component getComponent(StorageTx tx, Repository repository, GemCoordinate coordinate) {
        Iterable components = tx.findComponents(Query.builder().where("name").eq((Object)coordinate.getName()).and("version").eq((Object)coordinate.getGemVersion().getVersion()).build(), Collections.singletonList(repository));
        if (components.iterator().hasNext()) {
            return (Component)components.iterator().next();
        }
        return null;
    }

    @NotNull
    public static Asset getOrCreateGemAsset(@NotNull StorageTx tx, @NotNull Bucket bucket, @NotNull Component component, @NotNull GemCoordinate coordinate) {
        String storagePath = coordinate.gemPath();
        return GemsUtils.getGemAsset(tx, bucket, component, AssetKind.GEM, coordinate, storagePath);
    }

    @NotNull
    public static Asset getOrCreateGemAsset(@NotNull StorageTx tx, @NotNull Bucket bucket, @NotNull Component component, @NotNull GemSpecification gemspec) {
        GemCoordinate coordinate = (GemCoordinate)Preconditions.checkNotNull((Object)gemspec.getCoordinate());
        String storagePath = coordinate.gemPath();
        Asset asset = GemsUtils.getGemAsset(tx, bucket, component, AssetKind.GEM, coordinate, storagePath);
        GemsUtils.applyGemspecAttributesToGem(asset, gemspec);
        NestedAttributesMap metadata = asset.formatAttributes().child("metadata");
        gemspec.getMetadata().forEach((arg_0, arg_1) -> ((AttributesMap)metadata).set(arg_0, arg_1));
        return asset;
    }

    public static void applyGemspecAttributesToGem(@NotNull Asset asset, @NotNull GemSpecification gemspec) {
        GemsUtils.set(asset, "description", gemspec.getDescription());
        GemsUtils.set(asset, "summary", gemspec.getSummary());
        GemsUtils.set(asset, "homepage", gemspec.getHomepage());
        GemsUtils.set(asset, "licenses", gemspec.getLicenses());
        GemsUtils.set(asset, "emails", gemspec.getEmails());
        GemsUtils.set(asset, "authors", gemspec.getAuthors());
        GemsUtils.set(asset, "requirements", gemspec.getRequirements());
        GemsUtils.set(asset, "executables", gemspec.getExecutables());
        GemsUtils.set(asset, "created at", gemspec.getDate() == null ? null : gemspec.getDate().formatted());
        GemsUtils.set(asset, "required ruby version", gemspec.getRequiredRubyVersion().display());
        GemsUtils.set(asset, "required rubygems version", gemspec.getRequiredRubygemsVersion().display());
    }

    private static void set(Asset asset, String key, Object value) {
        if (value != null) {
            asset.formatAttributes().set(key, value);
        }
    }

    @NotNull
    public static Asset getOrCreateGemspecAsset(@NotNull StorageTx tx, @NotNull Bucket bucket, @NotNull Component component, @NotNull GemCoordinate coordinate) {
        return GemsUtils.getGemAsset(tx, bucket, component, AssetKind.GEMSPEC, coordinate, coordinate.gemspecPath());
    }

    private static Asset getGemAsset(@NotNull StorageTx tx, @NotNull Bucket bucket, @NotNull Component component, @NotNull AssetKind kind, GemCoordinate coordinate, String storagePath) {
        Asset asset = tx.findAssetWithProperty("name", (Object)storagePath, component);
        if (asset == null) {
            asset = tx.createAsset(bucket, component);
            asset.name(storagePath);
            asset.formatAttributes().set("asset_kind", (Object)kind.name());
            asset.formatAttributes().set("platform", (Object)coordinate.getPlatform());
            log.trace("Created asset: {} for gem {} {}", new Object[]{asset, component.name(), component.version()});
        }
        return asset;
    }

    @NotNull
    public static String deleteGemspec(@NotNull StorageTx tx, @NotNull Component component, @NotNull GemCoordinate coordinate) {
        String storagePath = coordinate.gemspecPath();
        Asset asset = tx.findAssetWithProperty("name", (Object)storagePath, component);
        if (asset != null) {
            tx.deleteAsset(asset);
            log.trace("Deleted asset: {} for gem {} {}", new Object[]{asset, component.name(), component.version()});
            return asset.name();
        }
        return null;
    }

    public static GemSpecification retrieveGemSpecification(@NotNull Supplier<InputStream> streamOfGem) throws IOException {
        Throwable throwable = null;
        Object var2_3 = null;
        try (TarArchiveInputStream tar = new TarArchiveInputStream((InputStream)streamOfGem.get());){
            TarArchiveEntry entry = tar.getNextTarEntry();
            while (entry != null && !entry.getName().equals(METADATA_GZ)) {
                entry = tar.getNextTarEntry();
            }
            if (entry == null || !entry.getName().equals(METADATA_GZ)) {
                throw new IOException("not found in tar-archive: metadata.gz");
            }
            GZIPInputStream gis = new GZIPInputStream((InputStream)tar);
            Map<String, Object> yamlGemspec = yaml.load(gis);
            return new GemSpecification(yamlGemspec);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    @NotNull
    public static GemCoordinate toGemCoordinate(@NotNull Component gem, @NotNull Asset asset) {
        String name = gem.name();
        String version = gem.version();
        String platform = String.valueOf(asset.formatAttributes().get("platform"));
        return new GemCoordinate(name, version, platform);
    }

    public static void updateGemspec(@NotNull StorageTx tx, @NotNull Bucket bucket, @NotNull Component component, @NotNull GemSpecification gemspec) throws IOException {
        Asset asset = GemsUtils.getOrCreateGemspecAsset(tx, bucket, component, gemspec.getCoordinate());
        byte[] bytes = Marshal.dumpAsBytes(gemspec);
        RubygemsCommonUtils.updateAsset(tx, asset, (Supplier<InputStream>)((Supplier)() -> new DeflaterInputStream(new ByteArrayInputStream(bytes))));
    }

    public static Asset updateGem(@NotNull StorageTx tx, @NotNull Bucket bucket, @NotNull Component component, @NotNull GemSpecification gemspec, @NotNull TempBlob tempBlob) throws IOException {
        Asset asset = GemsUtils.getOrCreateGemAsset(tx, bucket, component, gemspec);
        RubygemsCommonUtils.updateAsset(tx, asset, null, tempBlob);
        return asset;
    }
}

