/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.repository.rubygems.internal;

import com.google.common.base.Preconditions;
import com.google.common.base.Supplier;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.annotation.Nullable;
import javax.validation.constraints.NotNull;
import org.slf4j.Logger;
import org.sonatype.goodies.common.Loggers;
import org.sonatype.nexus.common.collect.AttributesMap;
import org.sonatype.nexus.common.hash.HashAlgorithm;
import org.sonatype.nexus.repository.Repository;
import org.sonatype.nexus.repository.rubygems.AssetKind;
import org.sonatype.nexus.repository.rubygems.GemCoordinate;
import org.sonatype.nexus.repository.rubygems.RubygemsFile;
import org.sonatype.nexus.repository.rubygems.internal.BundlerApiUtils;
import org.sonatype.nexus.repository.rubygems.internal.GemsUtils;
import org.sonatype.nexus.repository.rubygems.internal.SpecsIndexUtils;
import org.sonatype.nexus.repository.storage.Asset;
import org.sonatype.nexus.repository.storage.AssetBlob;
import org.sonatype.nexus.repository.storage.Bucket;
import org.sonatype.nexus.repository.storage.Component;
import org.sonatype.nexus.repository.storage.StorageTx;
import org.sonatype.nexus.repository.storage.TempBlob;
import org.sonatype.nexus.repository.view.Content;

public class RubygemsCommonUtils {
    public static final List<HashAlgorithm> HASH_ALGORITHMS = Arrays.asList(HashAlgorithm.MD5, HashAlgorithm.SHA1);
    private static final Logger log = (Logger)Preconditions.checkNotNull((Object)Loggers.getLogger(RubygemsCommonUtils.class));

    private RubygemsCommonUtils() {
    }

    public static Set<String> deleteAsset(@NotNull StorageTx tx, @NotNull Bucket bucket, @NotNull Repository repository, @Nullable Asset asset) throws IOException {
        return RubygemsCommonUtils.deleteAsset(tx, bucket, repository, asset, true);
    }

    public static Set<String> deleteAsset(@NotNull StorageTx tx, @NotNull Bucket bucket, @NotNull Repository repository, @Nullable Asset asset, boolean deleteBlob) throws IOException {
        if (asset == null) {
            return Collections.emptySet();
        }
        AssetKind kind = AssetKind.valueOf(String.valueOf(asset.formatAttributes().get("asset_kind")));
        if (kind != AssetKind.GEM) {
            log.trace("Did not delete: {}", (Object)asset);
            return Collections.emptySet();
        }
        Component component = tx.findComponentInBucket(asset.componentId(), bucket);
        GemCoordinate coordinate = GemsUtils.toGemCoordinate(component, asset);
        SpecsIndexUtils.deleteFromSpecsIndex(tx, bucket, repository, coordinate);
        BundlerApiUtils.deleteFromBundlerApi(tx, bucket, coordinate);
        String removedGemspec = GemsUtils.deleteGemspec(tx, component, coordinate);
        log.trace("Deleting asset: {}", (Object)asset);
        tx.deleteAsset(asset, deleteBlob);
        if (!tx.browseAssets(component).iterator().hasNext()) {
            log.trace("Deleting component: {}", (Object)component);
            tx.deleteComponent(component, deleteBlob);
        }
        HashSet<String> removedAssetNames = new HashSet<String>();
        removedAssetNames.add(asset.name());
        if (removedGemspec != null) {
            removedAssetNames.add(removedGemspec);
        }
        return removedAssetNames;
    }

    @Nullable
    public static Asset findAsset(@NotNull StorageTx tx, @NotNull Bucket bucket, @NotNull RubygemsFile file) {
        return RubygemsCommonUtils.findAsset(tx, bucket, file.getPath());
    }

    @Nullable
    public static Asset findAsset(@NotNull StorageTx tx, @NotNull Bucket bucket, @NotNull String path) {
        return tx.findAssetWithProperty("name", (Object)path, bucket);
    }

    @NotNull
    public static AssetBlob updateAsset(@NotNull StorageTx tx, @NotNull Asset asset, @NotNull Supplier<InputStream> stream) throws IOException {
        return RubygemsCommonUtils.updateAsset(tx, asset, null, stream);
    }

    @NotNull
    public static AssetBlob updateAsset(@NotNull StorageTx tx, @NotNull Asset asset, @Nullable AssetBlob assetBlob, @Nullable AttributesMap contentAttributes) throws IOException {
        if (contentAttributes != null) {
            Content.applyToAsset((Asset)asset, (AttributesMap)contentAttributes);
        }
        tx.attachBlob(asset, assetBlob);
        tx.saveAsset(asset);
        return assetBlob;
    }

    @NotNull
    public static AssetBlob updateAsset(@NotNull StorageTx tx, @NotNull Asset asset, @Nullable Content content, @NotNull Supplier<InputStream> stream) throws IOException {
        RubygemsCommonUtils.applyLastModified(asset, content);
        AssetBlob blob = tx.setBlob(asset, asset.name(), stream, HASH_ALGORITHMS, null, "application/octet-stream", true);
        tx.saveAsset(asset);
        return blob;
    }

    @NotNull
    public static AssetBlob updateAsset(@NotNull StorageTx tx, @NotNull Asset asset, @Nullable Content content, @NotNull TempBlob tempBlob) throws IOException {
        RubygemsCommonUtils.applyLastModified(asset, content);
        AssetBlob blob = tx.setBlob(asset, asset.name(), tempBlob, null, "application/octet-stream", true);
        tx.saveAsset(asset);
        return blob;
    }

    public static void applyLastModified(@NotNull Asset asset, @Nullable Content content) {
        AttributesMap contentAttributes = Content.maintainLastModified((Asset)asset, (AttributesMap)(content == null ? null : content.getAttributes()));
        Content.applyToAsset((Asset)asset, (AttributesMap)contentAttributes);
    }
}

