/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.repository.rubygems.internal;

import java.io.IOException;
import java.util.Collections;
import java.util.Set;
import org.sonatype.nexus.common.entity.EntityId;
import org.sonatype.nexus.repository.rubygems.RubygemsFile;
import org.sonatype.nexus.repository.rubygems.internal.BundlerApiUtils;
import org.sonatype.nexus.repository.rubygems.internal.RubygemsCommonUtils;
import org.sonatype.nexus.repository.rubygems.internal.SpecsIndexUtils;
import org.sonatype.nexus.repository.rubygems.marshal.BundlerGems;
import org.sonatype.nexus.repository.rubygems.marshal.GemVersion;
import org.sonatype.nexus.repository.rubygems.marshal.SpecsIndex;
import org.sonatype.nexus.repository.storage.Asset;
import org.sonatype.nexus.repository.storage.Bucket;
import org.sonatype.nexus.repository.storage.Component;
import org.sonatype.nexus.repository.storage.DefaultComponentMaintenanceImpl;
import org.sonatype.nexus.repository.storage.StorageTx;
import org.sonatype.nexus.repository.transaction.TransactionalDeleteBlob;
import org.sonatype.nexus.transaction.UnitOfWork;

public class RubygemsComponentMaintenanceImpl
extends DefaultComponentMaintenanceImpl {
    @TransactionalDeleteBlob
    protected Set<String> deleteAssetTx(EntityId assetId, boolean deleteBlob) {
        StorageTx tx = (StorageTx)UnitOfWork.currentTx();
        Bucket bucket = tx.findBucket(this.getRepository());
        Asset asset = tx.findAsset(assetId, bucket);
        try {
            return RubygemsCommonUtils.deleteAsset(tx, bucket, this.getRepository(), asset);
        }
        catch (IOException e) {
            this.log.error("error deleting asset with id {} from repository {}", new Object[]{assetId.getValue(), this.getRepository().getName(), e});
            return Collections.emptySet();
        }
    }

    @TransactionalDeleteBlob
    protected Set<String> deleteComponentTx(EntityId componentId, boolean deleteBlobs) {
        Bucket bucket;
        StorageTx tx = (StorageTx)UnitOfWork.currentTx();
        Component component = tx.findComponentInBucket(componentId, bucket = tx.findBucket(this.getRepository()));
        if (component == null) {
            return Collections.emptySet();
        }
        try {
            this.removeFromBundlerApi(tx, bucket, component);
            this.removeFromSpecsIndex(tx, bucket, component);
        }
        catch (IOException e) {
            this.log.error("error deleting component with id {} from repository {}", new Object[]{componentId.getValue(), this.getRepository().getName(), e});
        }
        this.log.trace("Deleting component: {}", (Object)component);
        return tx.deleteComponent(component, deleteBlobs);
    }

    private void removeFromSpecsIndex(StorageTx tx, Bucket bucket, Component component) throws IOException {
        GemVersion version = new GemVersion(component.version());
        String path = version.isPrereleaseGem() ? RubygemsFile.PRERELEASE_SPECS_4_8_GZ : RubygemsFile.SPECS_4_8_GZ;
        Asset asset = SpecsIndexUtils.findSpecsIndex(tx, bucket, path);
        if (asset == null) {
            return;
        }
        SpecsIndex index = SpecsIndexUtils.asSpecsIndex(tx, asset);
        index.removeAll(component.name(), version);
        SpecsIndexUtils.updateSpecsIndex(tx, asset, index);
        if (!version.isPrereleaseGem()) {
            SpecsIndexUtils.updateLatestSpecsIndex(tx, bucket, this.getRepository(), index);
        }
    }

    private void removeFromBundlerApi(StorageTx tx, Bucket bucket, Component component) throws IOException {
        Asset asset = BundlerApiUtils.findBundlerApiDependencies(tx, bucket, component.name());
        if (asset == null) {
            return;
        }
        BundlerGems gems = BundlerApiUtils.asBundlerGems(tx, asset);
        gems.removeAll(component.name(), component.version());
        BundlerApiUtils.updateBundlerGems(tx, asset, gems);
    }
}

