/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.repository.rubygems.internal;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.base.Supplier;
import com.google.common.eventbus.AllowConcurrentEvents;
import com.google.common.eventbus.Subscribe;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import java.util.Map;
import java.util.zip.GZIPInputStream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.inject.Inject;
import javax.inject.Named;
import org.joda.time.DateTime;
import org.joda.time.ReadableInstant;
import org.sonatype.goodies.common.Time;
import org.sonatype.nexus.common.collect.AttributesMap;
import org.sonatype.nexus.common.io.Cooperation;
import org.sonatype.nexus.common.io.CooperationFactory;
import org.sonatype.nexus.repository.Facet;
import org.sonatype.nexus.repository.Repository;
import org.sonatype.nexus.repository.Type;
import org.sonatype.nexus.repository.cache.CacheInfo;
import org.sonatype.nexus.repository.config.Configuration;
import org.sonatype.nexus.repository.group.GroupFacetImpl;
import org.sonatype.nexus.repository.manager.RepositoryManager;
import org.sonatype.nexus.repository.rubygems.AssetKind;
import org.sonatype.nexus.repository.rubygems.RubygemsContentFacet;
import org.sonatype.nexus.repository.rubygems.RubygemsFile;
import org.sonatype.nexus.repository.rubygems.internal.GZippedTempStreamSupplier;
import org.sonatype.nexus.repository.rubygems.internal.RubygemsCommonUtils;
import org.sonatype.nexus.repository.rubygems.marshal.Marshal;
import org.sonatype.nexus.repository.rubygems.marshal.SpecsIndex;
import org.sonatype.nexus.repository.storage.Asset;
import org.sonatype.nexus.repository.storage.AssetBlob;
import org.sonatype.nexus.repository.storage.AssetEvent;
import org.sonatype.nexus.repository.storage.Bucket;
import org.sonatype.nexus.repository.storage.StorageFacet;
import org.sonatype.nexus.repository.storage.StorageTx;
import org.sonatype.nexus.repository.transaction.TransactionalStoreBlob;
import org.sonatype.nexus.repository.view.Content;
import org.sonatype.nexus.repository.view.Payload;
import org.sonatype.nexus.repository.view.Response;
import org.sonatype.nexus.repository.view.payloads.BlobPayload;
import org.sonatype.nexus.transaction.UnitOfWork;
import org.sonatype.nexus.validation.ConstraintViolationFactory;

@Named
@Facet.Exposed
public class RubygemsGroupFacet
extends GroupFacetImpl {
    private RubygemsContentFacet rubygemsContentFacet;
    @Nullable
    private CooperationFactory.Builder cooperationBuilder;
    @Nullable
    private Cooperation specsIndexCooperation;

    @Inject
    public RubygemsGroupFacet(RepositoryManager repositoryManager, ConstraintViolationFactory constraintViolationFactory, @Named(value="group") Type groupType) {
        super(repositoryManager, constraintViolationFactory, groupType);
    }

    @Inject
    protected void configureCooperation(CooperationFactory cooperationFactory, @Named(value="${nexus.specsIndex.cooperation.enabled:-true}") boolean cooperationEnabled, @Named(value="${nexus.specsIndex.cooperation.majorTimeout:-0s}") Time majorTimeout, @Named(value="${nexus.specsIndex.cooperation.minorTimeout:-30s}") Time minorTimeout, @Named(value="${nexus.specsIndex.cooperation.threadsPerKey:-100}") int threadsPerKey) {
        if (cooperationEnabled) {
            this.cooperationBuilder = cooperationFactory.configure().majorTimeout(majorTimeout).minorTimeout(minorTimeout).threadsPerKey(threadsPerKey);
        }
    }

    @VisibleForTesting
    void buildCooperation() {
        if (this.cooperationBuilder != null) {
            this.specsIndexCooperation = this.cooperationBuilder.build(String.valueOf(this.getRepository().getName()) + ":specsIndex");
        }
    }

    protected void doInit(Configuration configuration) throws Exception {
        super.doInit(configuration);
        this.rubygemsContentFacet = (RubygemsContentFacet)this.facet(RubygemsContentFacet.class);
        this.buildCooperation();
    }

    @Nullable
    public Content getCached(RubygemsFile rubygemsFile) throws IOException {
        this.checkCanMerge(rubygemsFile);
        return this.rubygemsContentFacet.getCachedSpecsIndex(rubygemsFile);
    }

    public Content cache(RubygemsFile file, SpecsIndex specs) throws IOException {
        byte[] bytes = Marshal.dumpAsBytes(specs);
        Throwable throwable = null;
        Object var5_6 = null;
        try (GZippedTempStreamSupplier supplier = new GZippedTempStreamSupplier(new ByteArrayInputStream(bytes));){
            return this.cache(file, supplier);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    @TransactionalStoreBlob
    public Content cache(RubygemsFile file, Supplier<InputStream> stream) throws IOException {
        StorageTx tx = (StorageTx)UnitOfWork.currentTx();
        Bucket bucket = tx.findBucket(this.getRepository());
        Asset asset = this.getAsset(file, tx, bucket);
        AttributesMap contentAttributes = Content.maintainLastModified((Asset)asset, null);
        contentAttributes.set(CacheInfo.class, (Object)this.cacheController.current());
        Content.applyToAsset((Asset)asset, (AttributesMap)contentAttributes);
        AssetBlob blob = RubygemsCommonUtils.updateAsset(tx, asset, stream);
        return new Content((Payload)new BlobPayload(blob.getBlob(), "application/gzip"));
    }

    public boolean isStale(@Nullable DateTime cacheLastModified, Map<Repository, Response> responses) {
        if (cacheLastModified == null) {
            return true;
        }
        for (Map.Entry<Repository, Response> entry : responses.entrySet()) {
            Content content;
            DateTime remoteLastModified;
            if (entry.getValue().getStatus().getCode() != 200 || (remoteLastModified = (content = (Content)entry.getValue().getPayload()) != null ? (DateTime)((Content)entry.getValue().getPayload()).getAttributes().get("lastModified", DateTime.class) : null) != null && !remoteLastModified.isAfter((ReadableInstant)cacheLastModified)) continue;
            this.log.debug("{} found stale content", (Object)entry.getKey().getName());
            return true;
        }
        return false;
    }

    public Content mergeSpecsIndexes(RubygemsFile file, Map<Repository, Response> responses) throws IOException {
        if (this.getCached(file) != null) {
            this.evictCache(file);
        }
        if (this.specsIndexCooperation == null) {
            return this.doMerge(file, responses);
        }
        return (Content)this.specsIndexCooperation.cooperate(file.getPath(), failover -> {
            Content latestContent;
            if (failover && (latestContent = (Content)this.specsIndexCooperation.join(() -> this.getCached(file))) != null) {
                return latestContent;
            }
            return this.doMerge(file, responses);
        });
    }

    @Subscribe
    @AllowConcurrentEvents
    public void on(AssetEvent event) {
        String path;
        RubygemsFile rubygemsFile;
        if (this.isOriginatingNode(event) && (rubygemsFile = RubygemsFile.create(path = event.getAsset().name(), new String[0])) != null && rubygemsFile.getKind() == AssetKind.SPECS_INDEX) {
            UnitOfWork.begin((Supplier)((StorageFacet)this.getRepository().facet(StorageFacet.class)).txSupplier());
            try {
                try {
                    this.evictCache(rubygemsFile);
                }
                catch (IOException e) {
                    this.log.warn("Could not evict merged content from {} cache at {}", new Object[]{this.getRepository().getName(), rubygemsFile.getPath(), e});
                    UnitOfWork.end();
                }
            }
            finally {
                UnitOfWork.end();
            }
        }
    }

    private boolean isOriginatingNode(AssetEvent event) {
        return event.isLocal() && event.getComponentId() == null && this.member(event.getRepositoryName());
    }

    private Supplier<InputStream> createInputStreamSupplier(final byte[] bytes) {
        return new Supplier<InputStream>(){

            @Nonnull
            public InputStream get() {
                return new ByteArrayInputStream(bytes);
            }
        };
    }

    private Asset getAsset(RubygemsFile file, StorageTx tx, Bucket bucket) {
        Asset assets = RubygemsCommonUtils.findAsset(tx, bucket, file);
        if (assets == null) {
            assets = (Asset)tx.createAsset(bucket, this.getRepository().getFormat()).name(file.getPath());
            assets.formatAttributes().set("asset_kind", (Object)file.getKind().name());
        }
        return assets;
    }

    private void evictCache(RubygemsFile rubygemsFile) throws IOException {
        this.rubygemsContentFacet.delete(rubygemsFile);
    }

    private void checkCanMerge(RubygemsFile rubygemsFile) {
        Preconditions.checkArgument((rubygemsFile.getKind() == AssetKind.SPECS_INDEX ? 1 : 0) != 0, (String)"Not handled by RubygemsGroupFacet merge: %s", (Object)((Object)rubygemsFile));
    }

    private Content doMerge(RubygemsFile file, Map<Repository, Response> responses) throws IOException {
        SpecsIndex result = new SpecsIndex();
        if (responses.size() == 1) {
            Payload payload = (Payload)Preconditions.checkNotNull((Object)responses.values().iterator().next().getPayload());
            Throwable throwable = null;
            Object var6_9 = null;
            try (InputStream stream = payload.openInputStream();){
                return this.cache(file, (Supplier<InputStream>)((Supplier)() -> stream));
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        for (Map.Entry<Repository, Response> entry : responses.entrySet()) {
            if (entry.getValue().getStatus().getCode() != 200) continue;
            Payload payload = (Payload)Preconditions.checkNotNull((Object)entry.getValue().getPayload());
            this.log.trace("start parsing {}", (Object)entry.getKey().getName());
            Throwable throwable = null;
            Object var8_15 = null;
            try (GZIPInputStream is = new GZIPInputStream(payload.openInputStream());){
                result.merge((List)Marshal.load(is));
            }
            catch (Throwable throwable3) {
                if (throwable == null) {
                    throwable = throwable3;
                } else if (throwable != throwable3) {
                    throwable.addSuppressed(throwable3);
                }
                throw throwable;
            }
            this.log.trace("stop parsing {}", (Object)entry.getKey().getName());
        }
        if (file.getPath().equals(RubygemsFile.LATEST_SPECS_4_8_GZ)) {
            result = result.toLatest();
        }
        return this.cache(file, result);
    }
}

