/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.repository.rubygems.internal;

import com.google.common.base.Preconditions;
import java.io.InputStream;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.inject.Named;
import javax.inject.Singleton;
import org.joda.time.DateTime;
import org.sonatype.nexus.repository.Repository;
import org.sonatype.nexus.repository.group.GroupFacet;
import org.sonatype.nexus.repository.group.GroupHandler;
import org.sonatype.nexus.repository.http.HttpConditions;
import org.sonatype.nexus.repository.http.HttpResponses;
import org.sonatype.nexus.repository.rubygems.RubygemsFile;
import org.sonatype.nexus.repository.rubygems.internal.RubygemsGroupFacet;
import org.sonatype.nexus.repository.rubygems.internal.RubygemsProxyFacet;
import org.sonatype.nexus.repository.rubygems.marshal.BundlerGems;
import org.sonatype.nexus.repository.rubygems.marshal.Marshal;
import org.sonatype.nexus.repository.view.Content;
import org.sonatype.nexus.repository.view.Context;
import org.sonatype.nexus.repository.view.Payload;
import org.sonatype.nexus.repository.view.Request;
import org.sonatype.nexus.repository.view.Response;
import org.sonatype.nexus.repository.view.payloads.BytesPayload;

@Named
@Singleton
class RubygemsGroupHandler
extends GroupHandler {
    RubygemsGroupHandler() {
    }

    protected Response doGet(@Nonnull Context context, @Nonnull GroupHandler.DispatchedRepositories dispatched) throws Exception {
        Content content;
        RubygemsFile file = (RubygemsFile)((Object)context.getAttributes().require(RubygemsFile.class));
        Repository repository = context.getRepository();
        this.log.debug("group repository: {} file: {}", (Object)repository.getName(), (Object)file);
        switch (file.getKind()) {
            case GEM: 
            case GEMSPEC: {
                return super.doGet(context, dispatched);
            }
            case SPECS_INDEX: {
                content = this.handleSpecsIndex(context, dispatched, file);
                break;
            }
            case BUNDLER_API_DEPENDENCIES: {
                if (file.getGems() != null && file.getGems().isEmpty()) {
                    content = new Content((Payload)RubygemsProxyFacet.EMPTY_BUNDLER_GEMS_PAYLOAD);
                    break;
                }
                if (file.getGems() == null) {
                    content = new Content((Payload)RubygemsProxyFacet.EMPTY_PAYLOAD);
                    break;
                }
                content = this.handleBundlerApi(context, dispatched);
                break;
            }
            default: {
                throw new IllegalStateException();
            }
        }
        return HttpResponses.ok((Payload)content);
    }

    private Map<Repository, Response> getResponses(Context context, GroupHandler.DispatchedRepositories dispatched) throws Exception {
        HttpConditions.makeUnconditional((Request)context.getRequest());
        try {
            GroupFacet groupFacet = (GroupFacet)context.getRepository().facet(GroupFacet.class);
            LinkedHashMap linkedHashMap = this.getAll(context, groupFacet.members(), dispatched);
            return linkedHashMap;
        }
        finally {
            HttpConditions.makeConditional((Request)context.getRequest());
        }
    }

    private Content handleBundlerApi(Context context, GroupHandler.DispatchedRepositories dispatched) throws Exception {
        Map<Repository, Response> responses = this.getResponses(context, dispatched);
        BundlerGems result = new BundlerGems();
        for (Map.Entry<Repository, Response> entry : responses.entrySet()) {
            if (entry.getValue().getStatus().getCode() != 200) continue;
            Payload payload = entry.getValue().getPayload();
            Preconditions.checkNotNull((Object)payload);
            Throwable throwable = null;
            Object var9_10 = null;
            try (InputStream is = payload.openInputStream();){
                result.addAll(Marshal.loadAs(is, BundlerGems.class).getGems());
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        return new Content((Payload)new BytesPayload(Marshal.dumpAsBytes(result), "application/octet-stream"));
    }

    private Content handleSpecsIndex(Context context, GroupHandler.DispatchedRepositories dispatched, RubygemsFile file) throws Exception {
        RubygemsGroupFacet facet = (RubygemsGroupFacet)context.getRepository().facet(RubygemsGroupFacet.class);
        Content content = facet.getCached(file);
        DateTime lastModified = content != null && content.getAttributes().contains("lastModified") ? (DateTime)content.getAttributes().get("lastModified", DateTime.class) : null;
        Map<Repository, Response> responses = this.getResponses(context, dispatched);
        if (content == null || facet.isStale(lastModified, responses)) {
            return facet.mergeSpecsIndexes(file, responses);
        }
        return content;
    }
}

