/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.repository.rubygems.internal;

import com.google.common.base.Preconditions;
import java.io.IOException;
import java.util.zip.GZIPInputStream;
import javax.annotation.Nullable;
import javax.validation.constraints.NotNull;
import org.slf4j.Logger;
import org.sonatype.goodies.common.Loggers;
import org.sonatype.nexus.blobstore.api.Blob;
import org.sonatype.nexus.repository.Repository;
import org.sonatype.nexus.repository.rubygems.AssetKind;
import org.sonatype.nexus.repository.rubygems.GemCoordinate;
import org.sonatype.nexus.repository.rubygems.RubygemsFile;
import org.sonatype.nexus.repository.rubygems.internal.GZippedTempStreamSupplier;
import org.sonatype.nexus.repository.rubygems.internal.RubygemsCommonUtils;
import org.sonatype.nexus.repository.rubygems.marshal.Marshal;
import org.sonatype.nexus.repository.rubygems.marshal.SpecsIndex;
import org.sonatype.nexus.repository.storage.Asset;
import org.sonatype.nexus.repository.storage.Bucket;
import org.sonatype.nexus.repository.storage.StorageTx;

public class SpecsIndexUtils {
    private static final Logger log = (Logger)Preconditions.checkNotNull((Object)Loggers.getLogger(SpecsIndexUtils.class));

    private SpecsIndexUtils() {
    }

    @Nullable
    public static Asset findSpecsIndex(@NotNull StorageTx tx, @NotNull Bucket bucket, @NotNull String name) {
        return RubygemsCommonUtils.findAsset(tx, bucket, name);
    }

    public static Asset createSpecsIndex(StorageTx tx, Bucket bucket, Repository repository, String name) {
        Asset asset = (Asset)tx.createAsset(bucket, repository.getFormat()).name(name);
        asset.formatAttributes().set("asset_kind", (Object)AssetKind.SPECS_INDEX.name());
        return asset;
    }

    @NotNull
    public static Asset getSpecsIndex(@NotNull StorageTx tx, @NotNull Bucket bucket, @NotNull Repository repository, @NotNull String name) throws IOException {
        Asset asset = SpecsIndexUtils.findSpecsIndex(tx, bucket, name);
        if (asset == null) {
            asset = SpecsIndexUtils.createSpecsIndex(tx, bucket, repository, name);
        }
        return asset;
    }

    @NotNull
    public static SpecsIndex asSpecsIndex(@NotNull StorageTx tx, @NotNull Asset asset) throws IOException {
        if (asset.isNew()) {
            return new SpecsIndex();
        }
        Blob blob = tx.requireBlob(asset.requireBlobRef());
        Throwable throwable = null;
        Object var4_5 = null;
        try (GZIPInputStream is = new GZIPInputStream(blob.getInputStream());){
            return Marshal.loadAs(is, SpecsIndex.class);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    public static void updateSpecsIndex(@NotNull StorageTx tx, @NotNull Asset specs, @NotNull SpecsIndex index) throws IOException {
        Throwable throwable = null;
        Object var4_5 = null;
        try (GZippedTempStreamSupplier streamSupplier = new GZippedTempStreamSupplier(Marshal.dumpAsInputStream(index));){
            RubygemsCommonUtils.updateAsset(tx, specs, streamSupplier);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    public static void addToSpecsIndex(@NotNull StorageTx tx, @NotNull Bucket bucket, @NotNull Repository repository, @NotNull GemCoordinate coordinate) throws IOException {
        log.trace("Adding {} to specs-index", (Object)coordinate);
        String path = coordinate.isPrereleaseGem() ? RubygemsFile.PRERELEASE_SPECS_4_8_GZ : RubygemsFile.SPECS_4_8_GZ;
        Asset asset = SpecsIndexUtils.getSpecsIndex(tx, bucket, repository, path);
        SpecsIndex index = SpecsIndexUtils.asSpecsIndex(tx, asset);
        index.add(coordinate);
        SpecsIndexUtils.updateSpecsIndex(tx, asset, index);
        if (!coordinate.isPrereleaseGem()) {
            SpecsIndexUtils.updateLatestSpecsIndex(tx, bucket, repository, index);
        }
    }

    public static void deleteFromSpecsIndex(@NotNull StorageTx tx, @NotNull Bucket bucket, @NotNull Repository repository, @NotNull GemCoordinate coordinate) throws IOException {
        log.trace("Deleting {} to specs-index", (Object)coordinate);
        String path = coordinate.isPrereleaseGem() ? RubygemsFile.PRERELEASE_SPECS_4_8_GZ : RubygemsFile.SPECS_4_8_GZ;
        Asset asset = SpecsIndexUtils.findSpecsIndex(tx, bucket, path);
        if (asset == null) {
            return;
        }
        SpecsIndex index = SpecsIndexUtils.asSpecsIndex(tx, asset);
        index.remove(coordinate);
        SpecsIndexUtils.updateSpecsIndex(tx, asset, index);
        if (!coordinate.isPrereleaseGem()) {
            SpecsIndexUtils.updateLatestSpecsIndex(tx, bucket, repository, index);
        }
    }

    public static void updateLatestSpecsIndex(@NotNull StorageTx tx, @NotNull Bucket bucket, @NotNull Repository repository, @NotNull SpecsIndex index) throws IOException {
        Asset latest = SpecsIndexUtils.getSpecsIndex(tx, bucket, repository, RubygemsFile.LATEST_SPECS_4_8_GZ);
        SpecsIndexUtils.updateSpecsIndex(tx, latest, index.toLatest());
    }
}

