/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.repository.rubygems.internal;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.dataformat.yaml.YAMLFactory;
import com.google.common.base.Preconditions;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.util.Map;
import org.apache.commons.io.IOUtils;
import org.yaml.snakeyaml.DumperOptions;
import org.yaml.snakeyaml.Yaml;
import org.yaml.snakeyaml.constructor.BaseConstructor;
import org.yaml.snakeyaml.constructor.Constructor;
import org.yaml.snakeyaml.error.YAMLException;
import org.yaml.snakeyaml.nodes.Tag;
import org.yaml.snakeyaml.reader.UnicodeReader;
import org.yaml.snakeyaml.representer.Representer;
import org.yaml.snakeyaml.resolver.Resolver;

public class YamlParser {
    private static final ObjectMapper mapper = new ObjectMapper((JsonFactory)new YAMLFactory());

    public Map<String, Object> load(InputStream is) throws IOException {
        Map map;
        Preconditions.checkNotNull((Object)is);
        String data = IOUtils.toString((Reader)new UnicodeReader(is));
        try {
            Yaml yaml = new Yaml((BaseConstructor)new Constructor(), new Representer(), new DumperOptions(), (Resolver)new CustomResolver());
            map = (Map)yaml.load(data.replaceAll("!ruby/object.*", "").replaceAll("!binary.*", ""));
        }
        catch (YAMLException yAMLException) {
            map = (Map)mapper.readValue(data, Map.class);
        }
        return map;
    }

    public static class CustomResolver
    extends Resolver {
        protected void addImplicitResolvers() {
            this.addImplicitResolver(Tag.BOOL, BOOL, "yYnNtTfFoO");
            this.addImplicitResolver(Tag.FLOAT, FLOAT, "-+0123456789.");
            this.addImplicitResolver(Tag.INT, INT, "-+0123456789");
            this.addImplicitResolver(Tag.MERGE, MERGE, "<");
            this.addImplicitResolver(Tag.NULL, NULL, "~nN\u0000");
            this.addImplicitResolver(Tag.NULL, EMPTY, null);
        }
    }
}

