/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.repository.rubygems.marshal;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.sonatype.nexus.repository.rubygems.GemCoordinate;
import org.sonatype.nexus.repository.rubygems.marshal.BundlerDependency;
import org.sonatype.nexus.repository.rubygems.marshal.GemRequirement;
import org.sonatype.nexus.repository.rubygems.marshal.GemSpecification;
import org.sonatype.nexus.repository.rubygems.marshal.Marshaled;
import org.sonatype.nexus.repository.rubygems.marshal.RubyString;
import org.sonatype.nexus.repository.rubygems.marshal.RubyTime;
import org.sonatype.nexus.repository.rubygems.marshal.Symbol;

public class BundlerGem
implements Marshaled<Object> {
    public static final Symbol NAME = Symbol.create("name");
    public static final Symbol NUMBER = Symbol.create("number");
    public static final Symbol PLATFORM = Symbol.create("platform");
    public static final Symbol DEPENDENCIES = Symbol.create("dependencies");
    public static final Symbol RUBYGEMS_VERSION = Symbol.create("rubygems_version");
    public static final Symbol RUBY_VERSION = Symbol.create("ruby_version");
    public static final Symbol CHECKSUM = Symbol.create("checksum");
    public static final Symbol CREATED_AT = Symbol.create("created_at");
    private Map<Symbol, Object> data;
    private String id;

    BundlerGem() {
    }

    public BundlerGem(GemCoordinate coordinate) {
        this(coordinate, new LinkedList<BundlerDependency>());
    }

    private BundlerGem(GemCoordinate coordinate, List<BundlerDependency> dependencies) {
        this(coordinate.getName(), coordinate.getGemVersion().getVersion(), coordinate.getPlatform(), dependencies);
    }

    @VisibleForTesting
    BundlerGem(String name, String version, String platform) {
        this(name, version, platform, new LinkedList<BundlerDependency>());
    }

    private BundlerGem(String name, String version, String platform, List<BundlerDependency> dependencies) {
        LinkedHashMap<Symbol, Object> testData = new LinkedHashMap<Symbol, Object>();
        testData.put(NAME, new RubyString(name));
        testData.put(NUMBER, new RubyString(version));
        testData.put(PLATFORM, new RubyString(platform));
        testData.put(DEPENDENCIES, dependencies);
        this.marshalLoad(testData);
    }

    public BundlerGem(GemSpecification gemspec) {
        this(gemspec.getCoordinate(), gemspec.getBundlerDependencies());
    }

    public void setRubyVersion(GemRequirement version) {
        Preconditions.checkNotNull((Object)version);
        this.data.put(RUBY_VERSION, version.versionConstraints()[0]);
    }

    public void setRubygemsVersion(GemRequirement version) {
        Preconditions.checkNotNull((Object)version);
        this.data.put(RUBYGEMS_VERSION, version.versionConstraints()[0]);
    }

    public void setChecksum(String checksum) {
        this.data.put(CHECKSUM, checksum);
    }

    public void setCreatedAt(RubyTime time) {
        if (time != null) {
            this.data.put(CREATED_AT, time.formatted());
        }
    }

    public String getName() {
        return this.data.get(NAME).toString();
    }

    public String getVersion() {
        return this.data.get(NUMBER).toString();
    }

    public void addAll(List<BundlerDependency> dependencies) {
        ((List)this.data.get(DEPENDENCIES)).addAll(dependencies);
    }

    @Override
    public Object marshalDump() {
        return this.data;
    }

    @Override
    public void marshalLoad(Object data) {
        this.data = (Map)data;
        this.id = this.data.get(NAME) + "-" + this.data.get(NUMBER) + "-" + this.data.get(PLATFORM);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BundlerGem that = (BundlerGem)o;
        return !(this.id != null ? !this.id.equals(that.id) : that.id != null);
    }

    public int hashCode() {
        return this.id != null ? this.id.hashCode() : 0;
    }

    public String toString() {
        return this.data.toString();
    }
}

