/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.repository.rubygems.marshal;

import com.google.common.base.Preconditions;
import java.util.Map;
import java.util.regex.Pattern;
import javax.validation.constraints.NotNull;
import org.sonatype.nexus.repository.rubygems.marshal.RubyString;
import org.sonatype.nexus.repository.rubygems.marshal.UserMarshaled;

public class GemVersion
extends UserMarshaled<Object>
implements Comparable<GemVersion> {
    private static Pattern isReleaseVersion = Pattern.compile("^[0-9.]*$");

    GemVersion() {
        super("Gem::Version");
    }

    public GemVersion(String version) {
        this();
        Preconditions.checkNotNull((Object)version);
        this.setData(new RubyString(version));
    }

    public GemVersion(Map<String, String> data) {
        this(data.get("version"));
    }

    public boolean isPrereleaseGem() {
        return !isReleaseVersion.matcher(this.getVersion()).matches();
    }

    @NotNull
    public String getVersion() {
        return this.getData().toString();
    }

    @Override
    public int compareTo(GemVersion o) {
        String[] thisParts = this.getVersion().split("[.]");
        String[] otherParts = o.getVersion().split("[.]");
        int len = Math.max(thisParts.length, otherParts.length);
        int i = 0;
        while (i < len) {
            String thisPart = i < thisParts.length ? thisParts[i] : "0";
            String otherPart = i < otherParts.length ? otherParts[i] : "0";
            boolean isThisNumber = thisPart.matches("^[0-9]+$");
            boolean isOtherNumber = otherPart.matches("^[0-9]+$");
            if (isThisNumber && !isOtherNumber) {
                return 1;
            }
            if (!isThisNumber && isOtherNumber) {
                return -1;
            }
            long result = isThisNumber && isOtherNumber ? (thisPart.length() == otherPart.length() ? (long)thisPart.compareTo(otherPart) : (long)(thisPart.length() - otherPart.length())) : (long)thisPart.compareTo(otherPart);
            if (result != 0L) {
                return (int)result;
            }
            ++i;
        }
        return 0;
    }
}

