/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.nexus.repository.rubygems.marshal;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigInteger;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.sonatype.nexus.repository.rubygems.marshal.IVar;
import org.sonatype.nexus.repository.rubygems.marshal.Marshaled;
import org.sonatype.nexus.repository.rubygems.marshal.ObjectCache;
import org.sonatype.nexus.repository.rubygems.marshal.RawString;
import org.sonatype.nexus.repository.rubygems.marshal.RubyObject;
import org.sonatype.nexus.repository.rubygems.marshal.Symbol;
import org.sonatype.nexus.repository.rubygems.marshal.UserDefMarshaled;
import org.sonatype.nexus.repository.rubygems.marshal.UserMarshaled;

public class MarshalLoad {
    private static Map<Byte, LoadVisitor> loaders = new HashMap<Byte, LoadVisitor>();
    private final Symbol.Factory factory = new Symbol.Factory();
    private final ObjectCache cache = new ObjectCache();

    static {
        loaders.put((byte)91, new ListLoadVisitor());
        loaders.put((byte)123, new MapLoadVisitor());
        loaders.put((byte)48, new NullLoadVisitor());
        loaders.put((byte)105, new IntegerLoadVisitor());
        loaders.put((byte)84, new TrueLoadVisitor());
        loaders.put((byte)70, new FalseLoadVisitor());
        loaders.put((byte)58, new SymbolLoadVisitor());
        loaders.put((byte)59, new SymbolReferenceLoadVisitor());
        loaders.put((byte)34, new RawStringLoadVisitor());
        loaders.put((byte)73, new IVarLoadVisitor());
        loaders.put((byte)85, new UserMarshaledLoadVisitor());
        loaders.put((byte)117, new UserDefMarshaledLoadVisitor());
        loaders.put((byte)64, new ObjectReferenceLoadVisitor());
        loaders.put((byte)111, new RubyObjectLoadVisitor());
    }

    public <T extends Marshaled<?>> T fromBytesAs(byte[] bytes, Class<T> clazz) throws IOException {
        return this.fromBytesAs(new ByteArrayInputStream(bytes), clazz);
    }

    public <T extends Marshaled> T fromBytesAs(InputStream is, Class<T> clazz) throws IOException {
        Object obj = this.fromBytes(is);
        if (obj instanceof UserDefMarshaled) {
            return (T)((Marshaled)clazz.cast(obj));
        }
        try {
            Marshaled result = (Marshaled)clazz.newInstance();
            result.marshalLoad(obj);
            return (T)result;
        }
        catch (IllegalAccessException | InstantiationException e) {
            throw new IOException(e);
        }
    }

    public Object fromBytes(byte[] bytes) throws IOException {
        return this.fromBytes(new ByteArrayInputStream(bytes));
    }

    public Object fromBytes(InputStream is) throws IOException {
        byte b = this.loadByte(is);
        if (b != 4) {
            throw new IllegalArgumentException("not an ruby marshaled object - expected first byte 4 and not " + b);
        }
        b = this.loadByte(is);
        if (b != 8) {
            throw new IllegalArgumentException("not an ruby marshaled object - expected second byte 8 and not " + b);
        }
        return this.loadObject(is);
    }

    private Object loadObject(InputStream is) throws IOException {
        byte b = this.loadByte(is);
        LoadVisitor loadVisitor = loaders.get(b);
        if (loadVisitor == null) {
            throw new RuntimeException("unknown object code: '" + Character.toString((char)b) + "' (" + b + ")");
        }
        return loadVisitor.accept(this, is);
    }

    private byte loadByte(InputStream is) throws IOException {
        int b = is.read();
        if (b == -1) {
            throw new IOException("end of stream");
        }
        return (byte)b;
    }

    private int loadInteger(InputStream is) throws IOException {
        int i = this.loadByte(is);
        if (i > 0) {
            if (i > 5) {
                return i - 5;
            }
            byte[] bytes = new byte[4];
            Arrays.fill(bytes, (byte)0);
            int j = 0;
            while (j < i) {
                bytes[3 - j] = this.loadByte(is);
                ++j;
            }
            return new BigInteger(bytes).intValue();
        }
        if (i < 0) {
            if (i < -5) {
                return i + 5;
            }
            byte[] bytes = new byte[4];
            Arrays.fill(bytes, (byte)-1);
            int j = 0;
            while (j < -i) {
                bytes[3 - j] = this.loadByte(is);
                ++j;
            }
            return new BigInteger(bytes).intValue();
        }
        return 0;
    }

    private byte[] loadBytes(InputStream is) throws IOException {
        int len = this.loadInteger(is);
        byte[] bytes = new byte[len];
        int i = 0;
        while (i < len) {
            bytes[i] = this.loadByte(is);
            ++i;
        }
        return bytes;
    }

    static class FalseLoadVisitor
    implements LoadVisitor {
        FalseLoadVisitor() {
        }

        @Override
        public Object accept(MarshalLoad marshal, InputStream is) throws IOException {
            return false;
        }
    }

    static class IVarLoadVisitor
    implements LoadVisitor {
        IVarLoadVisitor() {
        }

        @Override
        public Object accept(MarshalLoad marshal, InputStream is) throws IOException {
            IVar<Object> ivar = new IVar<Object>(marshal.loadObject(is));
            int len = marshal.loadInteger(is);
            int i = 0;
            while (i < len) {
                ivar.put((Symbol)marshal.loadObject(is), marshal.loadObject(is));
                ++i;
            }
            marshal.cache.add(ivar);
            return ivar;
        }
    }

    static class IntegerLoadVisitor
    implements LoadVisitor {
        IntegerLoadVisitor() {
        }

        @Override
        public Integer accept(MarshalLoad marshal, InputStream is) throws IOException {
            return marshal.loadInteger(is);
        }
    }

    static class ListLoadVisitor
    implements LoadVisitor {
        ListLoadVisitor() {
        }

        @Override
        public List<Object> accept(MarshalLoad marshal, InputStream is) throws IOException {
            int size = marshal.loadInteger(is);
            ArrayList<Object> result = new ArrayList<Object>(size);
            marshal.cache.add(result);
            int i = 0;
            while (i < size) {
                result.add(marshal.loadObject(is));
                ++i;
            }
            return result;
        }
    }

    static interface LoadVisitor {
        public Object accept(MarshalLoad var1, InputStream var2) throws IOException;
    }

    static class MapLoadVisitor
    implements LoadVisitor {
        MapLoadVisitor() {
        }

        @Override
        public Map<Object, Object> accept(MarshalLoad marshal, InputStream is) throws IOException {
            int size = marshal.loadInteger(is);
            LinkedHashMap<Object, Object> result = new LinkedHashMap<Object, Object>(size);
            marshal.cache.add(result);
            int i = 0;
            while (i < size) {
                result.put(marshal.loadObject(is), marshal.loadObject(is));
                ++i;
            }
            return result;
        }
    }

    static class NullLoadVisitor
    implements LoadVisitor {
        NullLoadVisitor() {
        }

        @Override
        public Object accept(MarshalLoad marshal, InputStream is) throws IOException {
            return null;
        }
    }

    static class ObjectReferenceLoadVisitor
    implements LoadVisitor {
        ObjectReferenceLoadVisitor() {
        }

        @Override
        public Object accept(MarshalLoad marshal, InputStream is) throws IOException {
            int index = marshal.loadInteger(is);
            return marshal.cache.get(index);
        }
    }

    static class RawStringLoadVisitor
    implements LoadVisitor {
        RawStringLoadVisitor() {
        }

        @Override
        public RawString accept(MarshalLoad marshal, InputStream is) throws IOException {
            byte[] bytes = marshal.loadBytes(is);
            RawString result = new RawString(bytes);
            marshal.cache.add(result);
            return result;
        }
    }

    static class RubyObjectLoadVisitor
    implements LoadVisitor {
        RubyObjectLoadVisitor() {
        }

        @Override
        public Object accept(MarshalLoad marshal, InputStream is) throws IOException {
            RubyObject result;
            Symbol classConstant = (Symbol)marshal.loadObject(is);
            String className = classConstant.name.replace(":", "");
            try {
                String fullClassName = String.valueOf(this.getClass().getPackage().getName()) + "." + className;
                Class<?> clazz = this.getClass().getClassLoader().loadClass(fullClassName);
                result = (RubyObject)clazz.newInstance();
            }
            catch (ClassNotFoundException classNotFoundException) {
                result = new RubyObject(classConstant);
            }
            catch (InstantiationException e) {
                throw new IOException("could not instantiate " + className, e);
            }
            catch (IllegalAccessException e) {
                throw new IOException(className, e);
            }
            marshal.cache.add(result);
            int len = marshal.loadInteger(is);
            int i = 0;
            while (i < len) {
                result.put((Symbol)marshal.loadObject(is), marshal.loadObject(is));
                ++i;
            }
            return result;
        }
    }

    static class SymbolLoadVisitor
    implements LoadVisitor {
        SymbolLoadVisitor() {
        }

        @Override
        public Symbol accept(MarshalLoad marshal, InputStream is) throws IOException {
            byte[] bytes = marshal.loadBytes(is);
            return marshal.factory.create(new String(bytes, Charset.forName("UTF-8")));
        }
    }

    static class SymbolReferenceLoadVisitor
    implements LoadVisitor {
        SymbolReferenceLoadVisitor() {
        }

        @Override
        public Symbol accept(MarshalLoad marshal, InputStream is) throws IOException {
            return marshal.factory.get(marshal.loadInteger(is));
        }
    }

    static class TrueLoadVisitor
    implements LoadVisitor {
        TrueLoadVisitor() {
        }

        @Override
        public Object accept(MarshalLoad marshal, InputStream is) throws IOException {
            return true;
        }
    }

    static class UserDefMarshaledLoadVisitor
    implements LoadVisitor {
        UserDefMarshaledLoadVisitor() {
        }

        @Override
        public UserDefMarshaled<?> accept(MarshalLoad marshal, InputStream is) throws IOException {
            UserDefMarshaled result;
            Symbol constant = (Symbol)marshal.loadObject(is);
            String className = constant.name.replace(":", "");
            try {
                String fullClassName = String.valueOf(this.getClass().getPackage().getName()) + "." + className;
                Class<?> clazz = this.getClass().getClassLoader().loadClass(fullClassName);
                result = (UserDefMarshaled)clazz.newInstance();
            }
            catch (ClassNotFoundException e) {
                throw new RuntimeException("not implement", e);
            }
            catch (InstantiationException e) {
                throw new IOException("could not instantiate " + className, e);
            }
            catch (IllegalAccessException e) {
                throw new IOException(className, e);
            }
            marshal.cache.add(result);
            result.marshalLoad(marshal.loadBytes(is));
            return result;
        }
    }

    static class UserMarshaledLoadVisitor
    implements LoadVisitor {
        UserMarshaledLoadVisitor() {
        }

        @Override
        public UserMarshaled<?> accept(MarshalLoad marshal, InputStream is) throws IOException {
            UserMarshaled result;
            Symbol constant = (Symbol)marshal.loadObject(is);
            String className = constant.name.replace(":", "");
            try {
                String fullClassName = String.valueOf(this.getClass().getPackage().getName()) + "." + className;
                Class<?> clazz = this.getClass().getClassLoader().loadClass(fullClassName);
                result = (UserMarshaled)clazz.newInstance();
            }
            catch (ClassNotFoundException classNotFoundException) {
                result = new UserMarshaled(constant);
            }
            catch (InstantiationException e) {
                throw new IOException("could not instantiate " + className, e);
            }
            catch (IllegalAccessException e) {
                throw new IOException(className, e);
            }
            marshal.cache.add(result);
            result.marshalLoad(marshal.loadObject(is));
            return result;
        }
    }
}

